
// Glenn's POV-Ray Animation File - Bobsled Shot 180
// created 1-Dec-02
// last update 25-Dec-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <430*Feet,980*Feet,0>;
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#declare SledPos = <0,0,2*Feet>+y*(80*Feet-16*Feet*Seconds-.3*Feet*Seconds*Seconds);

#if ( Debug = 1) #debug concat("SledPos:","<",str(SledPos.x,5,0),",",str(SledPos.y,5,0),",",str(SledPos.z,5,0),">","\n") #end
#if ( Debug = 1) #debug concat("Seconds: ",str(Seconds,5,3),"\n") #end

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 35
//  location  <-0.2*Feet,12*Feet, 18*Feet>
  location  <2.2*Feet,12*Feet, 18*Feet>
  look_at   <-1*Feet*Seconds-1*Feet*Seconds*Seconds,-40*Feet , 11.5*Feet >
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 11
//    direction z*50
//  location  <2*Feet, 50*Feet, 140*Feet> // overhead
//  look_at   <3*Feet, -0*Feet, 0*Feet >
  location  <-5*Feet,-30*Feet, 19*Feet> // scene view
  look_at   <0*Feet,10*Feet , 15*Feet >
  }

camera {
//  Special_Cam
  Render_Cam
		translate <-2*Feet*Seconds,-10*Feet*Seconds+.4*Feet*Seconds*Seconds,.4*Feet*Seconds*Seconds>
  }

//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}


//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <6*Feet,30*Feet,13*Feet> }
object { TrackLight translate <6*Feet,0*Feet,13*Feet> }
object { TrackLight translate <6*Feet,-30*Feet,13*Feet> }

#declare RS = seed(58218);
#declare TL = 1;
#while (TL < 30)
	object { TrackLight translate <rand(RS)*-180*Feet,-100*Feet+rand(RS)*-500*Feet,3*Feet> }
	#declare TL = TL + 1;
#end

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"
object { Plain rotate x*-17 translate -LocalOrigin }
object { TrackTerrain translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }

#include "TrackMaker.inc"
object { TotalTrack translate -LocalOrigin+<0,0,2*Feet> }

#declare StartingGround =
	union {
		box { <-40*Feet,0,-20*Feet>,<40*Feet,100*Feet,0> }
		box { <4*Feet,0,-20*Feet>,<40*Feet,40*Feet,12> }
		box { <-40*Feet,0,-20*Feet>,<-4*Feet,40*Feet,12> }
		texture { IcyTex }
	} // end union


//===============================================
//             Objects
//===============================================

#include "Bobsled.inc"

#declare SideHandle =
	intersection {
		cylinder {
			<-2,0,0>,<2,0,0>,12
		}
		cylinder {
			<-1.2,0,0>,<1.2,0,0>,11.2
			inverse
		}
		box {
			<-0.7,-13,-4>,<0.7,0,8>
		}
//		texture { GlossyBlack }
			texture { pigment { color rgb<0.1,0.13,0.13> } }
	} // end intersection

#declare SlottedSledSFull =
	difference {
		object { BobsledSFull }
		box {
			<-0.7,-13,-4>,<0.7,0,8>
			texture { pigment { color rgb<0,0,0> } }
			translate <40,0,16>
		}
	} // end difference

#switch (Seconds)
#range (0,0.3)
#declare SledGroup =
	union {
		object { SlottedSledSFull }
		object { SideHandle
			translate <0,10,-6> rotate x*-90 translate <0,-10,6>
			translate <40,0,16>
		}
	} // end union
#break
#range (0.301,1.3)
#declare SledGroup =
	union {
		object { SlottedSledSFull }
		object { SideHandle
			translate <0,10,-6> rotate x*(-90+60*(Seconds-0.3)+30*Seconds*Seconds) translate <0,-10,6>
			translate <40,0,16>
		}
	} // end union
#break
#else
#declare SledGroup =
	union {
		object { SlottedSledSFull }
	} // end union
#end

//===============================================
//             Object Placement
//===============================================

object { StartingGround translate <0,0,13*Feet> }


//sled moving at 16 ft/s
object { SledGroup
	rotate z*90
//	translate <0,-10*Feet-Sclock*30*Feet,13*Feet>
//#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot
	translate y*(80*Feet-16*Feet*Seconds-2.8*Feet*Seconds*Seconds)
	rotate x*6
	translate P1
	translate -LocalOrigin+<0,0,2*Feet> 
}
