
// Glenn's POV-Ray Animation File - Bobsled Shot 230
// created 4-Dec-02
// last update 4-Dec-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <310*Feet,810*Feet,0>; // center of turn 2
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#include "TrackMaker.inc"

//#declare SledPos = <0,40*Feet,2*Feet>;
#declare SledPos = <0,40*Feet,4*Feet>;
#declare SledPos = vrotate (SledPos,z*(10+160*(Seconds/4.2)));

#if ( Debug = 1) #debug concat("SledPos:","<",str(SledPos.x,5,0),",",str(SledPos.y,5,0),",",str(SledPos.z,5,0),">","\n") #end


//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 45-9*Seconds
//  location  <0*Feet,0, 12*Feet>
//  location  <0*Feet,0, 14*Feet>
  location  <0*Feet-2.5*Feet*Seconds,0-4*Feet*Seconds, 14*Feet>
  look_at   SledPos+<0,0*Feet,5*Feet>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 11
//    direction z*50
//  location  <2*Feet, 50*Feet, 140*Feet> // overhead
//  look_at   <3*Feet, -0*Feet, 0*Feet >
  location  <-5*Feet,-30*Feet, 19*Feet> // scene view
  look_at   <0*Feet,10*Feet , 15*Feet >
  }

camera {
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}


//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <24*Feet,0*Feet,2*Feet> }
object { TrackLight translate <0*Feet,-24*Feet,2*Feet> }
object { TrackLight translate <16*Feet,-16*Feet,2*Feet> }

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"
object { Plain rotate x*-17 translate -LocalOrigin }
object { TrackTerrain translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }


//object { TotalTrack translate -LocalOrigin+<0,0,2*Feet> }
object { TotalTrack translate -LocalOrigin+<0,0,4*Feet> }

//===============================================
//             Objects
//===============================================

#include "Bobsled.inc"
#include "AnimMacros.inc"

//===============================================
//             Object Placement
//===============================================


object { BobsledSFull
	rotate <0,-4,-6+2*Seconds>
	translate <0,0,-6*Feet> // set on turn
	rotate <49+Shake(1,10498,Seconds)*5,0,0>
//	translate <0,40*Feet,6*Feet+2*Feet>
	translate <0,40*Feet,6*Feet+4*Feet>
	rotate z*(10+180*(Seconds/4.2))
}
