
// Glenn's POV-Ray Animation File - Bobsled Shot 275
// created 8-Jan-03
// last update 10-Jan-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <250*Feet,570*Feet,0>; // end of straight 8
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#include "AnimMacros.inc"
#include "TrackMaker.inc"
//#declare RotorSeed=seed(Seconds*980001);
//#include "Helicopter.inc"

// 95 ft/sec
#declare SledPos = <0,100*Feet,2*Feet>;
#declare SledPos = SledPos + <0,-95*Feet*Seconds,0>;
#declare CamLook = <-60*Feet+40*Feet*Seconds-10*Feet*Seconds*Seconds,140*Feet-40*Feet*Seconds,0>;

#if ( Debug = 1) #debug concat("SledPos:","<",str(SledPos.x,5,0),",",str(SledPos.y,5,0),",",str(SledPos.z,5,0),">","\n") #end
#if ( Debug = 1) #debug concat("Seconds: ",str(Seconds,5,3),"\n") #end

//===============================================
//             Cameras
//===============================================


#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.2,  0.9>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 45
  location  <-40*Feet,-2.6*Feet,8.15*Feet>
  look_at   <-100*Feet,14*Feet,2*Feet> 
}



#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 65
//    direction z*50
  location  <-50*Feet, -30*Feet, 30*Feet> // overhead
  look_at   <-60*Feet, -0*Feet, 10*Feet >
  }

#if (Seconds < 1.10)
	camera {
	  Render_Cam
	 }
#else // wind shake after the sled goes by
	camera {
	  Render_Cam
		rotate x*Shake(8,30198,(Seconds-1.10))*3
	 }
#end

//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}


//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <-14*Feet,20*Feet,2*Feet> }
object { TrackLight translate <-14*Feet,80*Feet,2*Feet> }
object { TrackLight rotate z*-45 translate <-40*Feet,-24*Feet,2*Feet> }
object { TrackLight rotate z*45 translate <-40*Feet,130*Feet,2*Feet> }

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"
object { Plain rotate x*-17 translate -LocalOrigin }
object { TrackTerrain translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }


object { TotalTrack translate -LocalOrigin+<0,0,5*Feet> }
background { color rgb<.71,.81,1> }

//===============================================
//             Objects
//===============================================

#include "Bobsled.inc"

#declare WCSign =
	union {
		box {
			<-1*Feet,0,0>,<0*Feet,20*Feet,30>
			texture { pigment { rgb<.2,0.2,0.8> } }
		}
		text {
			ttf "arialbd.ttf"
			"World Championships"
			1,0
			rotate x*90
			scale <20,1,20>
			rotate z*90
			translate <-0.1,10,10>
			texture { pigment { rgb<1,1,1>} finish { ambient .4 } }
		}
	} // end union


//===============================================
//             Object Placement
//===============================================

// speed 95 ft/s
// LocalOrigin at P9 is <320*Feet,400*Feet,0>; // end of straight 9

object { WCSign translate <-75.3*Feet,-8*Feet,11*Feet> }

object { BobsledSFull
	rotate z*180
	translate <-145*Feet+(95*Feet*Seconds),0*Feet+(-1*Feet*Seconds),5*Feet>
}
/*
object { Chopper9
	rotate z*180
	rotate x*-15*Seconds
	translate x*30*Feet*Seconds
	rotate z*20
	translate <-90*Feet,-70*Feet,260*Feet>
}
*/


