
// Glenn's POV-Ray Animation File - Bobsled Shot 280
// created 6-Dec-02
// last update 5-Jan-03
// 2002 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <320*Feet,400*Feet,0>; // end of straight 9
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#include "TrackMaker.inc"
#declare RotorSeed=seed(Seconds*980001);
#include "Helicopter.inc"

// 95 ft/sec
#declare SledPos = <0,100*Feet,2*Feet>;
#declare SledPos = SledPos + <0,-95*Feet*Seconds,0>;
#declare CamLook = <-60*Feet+40*Feet*Seconds-10*Feet*Seconds*Seconds,140*Feet-40*Feet*Seconds,0>;

#if ( Debug = 1) #debug concat("SledPos:","<",str(SledPos.x,5,0),",",str(SledPos.y,5,0),",",str(SledPos.z,5,0),">","\n") #end
#if ( Debug = 1) #debug concat("Seconds: ",str(Seconds,5,3),"\n") #end

//===============================================
//             Cameras
//===============================================

#if (Seconds < 2)
#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 55-20*Seconds
  location  <-100*Feet-40*Feet*Seconds,-130*Feet+20*Feet*Seconds,400*Feet>
  look_at   CamLook + <0*Feet,-0*Feet,8*Feet> 
}
#else
#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 55-20*2
  location  <-100*Feet-40*Feet*Seconds,-130*Feet+20*Feet*Seconds,400*Feet>
  look_at   CamLook + <0*Feet,-0*Feet,8*Feet> 
}
#end

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 65
//    direction z*50
//  location  <2*Feet, 50*Feet, 140*Feet> // overhead
//  look_at   <3*Feet, -0*Feet, 0*Feet >
  location  SledPos + <-3*Feet,1.5*Feet, 120*Feet>
  look_at   SledPos +<3*Feet,1.5*Feet, 320> 
  }


camera {
//  Special_Cam
  Render_Cam
  }


//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}


//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <-14*Feet,20*Feet,2*Feet> }
object { TrackLight translate <-14*Feet,80*Feet,2*Feet> }
object { TrackLight rotate z*-45 translate <-40*Feet,-24*Feet,2*Feet> }
object { TrackLight rotate z*45 translate <-40*Feet,130*Feet,2*Feet> }

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"
object { Plain rotate x*-17 translate -LocalOrigin }
object { TrackTerrain translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }


object { TotalTrack translate -LocalOrigin+<0,0,5*Feet> }
background { color rgb<.71,.81,1> }

//===============================================
//             Objects
//===============================================

#include "Bobsled.inc"


//===============================================
//             Object Placement
//===============================================

// 4-second shot (was 2-seconds)
// speed 95 ft/s
// LocalOrigin at P9 is <320*Feet,400*Feet,0>; // end of straight 9
// P8 is <250*Feet,570*Feet,0> beginning of turn 8 with radius 70

#switch (Seconds)
#range (0,1.0)
object { BobsledSFull
	rotate z*180
	translate <-70*Feet-95*Feet+(95*Feet*Seconds),170*Feet,5*Feet>
}
#break
#range (1.001,1.5)
//#if ( Sclock < 0.5 )
object { BobsledSFull
	rotate z*90
	translate <0,0,-6*Feet>
	rotate y*(0-120*(Seconds-1))
	translate <70*Feet,0,0>
	rotate z*(90-90*(Seconds-1))
	translate <-70*Feet,100*Feet,6*Feet+5*Feet>
}
#break
#range (1.501,2.0)
//#if ( Sclock < 0.5 )
object { BobsledSFull
	rotate z*90
	translate <0,0,-6*Feet>
	rotate y*(-60+120*(Seconds-1.5))
	translate <70*Feet,0,0>
	rotate z*(90-90*(Seconds-1))
	translate <-70*Feet,100*Feet,6*Feet+5*Feet>
}
#break
#range (2.001,3.0526)
object { BobsledSFull
	rotate z*90
	translate <0,100*Feet+(-95*Feet*(Seconds-2.0)),5*Feet>
}
#break
#else
object { BobsledSFull
	rotate z*0
	translate <0,0,-6*Feet>
	rotate y*(0-40*(Seconds-3.0526))
	translate <0,-50*Feet,0>
	rotate z*(90-90*(Seconds-3.0526))
	translate <-50*Feet,0*Feet,6*Feet+5*Feet>
}
#end

object { Chopper9
	rotate z*180
	rotate x*-15*Seconds
	translate x*30*Feet*Seconds
	rotate z*20
	translate <-90*Feet,-70*Feet,260*Feet>
}