
// Glenn's POV-Ray Animation File - Bobsled Shot 310
// created 10-Dec-02
// last update 14-Dec-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <320*Feet,400*Feet,0>; // end of straight 9
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#include "TrackMaker.inc"

// 95 ft/sec, half speed slo-mo
#declare SledPos = <0,60*Feet,2*Feet>;
#declare SledPos = SledPos + <0,-50*Feet*Seconds,0>;

#if ( Debug = 1) #debug concat("SledPos:","<",str(SledPos.x,5,0),",",str(SledPos.y,5,0),",",str(SledPos.z,5,0),">","\n") #end


//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 35
  location  SledPos + <1*Feet,7*Feet,3*Feet>
  look_at   SledPos + <-8,5.6*Feet+0.4*Feet*Seconds,20>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 65
//    direction z*50
//  location  <2*Feet, 50*Feet, 140*Feet> // overhead
//  look_at   <3*Feet, -0*Feet, 0*Feet >
  location  SledPos + <-3*Feet,1.5*Feet, 120*Feet>
  look_at   SledPos +<3*Feet,1.5*Feet, 320> 
  }


camera {
//  Special_Cam
  Render_Cam
  }


//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}


//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <-14*Feet,20*Feet,2*Feet> }
object { TrackLight translate <-14*Feet,80*Feet,2*Feet> }
object { TrackLight rotate z*-45 translate <-40*Feet,-24*Feet,2*Feet> }
object { TrackLight rotate z*45 translate <-40*Feet,130*Feet,2*Feet> }

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"
object { Plain rotate x*-17 translate -LocalOrigin }
object { TrackTerrain translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }


object { TotalTrack translate -LocalOrigin+<0,0,2*Feet> }


//===============================================
//             Objects
//===============================================

#include "Bobsled.inc"

#declare SledShell =
	difference {
		cylinder {
			<0,0,0>,<8*Feet,0,0>,31
		}
		cylinder {
			<0,0,0>,<8*Feet,0,0>,30
			texture {
				pigment {
					gradient x
					color_map {
						[ 0.2 rgb<0,0,0> ]
						[ 0.2 rgb<0.022,0.022,0.022> ]
					}
					scale 3
				}
			}
		}
		box {
			<0,-22,0>,<8*Feet,22,36>
		}
		texture { pigment { color rgb<0,0,0> } }
		translate <0,-14,12>
	} // end difference

#declare SeatRail =
	union {
		box {
			<0,0,-1>,<8*Feet,8,0>
		}
		cylinder {
			<0,0,0>,<8*Feet,0,0>,1
			translate <0,8,-1>
		}
		box {
			<0,0,-2>,<8*Feet,2,0>
			translate <0,10,0>
			texture { pigment { rgb<.06,.06,.053> } }
		}
		texture { pigment { rgb<.25,.21,.18> } }
	} // end union
#declare BrakeSign =
	union {
	box {
		<0,0.1,0>,<8,12,2>
		texture {
			pigment { rgb<1,1,1>*.4 }
		}
	}
	text {
		ttf "arial.ttf"
		"BRAKE"
		1,0
		rotate x*90
		scale <1.9,1,1.7>
		translate <1,1,0.5>
		texture {
			pigment { rgb<1,1,1>*.08 }
		}
	}
	} // end union
#declare Handle =
	union {
		cylinder { // main
			<0,0,0>,<0,0,10>,0.4
		}
		cylinder {
			<0,-1,0>,<0,1,0>,2
		}
		sphere { // glove
			<0,0,0>,1.5
			scale <1,0.6,1>
			translate <0,0,8>
			texture { SuitTex }
		}
		texture { SteelTex }
	} // end union
#declare Linkage =
	union {
		cylinder { <-30,0,0>,<0,0,0>,.18 }
		cylinder { <-6,0,0>,<-7.5,0,0>,.38 }
		texture { SteelTex }
	} // end union

#declare Arm =
	cone {
		<0,0,0>,1.0,<3*Feet,0,0>,2.2
		rotate z*-8
		texture { SuitTex }
	}

#declare Body =
	sphere {
		<0,0,0>,12
		scale <1,0.7,1.3>
		texture { SuitTex }
	}

#switch (Seconds)
#range (0,0.1)
	#declare BRot = -20;
#break

#range (0.101,0.8)
	#declare BRot =(-20+(Sclock-0.1)*50);
#break

#else
	#declare BRot = -20+0.7*50;
#end

#declare SledWithHandle =
	union {
		object { SledShell }
		object { SeatRail translate <0,0,12> }
		object { BrakeSign translate <5.2*Feet,14,20.5> }
		object { Handle rotate y*BRot translate <6*Feet,10,12> }
		object { Linkage rotate y*-BRot translate z*5 rotate y*BRot translate <6*Feet,10,11> }
		object { Arm rotate y*-BRot translate z*8 rotate y*BRot translate <6*Feet,10,12> }
		object { Body translate <4.7*Feet,0,20> }
	} // end union


//===============================================
//             Object Placement
//===============================================


// speed 95 ft/s
object { SledWithHandle
	rotate z*90
	translate SledPos
}



