
// Glenn's POV-Ray Animation File - Bobsled Shot 360
// created 13-Dec-02
// last update 13-Dec-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <320*Feet,170*Feet,0>; // impact point
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#include "TrackMaker.inc"

// 60 ft/sec
	#declare SledRot = <20*Seconds,0,0>;
	#declare SledPos = <0,62*Feet,40*Feet> + <0,-60*Feet*Seconds,-4*Feet*Seconds-32*Feet*Seconds*Seconds>;


//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 50-10*Seconds
  location  <60*Feet,12*Feet,28*Feet>
  look_at   SledPos+<0,0*Feet,-20*Feet+30*Feet*Seconds>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50-10*Seconds
//    direction z*50
//  location  <2*Feet, 50*Feet, 140*Feet> // overhead
//  look_at   <3*Feet, -0*Feet, 0*Feet >
  location  SledPos + <-3*Feet,1.5*Feet, 120*Feet>
  look_at   SledPos +<3*Feet,1.5*Feet, 320> 
  }


camera {
//  Special_Cam
  Render_Cam
  }


//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}


//===============================================
//             Lighting
//===============================================
/*
#include "TrackLights.inc"
object { TrackLight translate <-14*Feet,20*Feet,2*Feet> }
object { TrackLight translate <-14*Feet,80*Feet,2*Feet> }
object { TrackLight rotate z*-45 translate <-40*Feet,-24*Feet,2*Feet> }
object { TrackLight rotate z*45 translate <-40*Feet,130*Feet,2*Feet> }
*/
//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"
//object { Plain rotate x*-17 translate -LocalOrigin }
object { Plain rotate x*-17 translate -LocalOrigin+<0,-200*Feet,0> }
object { TrackTerrain translate -LocalOrigin }
//object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1200*Feet,220*Feet> translate -LocalOrigin }
//object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1000*Feet ,-500*Feet> translate -LocalOrigin }


object { TotalTrack translate -LocalOrigin+<0,0,2*Feet> }


//===============================================
//             Objects
//===============================================

#include "Bobsled.inc"
//#include "BobsledRed.inc"

#declare BobsledSFullLookingDown =
	union {
		object { BobsledS }
		object { HelmetGroup rotate z*(-113-3*Seconds) rotate y*-3 translate <61,0,31> } // pilot
		object { HelmetGroup rotate z*(-60+5*Seconds) rotate y*-12 rotate x*14*Seconds translate <83,0,28> } // brakeman
	} // end union


//===============================================
//             Object Placement
//===============================================

//object { RedsledS rotate z*90 rotate y*-120 rotate z*0 translate <2*Feet,20*Feet,2.5*Feet> }

// speed 95 ft/s
object { BobsledSFullLookingDown
	rotate z*90
	translate <0,-6*Feet,0>
		rotate x*SledRot
	translate <0, 6*Feet,0>
	translate SledPos
}

/*
cone {
	<0,0,0>,0,<0,0,30*Feet>,4*Feet
	texture { pigment { rgb<1,.3,.1> } }
}
*/
