
// Glenn's POV-Ray Animation File - Bobsled Shot 370
// created 13-Dec-02
// last update 13-Dec-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <320*Feet,170*Feet,0>; // impact point
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#include "TrackMaker.inc"

// 60 ft/sec
#switch (Seconds)
#range (0,1.4)
	#declare SledRot = <30,0,0>;
	#declare SledPos = <0,62*Feet,40*Feet>; // out of shot
#break
#range (1.401,1.500) // sled enters shot
	#declare SledRot = <30,0,0>;
	#declare SledPos = <0,10*Feet,13.4*Feet> + <0,-100*Feet*(Seconds-1.4),-120*Feet*(Seconds-1.4)>;
#break
#range (1.501,1.600) // sled bounces up
	#declare SledRot = <30-50*10*(Seconds-1.5),0,0>;
	#declare SledPos = <0,0,2*Feet> + <0,-70*Feet*(Seconds-1.5),2.5*Feet*10*(Seconds-1.5)>;
#break
#else
	#declare SledRot = <0,0,0>;
	#declare SledPos = <0,0,2*Feet> + <0,-70*Feet*(Seconds-1.5),0>;
#end
#if ( Debug = 1) #debug concat("SledPos:","<",str(SledPos.x,5,0),",",str(SledPos.y,5,0),",",str(SledPos.z,5,0),">","\n") #end
#if ( Debug = 1) #debug concat("Seconds: ",str(Seconds,5,3),"\n") #end

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 45
  location  <0.5*Feet,14*Feet,3.0*Feet>
  look_at   <0.5*Feet,-40*Feet,5*Feet>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 60
//    direction z*50
//  location  <2*Feet, 50*Feet, 140*Feet> // overhead
//  look_at   <3*Feet, -0*Feet, 0*Feet >
  location  <30*Feet,05*Feet, 12*Feet>
  look_at   SledPos +<0*Feet,.5*Feet, 0> 
  }

#declare RS = seed(603943);
#switch (Seconds)
#range (0,1.5)
camera {
  Render_Cam
  }
#break
#range (1.501,2.000) // sled bounces up
/*
	#declare LK = 12*sin(90*(Seconds-1.5))*(2.5-Seconds);
	#if ( Debug = 1) #debug concat("Cam Rot: ",str(LK,5,3),"\n") #end
	#declare LK = 12*sin(1.6)*(2.5-Seconds);
	#if ( Debug = 1) #debug concat("Cam Rot: ",str(LK,5,3),"\n") #end
	#declare LK = 12*sin(90*(Seconds-1.56))*(2.5-Seconds);
	#if ( Debug = 1) #debug concat("Cam Rot: ",str(LK,5,3),"\n") #end
*/
camera {
  Render_Cam
	rotate y*12*sin(90*(Seconds-1.5))*(2.5-Seconds)
  }
#break
#else
camera {
  Render_Cam
  }
#end


//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}


//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <-14*Feet,-20*Feet,2*Feet> }
object { TrackLight translate <-14*Feet,-80*Feet,2*Feet> }
object { TrackLight rotate z*45 translate <-24*Feet,-80*Feet,2*Feet> }

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"
//object { Plain rotate x*-17 translate -LocalOrigin }
object { Plain rotate x*-17 translate -LocalOrigin+<0,-200*Feet,0> }
object { TrackTerrain translate -LocalOrigin }
//object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1200*Feet,220*Feet> translate -LocalOrigin }
//object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1000*Feet ,-500*Feet> translate -LocalOrigin }

object { TotalTrack translate -LocalOrigin+<0,0,2*Feet> }


//===============================================
//             Objects
//===============================================

#include "Bobsled.inc"
//#include "BobsledRed.inc"

#declare ShadowLight =
  light_source {
    <0,0,0>
    color rgb<1.2, 1.2, 1>*(-0.3-1*Seconds)
//    color rgb<1.2, 1.2, 1>*-0.61
    spotlight
    point_at <0,0,-20>
    radius 12+10*Seconds    // degrees fully lit (*2)
    falloff 20+20*Seconds   // degrees no lighting (*2)
    tightness 1
	}

//===============================================
//             Object Placement
//===============================================

//object { RedsledS rotate z*90 rotate y*-120 rotate z*0 translate <2*Feet,20*Feet,2.5*Feet> }

// speed 95 ft/s
object { BobsledSFull
	rotate z*90
	rotate SledRot
	translate SledPos
}

#if ( Seconds < 1.500 )
object { ShadowLight rotate x*50*(1.5-Seconds) translate <0,4*Feet,4*Feet> }
//object { ShadowLight rotate x*70 translate <0,4*Feet,4*Feet> }
#end
/*
#if ( Seconds < 1.5 )
cone {
	<0,0,2*Feet>,0,<0,0,30*Feet>,4*Feet
	texture { pigment { rgb<1,.3,.1> } }
}
#end
*/
