
// Glenn's POV-Ray Animation File - Bobsled Shot 385
// created 10-Jan-03
// last update 10-Jan-03
// 2002 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <320*Feet,100*Feet,0>; // start of turn 12
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#include "TrackMaker.inc"

#if ( Debug = 1) #debug concat("Seconds: ",str(Seconds,5,3),"\n") #end


//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 50
  location  <40*Feet,-43.5*Feet,2*Feet+2.5*Feet>
  look_at   <30*Feet,-38*Feet,2*Feet+5*Feet>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 60
//    direction z*50
  location  <2*Feet, 50*Feet, 140*Feet> // overhead
  look_at   <3*Feet, -0*Feet, 0*Feet >
  }

camera {
  Render_Cam
  }


//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}


//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <-14*Feet,-2*Feet,2*Feet> }
//object { TrackLight translate <-14*Feet,-80*Feet,2*Feet> }
object { TrackLight rotate z*45 translate <-24*Feet,-80*Feet,2*Feet> }


//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"
//object { Plain rotate x*-17 translate -LocalOrigin }
object { Plain rotate x*-17 translate -LocalOrigin+<0,-200*Feet,0> }
object { TrackTerrain translate -LocalOrigin }
//object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1200*Feet,220*Feet> translate -LocalOrigin }
//object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1000*Feet ,-500*Feet> translate -LocalOrigin }

object { TotalTrack translate -LocalOrigin+<0,0,2*Feet> }


//===============================================
//             Objects
//===============================================

#include "Bobsled.inc"

//===============================================
//             Object Placement
//===============================================

object { BobsledSFull
	rotate <0,-9,-9+Seconds*4>
	translate <0,0,-6*Feet> // set on turn base
	rotate <25+65*(Seconds/1.2),0,0>
	translate <0,0,6*Feet>
	rotate z*90

	translate <-40*Feet,0,0>
		rotate z*(10+180*(Seconds/3.2))
	translate <40*Feet,0,2*Feet>

}



