
// Glenn's POV-Ray Animation File - Bobsled Shot 420
// created 8-Jan-03
// last update 10-Jan-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )


#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <400*Feet,150*Feet,0>; // finish line
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#include "TrackMaker.inc"

#if ( Debug = 1) #debug concat("Seconds: ",str(Seconds,5,3),"\n") #end

#declare CameraPos = <-2018*Feet,-2028*Feet,812*Feet>;

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>

	angle (29)
	location CameraPos
  look_at <0,0*Feet,6*Feet>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
//    direction z*50
  location <-26*Feet, -5*Feet, 6*Feet> // side
  look_at <0*Feet,0,5*Feet>
  }

camera {
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================
/*
#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}

#declare WhiteSignTex =
	texture {
		pigment { color rgb<.96,.98,.99>*1.3 }
		finish { ambient 0.14 specular 0.85 roughness 0.02 metallic }
	}
#declare BlackSignTex =
	texture {
		pigment { color rgb<.036,.038,.039> }
		finish { ambient 0.04 diffuse 0.4 specular 0.1 roughness 0.04 }
	}
#declare LEDTex =
	texture {
		pigment { color rgb<1.96,.98,.09> }
		finish { ambient 0.44 specular 0.5 roughness 0.04 }
	}
*/
#declare BrightWhite =
    texture {
      pigment { color <1,1,1> }
      finish { ambient .8 phong .6 }
    }

#declare FlatBlack = // does not illuminate
	texture {
		pigment { Black }
		finish { ambient 0 specular 0 roughness .005 }
	}

#declare BrightBlue =
    texture {
      pigment { color <.1,.1,1> }
      finish { ambient .8 phong .6 }
    }


//===============================================
//             Lighting
//===============================================
/*
#include "TrackLights.inc"
object { TrackLight translate <-14*Feet,-20*Feet,2*Feet> }
object { TrackLight translate <-14*Feet,-80*Feet,2*Feet> }
object { TrackLight rotate z*45 translate <-24*Feet,-80*Feet,2*Feet> }
*/
/*
#declare FinishSpot =
  light_source {
    <3*Feet,0,6*Feet>
    color rgb<1.12, 1.07, 0.97>*0.7
    spotlight
    point_at <0,0,0>
    radius 22    // degrees fully lit (*2)
    falloff 40   // degrees no lighting (*2)
    tightness 1
	}
#object { FinishSpot translate <0,0,2*Feet> }

#declare FluorescentSpot =
  light_source {
    <6*Feet,5*Feet,11.5*Feet>
    color rgb<0.92, 1.1, 1.3>*0.9
    spotlight
    point_at <0,0,0>
    radius 42    // degrees fully lit (*2)
    falloff 60   // degrees no lighting (*2)
    tightness 1
	}
#object { FluorescentSpot translate <0,0,2*Feet> }
*/


//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"


//===============================================
//             Objects
//===============================================

#declare FadeBoard =
	box {
		<0,-2.5*Feet,-2*Feet>,<1,2.5*Feet,2*Feet>
		texture {
			pigment { color rgbt<1,1,1,1-Sclock*.5> }
			finish { ambient 0 }
		}
	}
#declare BlackBoard =
	box {
		<0,-2.5*Feet,-2*Feet>,<1,2.5*Feet,2*Feet>
		texture {
			pigment { color rgb<.10-(Sclock*0.13),.10-(Sclock*0.13),.30-(Sclock*0.33)> }
			finish { ambient 0.8 }
		}
//texture { BrightBlue }
	}
#declare CreditText =
	union {
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Concept, Models, and Animation",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,0>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"by Glenn McCarter",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-2>
		}
/*
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Glenn McCarter",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-4>
		}
*/
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Voices",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-7>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Announcer 1 ..... Glenn McCarter",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-9>
		}

		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Announcer 2 ..... Doug Myers",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-11>
		}

		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Snow Girl ........... Anna",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-13>
		}

		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Special thanks to",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-17>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Scott McCarter and Dennis Reger",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-19>
		}

		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"A Snowball's",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <2.3,2.1,1>
			rotate <90,0,-90>
			translate <0,11,-22.5>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Chance",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightBlue }
			scale <2.9,2.5,1>
			rotate <90,0,-90>
			translate <0,5.3,-25.5>
		}
/*
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"is",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.1,1.0,1>
			rotate <90,0,-90>
			translate <0,11,-36>
		}
*/
		text {
			ttf "c:\Windows\Fonts\ARIAL.TTF",
			"Copyright 2003   by   Glenn McCarter",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.3,1.3,1>
			rotate <90,0,-90>
			translate <0,11,-38>
		}
		text {
			ttf "c:\Windows\Fonts\ARIAL.TTF",
			"all rights reserved",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.0,0.9,1>
			rotate <90,0,-90>
			translate <0,11,-39.5>
		}
	} // end union

#declare BackText =
	union {
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Concept, Models, and Animation",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,0>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"by Glenn McCarter",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-2>
		}
/*
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Glenn McCarter",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-4>
		}
*/
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Voices",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-7>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Announcer 1 ..... Glenn McCarter",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-9>
		}

		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Announcer 2 ..... Doug Myers",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-11>
		}

		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Snow Girl ........... Anna",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-13>
		}

		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Special thanks to",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-17>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Scott McCarter and Dennis Reger",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-19>
		}

		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"A Snowball's",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <2.3,2.1,1>
			rotate <90,0,-90>
			translate <0,11,-22.5>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Chance",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <2.9,2.5,1>
			rotate <90,0,-90>
			translate <0,5.3,-25.5>
		}
/*
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"is",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.1,1.0,1>
			rotate <90,0,-90>
			translate <0,11,-36>
		}
*/
		text {
			ttf "c:\Windows\Fonts\ARIAL.TTF",
			"Copyright 2003   by   Glenn McCarter",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.3,1.3,1>
			rotate <90,0,-90>
			translate <0,11,-38>
		}
		text {
			ttf "c:\Windows\Fonts\ARIAL.TTF",
			"all rights reserved",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.0,0.9,1>
			rotate <90,0,-90>
			translate <0,11,-39.5>
		}
	} // end union

#declare ScrollingCreditsBoard =
	union {
//		object { FadeBoard }
		object { BlackBoard translate <1,0,0> }
		object { CreditText translate <0.0, 0.00,-12+sin(Sclock*pi/2)*(41+12)> }
		object { BackText   translate <.26,-0.03,-12+sin(Sclock*pi/2)*(41+12)>-.2 }
	}

#declare ShadeBoard = // shades FadeBoard from the sun
	box {
		<0,-20*Feet,-20*Feet>,<1,20*Feet,20*Feet>
		texture {
			pigment { color rgb<1,.2,.2> }
			finish { ambient 0 }
		}
	}

#declare SnowballSpot =
  light_source {
    <-2*Feet,2*Feet,2*Feet>
    color rgb<1.12, 1.07, 0.97>*0.7
//    color rgb<2.12, 0.07, 0.07>*1.7
/*
    spotlight
    point_at <0,0,0>
    radius 22    // degrees fully lit (*2)
    falloff 40   // degrees no lighting (*2)
    tightness 1
*/
	}

#declare RS = seed(59882);
#declare SnowballGroup =
	union {
		#object { SnowballSpot }
		sphere { // main
			<0,0,0>,1.6
		}
		sphere { <0,3,-1.6>,0.3 }
		sphere { <0,4,-1.79>,0.13 }
		sphere { <0,1.6,-1.85>,0.18 }
		#declare SS = 0;
		#while (SS<4)
			sphere {
				<0,0,0>,0.84+rand(RS)*0.3
				translate <0,0,-1>
				rotate y*(360*rand(RS))
				rotate z*(360*rand(RS))
			}
			#declare SS = SS + 0.02;
		#end
		texture { BrightSnowyTex scale 0.3 }
		translate <0.0,-5.00,-32-12+sin(Sclock*pi/2)*(41+12)>
	} // end union

//===============================================
//             Object Placement
//===============================================


object { ScrollingCreditsBoard rotate <0,8,45> translate CameraPos+<3*Feet,3*Feet,-26> }

object { SnowballGroup rotate <0,8,45> translate CameraPos+<3*Feet,3*Feet,-26> }

//object { ShadeBoard rotate <0,0,0> translate CameraPos+<-8*Feet,6*Feet,0> }
//object { ScrollingCreditsBoard rotate <0,0,0> translate CameraPos+<3*Feet,3*Feet,-26> }