
// POV-Ray Object File - Winter Child
// created 30-Dec-02
// last update 30-Dec-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "WinterChild.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// WinterChild
//
//
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Bobsled nose at X=0, rails at z=0, sled extends into +X
// Sky is +Z
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here


//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare CoatTex =
	texture {
		pigment { color rgb<.502,.541,.748>*1.30 }
		finish { ambient 0.3 diffuse 0.8 specular 0.08 roughness .122 }
	}
#declare WhiteTrim =
	texture {
		pigment { color rgb<.982,.951,.998>*1.00 }
		finish { ambient 0.5 specular 0.6 roughness .122 }
	}


//===============================================
//             Macros
//===============================================



//===============================================
//             Objects
//===============================================

#declare Head =
	sphere {
		<0,0,0>,5.0
		scale <.7,.8,1>
		texture { pigment { color rgb <0.929,0.804,0.702> } }
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "FaceChild.png"
					once
					map_type 0 // planar
					interpolate 2 // bilinear
				}
				rotate x*90
				scale <8,1,12>
				translate <-4,0,-6.0>
			}
			finish { ambient 0.6 }
		}
	}

#declare HoodShape =
	difference {
		sphere { // outer
			<0,0,0>,6
			scale <.7,.8,1>
		}
		sphere { // inner
			<0,0,0>,5.6
			scale <.7,.8,1>
		}
		cylinder {
			<0,0,0>,<0,-6,0>,4.5
			scale <.6,1,1>
		}
		texture { CoatTex }
	} // end difference
#declare Hood =
	union {
		object { HoodShape }
		torus { // fur
			4.8,1.3
			scale <.7,1,1>
			translate <0,-2,0>
			texture { WhiteTrim }
		}
		cylinder { // collar
			<0,0,-1>,<0,0,2>,3.5
			translate <0,0,-6.6>
		}
		texture { CoatTex }
	} // end union

#declare CoatShape = // origin at largest point
	difference {
		sphere {
			<0,0,0>,20
			scale <.7,.5,1>
		}
		box { // cutoff top
			<-22,-22,0>,<22,22,30>
			translate <0,0,18>
		}
		box { // cutoff bottom
			<-22,-22,-30>,<22,22,0>
		}
		texture { CoatTex }
	} // end difference

#declare CoatWithHood =
	union {
		object { Head scale 1.5 translate <0,0,24> }
		object { Hood scale 1.5 translate <0,0,24> }
		object { CoatShape }
		torus { // fur trim
			20,1.5
			rotate x*90
			scale <.7,.5,1>
			texture { WhiteTrim }
		}

	} // end union

#declare SnowPants =
	union {
		cone {
			<0,0,2>,3.2,<0,0,24>,7
			translate <5,0,0>
		}
		torus {
			3,1.3
			rotate x*80
			translate <5,0,2>
			texture { WhiteTrim }
		}
		cone {
			<0,0,2>,3,<0,0,24>,7
			translate <-5,0,0>
		}
		torus {
			3,1.3
			rotate x*80
			translate <-5,0,2>
			texture { WhiteTrim }
		}
		texture { CoatTex }
	} // end union
#declare Boot =
	union {
		sphere {
			<0,0,0>,3
			scale <.6,1,.6>
			translate <0,-3,0>
		}
		cone {
			<0,0,0>,2,<0,0,4>,3
		}
		texture { CoatTex }
	}
#declare SnowPantsWithBoots =
	union {
		object { SnowPants }
		object { Boot rotate z*-20 translate <-5,0,0> }
		object { Boot rotate z*20 translate <5,0,0> }
	} // end union

#declare RightArmShape =
	sphere_sweep {
		b_spline
		5,
		<0,-1,1>,4,
		<0,0,0>,4,
		<0, 4,-7>,3.5
		<0, 0,-12>,3.0
		<0,-1,-14>,3.0
		texture { CoatTex }
	}
#declare RightArm =
	union {
		object { RightArmShape }
		sphere { // mitten
			<0,0,0>,2.5
			scale <1,0.75,1>
			rotate <-30,0,0>
			translate <0,-1,-16>
			texture { CoatTex }
		}
		torus { // trim
			3.0,1.1
			rotate x*45
			translate <0,0,-14>
			texture { WhiteTrim }
		}
	} // end union
	
#declare WinterChild =
	union {
		object { CoatWithHood translate <0,0,20> }
		object { SnowPantsWithBoots }
		object { RightArm rotate y*45 rotate x*12 translate <-8,0,35> } // right
		object { RightArm scale <-1,1,1> rotate <0,-75,0> translate <8,0,35> } // left
	} // end union

//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 24
		location  <-3*Feet, -30*Feet, 5*Feet> // overall
		look_at <0*Feet,0*Feet,2*Feet>
	}

//background { rgb<.43,.34,.95> } // sky blue
background { rgb<.03,.04,.05> } // black
light_source
{ <140*Feet,-135*Feet,150*Feet>, 1.0
  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-120*Feet,130*Feet>, <1.13,1.08,0.83>*.6
  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
light_source
{ <-14*Feet,-12*Feet,130*Feet>, <1.00,1.18,1.03>*.4
  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 1*Feet }
//object { TestSphere scale 20 translate <0,0,20> }

object { WinterChild scale 1 rotate z*0 translate <-0*Feet,-0*Feet ,0*Feet> }
object { WinterChild scale 1 rotate z*90 translate <-3*Feet,-3*Feet ,0*Feet> }

#end
