/* BOW.POV - Programmed by Maarten Hofman */
/* 080103: Started programming */
/* 090103: Added mirror */
/* 100103: Added more details */
/* 130103: Added the engine emission and the flight through the target */

#include "colors.inc"   
#include "woods.inc"
#include "metals.inc"
#include "skies.inc"
#include "functions.inc"
#include "stones.inc"                                                                     
#include "finish.inc"                                                                     
#include "golds.inc"

#declare my_clock = clock;
#declare R1 = seed(0);

/* 
 * Scenario:
 * 0-2:   Focus on bow
 * 2-4:   Move bow
 * 4-6:   Fire arrow
 * 6-8:   Focus on arrow
 * 8-10:  Change arrow
 * 10-11: Smoke from arrow
 * 11-12: Arrow disappears in the distance
 * 12-14: Smoke disappears, focus on hole
 */
     
#if (my_clock<2)
#declare pull = 0;
#declare bow_distance = 0;
#declare fast = 0;
#else
#if (my_clock<4)
#declare pull = (my_clock-2)/4;
#declare bow_distance = 0;
#declare fast = 0;
#else
#if (my_clock<6)
#declare pull = 0;
#declare bow_distance = (my_clock-4)*49;
#declare fast = 0;
#else                    
#declare pull = 0;
#declare bow_distance = 98;
#if (my_clock>11)
#declare fast = (my_clock-11)*100;
#else 
#declare fast = 0;
#end    
#end
#end
#end

camera {                        
#if (my_clock<2)    
#declare arrow = 0;             
  location <-7+my_clock*2.5,-4+my_clock*2,-10+my_clock*4>
  look_at <0,0,(0.15-pull*3)*(0.2+pull/2)>     
#else   
#if (my_clock<4)   
#declare arrow = 0; 
  location <-2,0,-2>  
  look_at <0,0,(0.15-pull*3)*(0.2+pull/2)>
#else
#if (my_clock<6)   
#declare arrow = 0;
  location <-2-bow_distance/25,0-bow_distance/50,-2+bow_distance*bow_distance/100>
  look_at <0,0,(0.15-pull*3)*(0.2+pull/2)+bow_distance>
#else    
#if (my_clock<8)   
#declare arrow = 0;     
#declare clock4 = (my_clock-6)/2;
  location <-5.92+clock4*7.42,-1.96+clock4*3.46,94.04+clock4*4.96>
  look_at <0,0,98.03+clock4*0.97> 
#else
#if (my_clock<10)             
#declare arrow = (my_clock-8)/2;
  location <1.5,1.5,99-arrow*2>
  look_at <0,0,99>
#else        
#if (my_clock<11)     
#declare arrow = 1;
  location <1.5,1.5,97>
  look_at <0,0,99>
#else
#if (my_clock<12)
#declare arrow = 1;
  location <1.5+(my_clock-11)*5,1.5+(my_clock-11),97+(my_clock-11)>
  look_at <0,0,99+fast>
#else
#declare arrow = 1;
#declare clock6 = (my_clock-12);
  location <6.5+clock6*2,2.5-clock6*3,98-clock6*4>
  look_at <0-clock6*100,clock6*25,199-clock6*37>
#end
#end 
#end
#end
#end
#end
#end
}

sky_sphere {
  S_Cloud1
}


plane {
  y,-5
  texture {
    T_Stone1
  }
}
   
light_source { <-50,100,-100> color White }       
light_source { <-51,101,-101> color White }
     
#declare bow = difference {
  cylinder {
    <-0.06,0,0>,
    <0.06,0,0>,3-pull/2
  }
  cylinder {
    <-0.2,0,0>,
    <0.2,0,0>,2.9-pull/2
  }       
  box {
    <-0.2,4,0>,
    <0.2,-4,-4>
  }
  box {
    <-0.01,4,0>,
    <0.01,-4,0.2>
  }
  texture {
    T_Wood3
  }
}

#declare arrow_base = difference {
  cylinder {
    <0,0,-0.03>,
    <0,0,2>,0.02
  }
  box {
    <-0.01,-1,0>,
    <0.01,1,-1>
  }
}

#declare arrow = union {
  object {
    arrow_base
    texture {
      T_Wood1
    }
  }
  cone {
    <0,0,2>,0.02,
    <0,0,2.1>,0
    texture {
      T_Chrome_2B
    }
  }
  cone {
    <0,0,0.1>,0.15,
    <0,0,1>,0
    texture {
      T_Chrome_4B
    }
    scale <0.1+arrow*4,1-arrow/2,1>
  }   
#if(arrow>0)
  cylinder {
    <-arrow*0.3,0,0.1>,
    <-arrow*0.3,0,0.1-arrow/100>,arrow/20
    texture {
      T_Gold_1B
    }
  }
  cylinder {
    <arrow*0.3,0,0.1>,
    <arrow*0.3,0,0.1-arrow/100>,arrow/20
    texture {
      T_Gold_1B
    }
  }  
#end
#if (my_clock>10)
  cone {
    <-0.3,0,0.1>,0.05
    <-0.3,0,-(my_clock-10)-fast*(1-fast/300)>,0.05+(my_clock-10)/2
    pigment {
      rgbt <1,1,1,1>
    }      
    hollow on
    interior {
      media {   
        emission 0.75
        scattering {
          1,<1,1,1>
          extinction 1
        }
      }
    }                          
  } 
  cone {             
    <0.3,0,0.1>,0.05
    <0.3,0,-(my_clock-10)-fast*(1-fast/300)>,0.05+(my_clock-10)/2
    pigment {
      rgbt <1,1,1,1>
    }            
    hollow on
    interior {
      media {   
        emission 0.75
        scattering {
          1,<1,1,1>
          extinction 1
        }
      }
    }                              
  }
#end
#if ((my_clock>6)&(my_clock<8))
  translate <0,0,-2>
  rotate <rand(R1)*6-3,rand(R1)*6-3,rand(R1)*6-3>
  translate <0,0,2>
#end
#if(clock<11.02)  
  rotate <0,3,0>
#end   
  rotate <0,0,bow_distance*4>          
}
  
#declare string = union {
  sphere {
    <0,3-pull/2,0.15>,0.03
  }
  sphere {
    <0,-3+pull/2,0.15>,0.03
  }
  cylinder {
    <0,0,0.15-pull*3>,
    <0,3-pull/2,0.15>,0.01
  }
  cylinder {
    <0,0,0.15-pull*3>,
    <0,-3+pull/2,0.15>,0.01
  }
  pigment {
    Red
  }
}

#declare bow_target_base = union {
  cylinder {
    <0,0,0>,
    <0,0,1>,1
    pigment {
      Red
    }
  }               
  cylinder {
    <0,0,0.01>,
    <0,0,1>,2
    pigment {
      White
    }
  }
  cylinder {
    <0,0,0.02>,
    <0,0,1>,3
    pigment {
      Red
    }
  }
  cylinder {
    <-2,-10,1.5>,
    <-2,1,1.5>,0.5
    texture {
      T_Wood2
    }
  }
  cylinder {
    <2,-10,1.5>,
    <2,1,1.5>,0.5
    texture {
      T_Wood2
    }
  }           
}

#if (my_clock<=11.02)
#declare bow_target = object {
  bow_target_base
}
#else
#declare bow_target = difference {     
  object {
    bow_target_base
  }
  cylinder {
    <0,0,-1>,
    <0,0,2>,0.4
    scale <2,1,1>
    pigment {
      Black
    }
  }
}
#end

#declare mirror = union {
  box {
    <0,0,0>,
    <-0.1,3,4>
    pigment {
      Black
    }
    finish {
      Mirror
    }
  }
  box {
    <0,0,0>,
    <0.1,3,4>
    pigment {
      Black
    }
  }
  
  cylinder {
    <0,0,0>,
    <0,3,0>,0.2
    texture {
      T_Gold_1C
    }
  }
  cylinder {
    <0,0,4>,
    <0,3,4>,0.2
    texture {
      T_Gold_1C
    }          
  }
  cylinder {
    <0,0,0>,
    <0,0,4>,0.2
    texture {
      T_Gold_1C
    }
  }
  cylinder {
    <0,3,0>,
    <0,3,4>,0.2
    texture {
      T_Gold_1C
    }
  }       
  sphere {
    <0,0,0>,0.2
    texture {
      T_Gold_1C
    }
  }
  sphere {
    <0,3,0>,0.2
    texture {
      T_Gold_1C
    }
  }
  sphere {
    <0,0,4>,0.2
    texture {
      T_Gold_1C
    }
  }
  sphere {
    <0,3,4>,0.2
    texture {
      T_Gold_1C
    }
  }
  cone {
    <0,-5,2>,1
    <0,0,2>,0.2
    texture {
      T_Gold_1C
    }
  }
}    

object {
  mirror
  translate <5,-1.5,50>
}

object {
  bow_target
  translate <0,0,100>
}

object {
  bow
  scale <1,1-pull/2,0.2+pull/2>
}

object {
  string
  scale <1,1-pull/2,0.2+pull/2>
}

object {
  arrow
  translate <0,0,(0.15-pull*3)*(0.2+pull/2)+bow_distance+fast>
}          

#declare stem = union {
  cylinder {
    <0,0,0>,<0,0.9,0>,0.04
  }
  cylinder {
    <0,0.9,0>,<0,1,0>,0.08
  }
}

#declare plant = union {
  object { stem }
  object { stem scale <1,0.1,1> rotate <2,-40,34> }
  object { stem scale <1,0.4,1> rotate <-11,20,40> }
  object { stem scale <1,0.5,1> rotate <-37,-3,-11> }
  object { stem scale <1,0.7,1> rotate <-18,-41,7> }
  object { stem scale <1,0.9,1> rotate <-32,-17,-40> }
  object { stem scale <1,0.2,1> rotate <-36,-13,29> }
  object { stem scale <1,0.9,1> rotate <-6,-20,9> }
  object { stem scale <1,0.2,1> rotate <40,10,-10> }
  object { stem scale <1,0.8,1> rotate <35,-8,38> }
  object { stem scale <1,0.5,1> rotate <41,-24,-36> }
  object { stem scale <1,0.7,1> rotate <4,-33,4> }
  object { stem scale <1,0.9,1> rotate <28,-44,37> }
}

#include "plants.inc"

#declare tower_base = lathe {
  cubic_spline
  9,
  <18,-10>,<18,-5>,<10,10>,<19,20>,<15,30>,<17,40>,<11,45>,<13,60>,<13,70>
}

#declare tower = difference {
  object {
    tower_base
  }
  cylinder {
    <-20,5,0>,
    <20,5,0>,2
    rotate <0,0,0>
  }
  cylinder {
    <-20,15,0>,
    <20,15,0>,2
    rotate <0,25,0>
  }
  cylinder {
    <-20,25,0>,
    <20,25,0>,2    
    rotate <0,50,0>
  }
  cylinder {
    <-20,35,0>,
    <20,35,0>,2    
    rotate <0,75,0>
  }
  cylinder {
    <-20,45,0>,
    <20,45,0>,2    
    rotate <0,100,0>
  }
  cylinder {
    <-20,55,0>,
    <20,55,0>,2    
    rotate <0,125,0>
  }
  cylinder {
    <-20,65,0>,
    <20,65,0>,2     
    rotate <0,150,0>
  }
  cylinder {
    <-20,5,0>,
    <20,5,0>,2
    rotate <0,90,0>
  }
  cylinder {
    <-20,15,0>,
    <20,15,0>,2
    rotate <0,115,0>
  }
  cylinder {
    <-20,25,0>,
    <20,25,0>,2    
    rotate <0,140,0>
  }
  cylinder {
    <-20,35,0>,
    <20,35,0>,2    
    rotate <0,165,0>
  }
  cylinder {
    <-20,45,0>,
    <20,45,0>,2    
    rotate <0,190,0>
  }
  cylinder {
    <-20,55,0>,
    <20,55,0>,2    
    rotate <0,215,0>
  }
  cylinder {
    <-20,65,0>,
    <20,65,0>,2     
    rotate <0,240,0>
  }

  texture {
    T_Stone2
  }
}
        
object {
  tower
  translate <100,0,75>
}

object {
  tower
  translate <-200,0,125>
}
