
#if (clock >= AnimationStartTime) // start circling around

#if (clock <= AnimationStartTime + CirclingTimePeriod) // start circling around 10 seconds from the camera to pan the entire scene
    #declare CameraDistance = ScaleFactorHeight * SpindleRadius; //Norm of camera position to bottom of torus starts at 1.2 spindle radius and swirls in to 4
    #declare CameraAngle =  0 + (clock - AnimationStartTime) * (360/CirclingTimePeriod) * (2*pi/360);  // circle around converted into Radians

    #declare CameraX = SpindleRadius + CameraDistance * cos(CameraAngle);
    #declare CameraZ = SpindleRadius + CameraDistance * sin(CameraAngle);
    
    #declare CameraY = ScaleFactorHeight * CameraDistance;  
    
    #declare ScaleFactorHeight = (0.3 - 1.2)/CirclingTimePeriod * (clock - (AnimationStartTime) ) + (1.2) ;  
    
    // this is your swirl start look at for the camera - don't mind names for now ... they will represent things when torus is moving!
    #declare TorusXPosition = SpindleRadius; 
    #declare Elevation = 0;
#end

#end

#if (clock > AnimationStartTime + CirclingTimePeriod) //start to move into the point where the Hammer drops
    #if (clock <= HammerStartsToSwing)
        #declare CameraAngle =  0 + (clock - (AnimationStartTime + CirclingTimePeriod)) * (360/CirclingTimePeriod) * (2*pi/360);  // circle around converted into Radians
        #declare CameraDistance = (CameraSetBackFactor - (ScaleFactorHeight * SpindleRadius))/ZoomingInTimePeriod * (clock - (AnimationStartTime + CirclingTimePeriod) ) + (ScaleFactorHeight * SpindleRadius) ;  
           
        #declare CameraX = ((CameraDistance * cos(CameraAngle)) - (SpindleRadius + CameraDistance * cos(CameraAngle)))/ZoomingInTimePeriod * (clock - (AnimationStartTime + CirclingTimePeriod) ) + (SpindleRadius + CameraDistance * cos(CameraAngle));  
        #declare CameraZ = ((CameraDistance * sin(CameraAngle)) - (SpindleRadius + CameraDistance * sin(CameraAngle)))/ZoomingInTimePeriod * (clock - (AnimationStartTime + CirclingTimePeriod) ) + (SpindleRadius + CameraDistance * sin(CameraAngle));  
        #declare CameraY = ((Elevation + 2 + sin(CameraAngle)) - (ScaleFactorHeight * CameraDistance))/ZoomingInTimePeriod * (clock - (AnimationStartTime + CirclingTimePeriod) ) + (ScaleFactorHeight * CameraDistance);  

        #declare TorusXPosition = (0 - SpindleRadius)/ZoomingInTimePeriod * (clock - (AnimationStartTime + CirclingTimePeriod) ) + (SpindleRadius) ;  // move the view towards the torus!
    #end
#end

#if (clock > HammerStartsToSwing)
    #if (clock <= HammerDropsTorusStartsMoving)
        #declare CameraDistance = max(CameraBaseDistance,CameraSetBackFactor - (CameraSetBackFactor - CameraBaseDistance)*clock); //Norm of camera position to bottom of torus starts at 25 and swirls in to 4
        #declare CameraAngle = 2 * HammerAngleDegrees * 2 * pi / 360 * (HammerDropsTorusStartsMoving - HammerStartsToSwing) / CameraCircleLagFactor;  // so that the camera motion will be smooth when the torus starts rolling.

        // Camera Motion
        // basic camera clock-style rotation around the subject - standard geometry
        #declare CameraX = CameraDistance * cos(CameraAngle);
        #declare CameraZ = CameraDistance * sin(CameraAngle);

        // this is just to wobble up-down some                                                 
        #declare CameraY = 2 + sin(CameraAngle);  
        //End of Camera Motion

    #end
#end

#if (clock > HammerDropsTorusStartsMoving)
        #declare CameraAngle = 2 * pi * clock / CameraCircleLagFactor;  // just keep spinning around div by 4-6 to make slower
        #declare CameraDistance = min (   CameraBaseDistance,   CameraBaseDistance  - (CameraBaseDistance - 1) * abs(sin(CameraAngle/4))   );   // bob back and forth the - 0.5 is min distance remember change to Variable name later

        // Camera Motion
        // basic camera clock-style rotation around the subject - standard geometry
        #declare CameraX = TorusXPosition + CameraDistance * cos(CameraAngle);
        #declare CameraZ = TorusZPosition + CameraDistance * sin(CameraAngle);

        // this is just to wobble up-down some
        #declare CameraY = Elevation + min( 2, 3.1/4 * CameraBaseDistance  - (CameraBaseDistance - 1) * abs(sin(CameraAngle/4)) );  
        //End of Camera Motion
#end

// Camera
camera {
    location  <CameraX,CameraY,CameraZ >      

    look_at   <TorusXPosition, Elevation, TorusZPosition> // torus rolling on the ground
  }
// End of Camera

// Key Lighting 15 degrees i.e. pi/12 radians counterclockwise and 2 units higher than the camera
#declare KeyOffsetXZ = pi/12;

light_source {  
    <CameraX + CameraDistance * cos(CameraAngle + KeyOffsetXZ ), CameraY + 2, CameraZ + CameraDistance * sin(CameraAngle + KeyOffsetXZ)>

    color rgb <0.7,0.7,0.7>
    spotlight
    radius 30
    falloff 60 
    fade_distance 9
    fade_power 1

    point_at <TorusXPosition, Elevation, TorusZPosition>
  }     

// End of Key Lighting

// Fill Lighting 45 degrees i.e. pi/4 radians clockwise and 2 units higher than the camera

#declare FillOffsetXZ = -pi/4;

light_source {  
    <CameraX + CameraDistance * cos(CameraAngle + FillOffsetXZ ), CameraY + 2, CameraZ + CameraDistance * sin(CameraAngle + FillOffsetXZ)>

    color rgb <0.3,0.3,0.3>
    spotlight
    radius 30
    falloff 60 
    fade_distance 6
    fade_power 1

    point_at <TorusXPosition, Elevation, TorusZPosition>
  }     

// End of Fill Lighting

