// this is the lampost object
// sw_lampost.inc


/////////////////////////////// custom glass definition //////////////////////////////////////////////////////////////////////////////
#declare I_Glass=
   interior {
    ior 1.5 
    caustics 0.2
   }
  
// Glass Finishes

#declare F_Glass1 =
   finish {
    specular 1
    roughness 0.001
    ambient 0
    diffuse 0
    reflection 0.1  // was 0.1         you might want to experiment with a slightly higher reflection
  }   

#declare T_Glass1 =
texture {
    pigment { color rgbf<1.0, 1.0, 1.0, 0.85> }   // filter was 0.7      This lets more light through!
    finish  { F_Glass1 }
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

 
#declare StreetLampTemplate = union {  // the base of the lamp post

cone {<LampPostSetout, 2, LampPostZSpot>, LongPipeRadius * 0.75/0.6  <LampPostSetout, -0.05, LampPostZSpot>,  LongPipeRadius * 1/0.6}
sphere {<LampPostSetout, 2, LampPostZSpot>, LongPipeRadius * 0.75/0.6}  // round out the look of the transition between base and thick straight section
cylinder { <LampPostSetout, 2, LampPostZSpot>, <LampPostSetout, HeightOfThickSection, LampPostZSpot>, LongPipeRadius}  // the thick straight section
sphere { <LampPostSetout, HeightOfThickSection, LampPostZSpot>, LongPipeRadius}  // round out the look of the transition between thick and thin straight sections
// the light arc there is a straight section and a arc all in the same radius
cylinder { <LampPostSetout, HeightOfThickSection, LampPostZSpot>, <LampPostSetout, HeightOfStraightSection, LampPostZSpot>, LongPipeRadius * 1/3} // this is the begining of the thin part
cylinder { <LampPostSetout  - (ArcReach * 2) , HeightOfStraightSection - LongPipeRadius * 5/2, LampPostZSpot>, <LampPostSetout  - (ArcReach * 2) , HeightOfStraightSection, LampPostZSpot>, LongPipeRadius * 1/3} // this is the begining of the thin part

difference { // this is the arc ... it's a 1/2 torus 
        torus { ArcReach, LongPipeRadius * 1/3 rotate <90,0,0> translate <LampPostSetout - ArcReach , HeightOfStraightSection, LampPostZSpot>}
        plane { y, HeightOfStraightSection}
}  // of difference


// lamp head  - difference of two sphere intersecting a plane and a torus to make things round
// then there is the light bulb abd the globe!


difference {  

        sphere { <LampPostSetout - (ArcReach * 2), HeightOfStraightSection - LongPipeRadius * 5/2, LampPostZSpot>, LongPipeRadius * 5/2}
        sphere { <LampPostSetout - (ArcReach * 2), HeightOfStraightSection - LongPipeRadius * 5/2, LampPostZSpot>, LongPipeRadius * 4/2}
        plane { y, HeightOfStraightSection - LongPipeRadius * 5/2}

} // of sphere differences
    
sphere { <LampPostSetout - (ArcReach * 2), HeightOfStraightSection - LongPipeRadius * 5/2, LampPostZSpot>, LongPipeRadius     // this is the light bulb itself
// this looks like a light that is on ... however since this sits inside the globe it 
// looks good this way even when the lamp is supposed to be off 

   pigment { White filter 1 }
   finish {
      diffuse 0.3
      reflection .75
      specular 1
      roughness .001
   }
   interior{ior 1.33}  // look here it is ... from the warning ...
}

sphere { <LampPostSetout - (ArcReach * 2), HeightOfStraightSection - LongPipeRadius * 5/2 , LampPostZSpot>, LongPipeRadius * 4/2      // this is the globe for the light filiament

 texture {T_Glass1}    // this is for off lights   
 interior{ I_Glass} 

 pigment { White }   // this is a lit light!
   finish {
      diffuse 0.8
      reflection .75
      specular 1
      roughness .001
   }                                                              
   
   interior{ior 1.33}  // look here it is ... from the warning ...
}

torus { LongPipeRadius * 4.5/2, LongPipeRadius * 0.5 /2 translate <LampPostSetout - (ArcReach * 2) , HeightOfStraightSection - LongPipeRadius * 5/2, LampPostZSpot>}

light_source {<LampPostSetout - (ArcReach * 2) - 2, HeightOfStraightSection - LongPipeRadius * 5/2 - 2, LampPostZSpot - 2>

    color rgb <0.4,0.4,0.4>
    spotlight
    radius 60
    falloff 90         
    fade_distance 6
    fade_power 1
    point_at <LampPostSetout - (ArcReach * 2), 0 , LampPostZSpot>
  }     


      texture   // aluminum from the Moray code library
      {      

       T_Silver_4B

/*
         pigment
         {
            color rgb <0.55, 0.5, 0.45>
         }      
         finish
         {
            ambient 0.1
            diffuse 0.35      //down from 0.65
            brilliance 1.0
            specular 0.35     //down from 0.85
            roughness 0.01
            reflection 0.4
            phong 0.3
         }
         
*/         
      }

} // of main union of all the object that make a Lamp Post
