
#declare RollingTorus = 

torus { TorusMajorAxis, TorusMinorAxis

       texture { T_Stone21 
       finish { reflection 0.2 phong 0.2 phong_size 15 }} // altering the reflection properties of the marble which appears to have no default reflection

       rotate <90, 0, 0>

#if (clock <= HammerDropsTorusStartsMoving)

    #declare TorusXPosition = 0;

    translate  <TorusXPosition, (TorusMajorAxis + TorusMinorAxis) + Elevation, TorusZPosition> 
    // major axis is center of torus so must translate by major + minor axis to have it "on-top" of the surface
    // watch out for x-z values they are related to the camera position ... this is the "field depth" or something like it!

#end    
   
#if (clock > HammerDropsTorusStartsMoving)
    //////////////////////////////////////////////// rolling on the floor ///////////////////////////////////////////////////////////////////////////////////////////////
    // the inital velocity has you still on the flat

    #if (clock < InclineTime) 

        #declare TorusXPosition = (InitialVelocity) * (clock - HammerDropsTorusStartsMoving);      // speed is constant here - zero elevation just the initial velocity!
        #declare InclineVelocity = InitialVelocity;
        rotate <0, 0, -TorusXPosition * 360 / (2 * pi * (TorusMajorAxis + TorusMinorAxis))>  // rolls on the surface properly!
        translate <TorusXPosition, (TorusMajorAxis + TorusMinorAxis) + Elevation, TorusZPosition> 
        
        // way before it's used I want a initialized version .... gets a file defined!!!!!!!
        #fopen MyFile "velocity.txt" write // start accumulating endpoints
        #write (MyFile, InitialVelocity,"\n")
        #fclose MyFile

        #fopen MyFile "whereami.txt" write // start accumulating endpoints
        #write (MyFile, TorusXPosition,"\n")
        #fclose MyFile

    #end

    /////////////////////////////////////////////// rolling up the incline plane //////////////////////////////////////////////////////////////
    // the inital velocity has you still past the flat
    #if (clock >= InclineTime) 

         #fopen MyFile "whereami.txt" read // grab old value
         #read (MyFile, TorusXPosition)
         #fclose MyFile
         
         #if (TorusXPosition < StartPlaneX )  

              #fopen MyFile "velocity.txt" read // grab old value
              #read (MyFile, InclineVelocity)
              #fclose MyFile

              #fopen MyFile "planetime.txt" write // start accumulating endpoints
              #write (MyFile, clock,"\n")
              #fclose MyFile

              #declare TorusXPosition = TorusXPosition + InclineVelocity * (clock_delta);      // speed is based on conservation of energy!
              #declare Elevation = (TorusXPosition-StartInclineX)*sin(InclineAngle); // height "near" the torus bottom from ground

              #declare NewInclineVelocity =   sqrt( max((InitialVelocity*InitialVelocity-2*GravitationalConstant*Elevation),0) ); // so it won't roll backwards
        
              #fopen MyFile "velocity.txt" write // read new value
              #write (MyFile, NewInclineVelocity,"\n")
              #fclose MyFile

              #fopen MyFile "whereami.txt" write // start accumulating endpoints
              #write (MyFile, TorusXPosition,"\n")
              #fclose MyFile
     
              rotate <0, 0, -TorusXPosition * 360 / (2 * pi * (TorusMajorAxis + TorusMinorAxis))>  // rolls on the surface properly!

              //////// actual motion routine //////
              #translate <TorusXPosition - StartInclineX, 0,TorusZPosition>
              #rotate <0,0,InclineAngleDegrees>
              #translate <StartInclineX,(TorusMajorAxis + TorusMinorAxis) / cos(InclineAngle),TorusZPosition> 

              // neccesary for camera position
              #declare TorusXPosition = StartInclineX + (TorusXPosition - StartInclineX) * cos(InclineAngle);  // makes it the "true" x position NOW
              #declare Elevation = (TorusXPosition - StartInclineX) * sin(InclineAngle);
            
         #end
                
         //////////////////////////////////////////////// on the flat spot ///////////////////////////////////////////////////////////////////////////////////////////////////

         #if (TorusXPosition >= StartPlaneX )  
    
             #fopen MyFile "planetime.txt" read
             #read (MyFile, PlaneTime)
             #fclose MyFile

             #declare TorusXPosition = StartPlaneX + PlaneVelocity * (clock - PlaneTime);        // speed is a constant now!

             rotate <0, 0, -TorusXPosition * 360 / (2 * pi * (TorusMajorAxis + TorusMinorAxis))> // rolls on the surface properly!
             translate <TorusXPosition, (TorusMajorAxis + TorusMinorAxis) + PlaneHeight, TorusZPosition> 

             #declare Elevation = PlaneHeight; // for the camera

         #end 
    #end     // of past incline time
#end
   
}
