
// Rocket car external view

#include "carlook.inc"
#include "figure.inc"

#declare wheel_width = 0.07;
#declare tyre_radius = 0.3;
#declare hub_radius = 0.25;

// Exhaust: flame starts at x=0
#declare exhaust_speed = (final_frame - initial_frame) * 0.4;
#declare density1 = density{ cylindrical rotate<0,0,90> scale 0.8
                             warp{turbulence 0.4 octaves 3 omega 1.5 }
                             translate<clock*exhaust_speed,0,0>};
#declare density0 = density{rgb 0};
#declare exhaust = cylinder{
   <0,0,0> <1.0,0,0 >, 1
   texture{pigment{color rgbt<1,1,1,1>}}
   interior{media{emission <1,0.5,0>*5
                  density{spherical scale 0.9
                          density_map{[0 density0][1 density1]}
                         }
                  }
           }
   scale<3.0,0.2,0.2> 
   hollow
}


// Trail starts at x=0
#macro make_trail( start_x, end_x, dens )

  #local Rt = seed(1);
  #local nt = abs(end_x - start_x) * dens;
  #local rad_factor = 1.1;

  union{

    #local i=0;
    #while(i<nt)
      #local ti = i/(nt+1);
      #local tx = end_x + pow(ti,0.5) * (start_x - end_x);

      #local rad_factor = rad_factor + (2*rand(Rt)-1)*0.2;
      #if( rad_factor < 1 )
          #local rad_factor = 1;
      #end
      #if( rad_factor > 2 )
          #local rad_factor = 2;
      #end
      #local rad = (1-1/(1+0.2*abs(tx-start_x))) * rad_factor;
      sphere{<tx,0,0.6>, rad texture{
             pigment{bozo turbulence 0.65 octaves 6 omega 0.7 lambda 2
                     color_map{[0 color rgbt<1,1,1,1>][1 color rgbt<1,1,1,0.5>]}
                     scale 0.5}
             finish{ambient 0.8 diffuse 0.7}}
             hollow}

    #local i=i+1;
    #end
   }
#end


#macro make_car( position, flame_flag, blur_factor )

union{

  // Blob Body
 difference{
    blob{threshold 0.5

         // Lower body
         cylinder{<-0.7,0,0.5><3,0,0.5>,0.5, 1}

         // Upper body
         cylinder{<1.5,0,0.8><3.07,0,0.8>,0.3, 1}

         texture{car_body_texture}
         }

  sphere{<0,0,0>,1 scale<0.8,0.2,0.2>*0.85 translate<1.5,0,0.75>
         texture{pigment{color rgbt<1,1,1,1>}}  hollow}

   }// end difference

     // Left wing
     cone{<0,0,0>,0.06 <0,0,1>, 0.02           rotate<0,4,0>scale<7,1,1>clipped_by{plane{z,1.6}}
          rotate<105,0,0>  translate<2.5,0,0.6>
          texture{car_body_texture}
     }

     // Right wing
     cone{<0,0,0>,0.06 <0,0,1>, 0.02
          rotate<0,4,0>scale<7,1,1>clipped_by{plane{z,1.6}}
          rotate<-105,0,0>  translate<2.5,0,0.6>
          texture{car_body_texture}
     }

  // Motor
  union{
     cylinder{<3.1,0,0.6> <3.3,0,0.6>,0.14}
     cylinder{<3.1,0,0.6> <3.4,0,0.6>,0.04}
     cone{<3.3,0,0.6>, 0.08 <3.5,0,0.6>,0.15 open}
        texture{pigment{color rgb 1}
         finish{ambient 0.2 diffuse 0.6  phong 2 phong_size 20 reflection 0.5}}
       }

  #if ( flame_flag )
      object{exhaust translate<3.3,0,0.6>}
  #end

  // Nose cone
  sphere{<0,0,0>,1 scale<2,0.27,0.27> translate<-0.7,0,0.5>
         texture{car_body_texture}
         }

  // Canopy
   sphere{<0,0,0>,1 scale<0.8,0.2,0.2> translate<1.5,0,0.75> 
             texture{pigment{color rgbt<1,1,1,0.7>}
                     finish{ambient 0.5 diffuse 0.7 phong 2 phong_size 20}
                    }hollow}

  //Tail fin
  cone{<0,0,-0.3>,0.06 <0,0,1.5>, 0.02
       rotate<0,2,0>scale<10,1,1>clipped_by{plane{z,1.2}}
       translate<2.5,0,0.6>
       texture{car_body_texture}
      }


  // Wheel
  #local wheel = union{
   // Tyre
    sphere{<0,0,0>,1 scale<tyre_radius,0.7*wheel_width,tyre_radius>
           texture{pigment{color rgbt<1,1,1,1>} }
           interior{media{absorption (30 - 23*blur_factor)}}
          hollow}

  // Hub
  sphere{<0,0,0>,1 scale<hub_radius,wheel_width,hub_radius>
         texture{car_body_texture}
         }
   };

  #local wheel_angle = (180/pi) * position / tyre_radius;

  // Front wheel
  object{wheel rotate<0,wheel_angle,0> translate<-1.0,0,tyre_radius>}

  // Left rear wheel
  object{wheel rotate<0,wheel_angle,0> translate<3.0,-1,tyre_radius>}

  // Right rear wheel
  object{wheel rotate<0,-wheel_angle,180> translate<3.0,1.0,tyre_radius>}

  #local m = 2*pi*2*(clock-0.5);
  #local head_tilt = 10 * (sin(3*m) + sin(7*m) + sin(11*m) + sin(13*m))/4;  
  #local head = make_head();
  object{head
         translate<0,0,1>
         rotate<0,head_tilt,0>
         translate<0,0,-1>
         scale 0.08 translate<1.24,0,0.79>}


  // Position
  translate<position,0,0>
  }

#end
