

#macro make_fuel( level, warn )

  #local rad = 0.02;
  #local rim_size = 0.001;
  #local rim_T = texture{pigment{color rgb 1}
                         finish{ambient 0.3 diffuse 0.6 phong 2 phong_size 10}};

  #local T_panel = texture{
    pigment{color rgb 1}
    finish{ambient 0.3 diffuse 0.5 phong 1.5 phong_size 10}
    normal{bump_map{png "panel.png" bump_size 3} rotate<0,-90,0>
           translate<0,0,0.5> scale<0.01,0.03,0.03>}
  };


  #local screw = difference{
    sphere{<0,0,0>, 1}
    box{<0.1,-1.1,-0.3><1.1,1.1,0.3>}
    scale<0.5,1,1>*0.002
    texture{rim_T}
  }

  union{

  // panel
  plane{x, 0 texture{T_panel} hollow }

  object{screw rotate -x*30 translate<0,-rad,-rad>*0.9}
  object{screw rotate x*15 translate<0,-rad, rad>*0.9}
  object{screw rotate -x*35 translate<0,rad,rad>*0.9}
  object{screw rotate x*35 translate<0,rad,-rad>*0.9}

  // Rim
  torus{rad, rim_size rotate<0,0,90>scale<3,1,1>texture{rim_T}}

  // Glass
  disc{<0,0,0><1,0,0> 1
       texture{pigment{color rgbt<1,1,1,1>}
               finish{ambient 0.5 diffuse 0.5 phong 1 phong_size 5}}
       scale <1,rad,rad>
       translate<0.002,0,0>
  }

  // Face
  disc{<0,0,0><1,0,0> 1
       texture{pigment{color rgb 0}
               finish{ambient 0.5 diffuse 0.5 phong 1 phong_size 10} }
       scale <1,rad,rad>
       translate<0.0001,0,0>
  }

  // Marks
  polygon{4,<0,0,0><0,-1,0><0,-1,-0.57735><0,0,0>
          pigment{color rgb<1,0,0>}finish{ambient 1}
          clipped_by{sphere{<0,0,0>,rad}}
          translate<0.0002,0,0>
  } 
  #local ni=9;
  #local i=0;
  #while (i<ni)
    #local theta = -30 + i * 240/(ni-1);
        box{<0,0.75*rad,-0.0005><0.0003,rad,0.0005>
            pigment{color rgb 1}finish{ambient 1}
            rotate<theta,0,0>}
    #local i=i+1;
  #end

  // Text
  text{ttf "cyrvetic.ttf" "E" 1, 0 rotate<90,0,90> scale 0.006*<0.1,1,1>
       pigment{color rgb 1}finish{ambient 1}
       translate<0,-0.55*rad,-0.6*rad>}
  text{ttf "cyrvetic.ttf" "Fuel" 1, 0 rotate<90,0,90> scale 0.006*<0.1,1,1>
       pigment{color rgb 1}finish{ambient 1}
       translate<0,-0.25*rad,0.25*rad>}
  text{ttf "cyrvetic.ttf" "F" 1, 0 rotate<90,0,90> scale 0.006*<0.1,1,1>
       pigment{color rgb 1}finish{ambient 1}
       translate<0,0.4*rad,-0.6*rad>}

  // Warning light
  #local lrad = 0.0025;
  union{
    torus{lrad, 0.1*lrad rotate<0,0,90>scale<3,1,1>texture{rim_T}}
    sphere{<0,0,0>, 0.9*lrad scale<0.25,1,1>
          texture{
          #if ( warn )
               pigment{color rgb<1,0.1,0.0>}
               finish{ambient 1}
          #else
               pigment{color rgb<0.5,0,0>}
               finish{ambient 0.1 diffuse 0.5 phong 1 phong_size 20}
          #end
                 }
          }
    translate <0,0,-0.75*rad>
  }

  // Needle
  sphere{<0,0,0>, 0.0015 scale<0.1,1,1> translate 0.001*x texture{T_panel}}
  cone{<0,0,0>, 0.9*rim_size <0,0.7*rad,0>, 0.3*rim_size
            rotate<(210 - 240*level),0,0>
            texture{pigment{color rgb 1}finish{ambient 0.6 diffuse 0.6 }}
           }

  } // end union

#end
