
#include "fuel.inc"

global_settings { max_trace_level 5 }
background{color rgb 1}

#declare t0 = clock;

#macro shake( a )
  #local m = 2*pi*a;
  #local ts = (sin(3*m) + sin(7*m) + sin(11*m) + sin(13*m))/4;
  (ts/4)
#end

#declare film_size = 0.035;
#declare focal_length = 0.05;
#declare aspect_ratio = image_height / image_width;
camera{perspective
      location <0,0,0>
      direction <0,focal_length,0>
      right <film_size,0,0>
      up <0,0,film_size*aspect_ratio> 
      rotate z*90
      rotate<0, 4.0*abs(shake(t0)), -2*shake(t0)>
      translate<0.1,0,0>

}

light_source{<2e6,-1e6,1e6>color rgb 0.9}
global_settings{ambient_light rgb 0.5}

#declare warn = 0;
#declare fuel = 0.9 - clock*0.2;
make_fuel( fuel, warn )
