
#include "scene.inc"
#include "car.inc"

#declare n_frames = (final_frame - initial_frame) + 1;

global_settings{max_trace_level 16}
global_settings{ambient_light rgb 0.5}
global_settings{number_of_waves 1 }
background{color rgb 0.5}

#declare cam_pos = <7,0,0.6>;
#declare cam_rot = <4,0,90>;

#declare start_time = 0.25;
#if ( clock <= start_time )
  #declare flame_flag = 0;
  #declare car_pos = <0,0,0>;
#else
  #declare tc = (clock - start_time)/(1-start_time);
  #declare flame_flag = 1;
  #declare car_pos = <-pow(tc,2)*5,0,0>;

  plane{x, 6.5 pigment{bozo frequency 1 turbulence 0.2 octaves 6 omega 0.2 lambda 2
                       translate <2.0*tc*n_frames,0,0>
                       scale 0.06
                       color_map{[0 color rgbt<0.7,0.7,0.7,1-0.75*tc>][1 rgbt<1,1,1,1-0.75*tc>]}}
                       finish{ambient 1}
       hollow no_shadow}

#end

#declare blur_factor = 0;
make_car(car_pos.x, flame_flag, blur_factor )

#declare film_size = 0.035;
#declare focal_length = 0.05;
#declare aspect_ratio = image_height / image_width;
camera{perspective
      location <0,0,0>
      direction <0,focal_length,0>
      right <film_size,0,0>
      up <0,0,film_size*aspect_ratio>
      rotate cam_rot translate cam_pos

      #if ( clock > start_time)
        normal{ ripples 0.0075 
               translate<0.5,0,0>scale <0.1,0.13,0.1>
               frequency 1 phase -clock* 0.3*n_frames }
      #end
}
light_source{<1e6,-1e6,1e6>color rgb <0.9,0.9,0.9>}
light_source{<-1e6,-1e5,1e6> color rgb 0.5 shadowless}

#declare blur_factor = 0;
make_flats( blur_factor )
