
#include "scene.inc"
#include "cockpit.inc"
#include "figure.inc"

global_settings { max_trace_level 9 }
background{color rgb 0.5}

#declare t0 = 0.5*clock-0.25;

#macro shake( a )
  #local m = 2*pi*a;
  #local ts = (sin(3*m) + sin(7*m) + sin(11*m) + sin(13*m))/4;
  (ts/3)
#end

#declare car_pos = 300-600*clock;
#declare cam_pos = <car_pos + 1.2, 0,0.77>;

#declare film_size = 0.035;
#declare focal_length = 0.05;
#declare aspect_ratio = image_height / image_width;
camera{perspective
      location <0,0,0>
      direction <0,focal_length,0>
      right <film_size,0,0>
      up <0,0,film_size*aspect_ratio>
      rotate<0,0,90> 

      rotate<0, 4.0*abs(shake(t0)), -3*shake(t0)>
      translate cam_pos
}

light_source{<2e6,-1e6,1e6>color rgb 0.9}
light_source{<-1e4,-1e6,1e10> color rgb 0.5 shadowless}
global_settings{ambient_light rgb 0.5}

#declare blur_factor = 50;
make_flats( blur_factor )

#declare theta = shake(2*t0)*30;

#declare thrust = 0.4+0.4*clock;
make_cockpit_foreward_view( car_pos, thrust, theta )

#declare arm_radius = 0.027;

// right arm
#declare shoulder_pos = <car_pos+1.2,0.16,0.7>;
#declare hand_pos = <car_pos+0.92,
                    arm_radius*cos(radians(-theta)),0.715+arm_radius*sin(radians(-theta))>;
make_arm(shoulder_pos, hand_pos, <-theta+30,0,0>, 1   )

// left arm
#declare shoulder_pos = <car_pos+1.2,-0.16,0.7>;
#declare hand_pos = <car_pos+0.92,
                   -arm_radius*cos(radians(theta)),0.715+arm_radius*sin(radians(theta))>;
make_arm(shoulder_pos, hand_pos, <-theta-30,0,0>,  -1   )
