/*************************************************************************
        OBJECT EXPLODER INCLUDE FILE FOR PERSISTENCE OF VISION 3.x
**************************************************************************

Created by Chris Colefax, March 1997

Updated 10 August 1998: updated for POV-Ray 3.1,
                        added explode_start, explode_life, time_scale,
                        object_orientation option, and disintegration options,
                        increased parsing speed without ground plane,
                        fixed Domain Error caused by some compilers

Updated 23 August 1998: fixed time_scale bug, updated documentation

See "Explode.htm" for more information.

*************************************************************************/

// CHECK EXPLODE OBJECT AND CLOCK
// ******************************
   #declare _EX_tempver = version; #version 3.0;
   #ifndef (explode_object) #warning "No object specified for explosion!\n" #else
   #ifdef (explode_clock) #declare _EX_clock = explode_clock;
      #else #ifdef (explode_start) #declare _EX_clock = max(0, clock - explode_start);
         #else #declare _EX_clock = clock; #end #end
   #ifndef (explode_life) #declare _EX_explife = 0; #else #declare _EX_explife = abs(explode_life); #end
   #ifndef (time_scale) #declare _EX_tscale = 1;    #else #declare _EX_tscale  = abs(time_scale);   #end

   #if (_EX_clock <= 0) object {explode_object}
      #else #if (_EX_explife = 0 | _EX_clock < _EX_explife)
      #declare _EX_clock = _EX_clock * _EX_tscale;

// DETERMINE OBJECT DIMENSIONS
// ***************************
   #ifdef (object_centre) #declare _EX_objcentre = object_centre * <1, 1, 1>;   
      #else #ifdef (object_center) #declare _EX_objcentre = object_center * <1, 1, 1>;
         #end #end
   #ifdef (object_orientation) #declare _EX_objorient = object_orientation * <1, 1, 1>;
      #else #declare _EX_objorient = <0, 0, 0>; #end
   #ifndef (object_hollow) #declare object_hollow = true; #end

// DETERMINE OBJECT SIZE IF NOT SPECIFIED
// **************************************
   #ifdef (_EX_objcentre) #declare _EX_ocentre = _EX_objcentre;
      #ifdef (object_size)
         #declare _EX_osize = object_size * <1, 1, 1>;
      #else #ifdef (object_corner1)
         #declare _EX_osize = <2, 2, 2> * (_EX_ocentre - object_corner1);
      #else #ifdef (object_corner2)
         #declare _EX_osize = <2, 2, 2> * (_EX_ocentre - object_corner2);
      #else #declare _EX_osize = <2, 2, 2>;
   #end #end #end

// DETERMINE OBJECT CENTRE IF NOT SPECIFIED
// ****************************************
   #else #ifdef (object_size) #declare _EX_osize = object_size * <1, 1, 1>;
      #ifdef (object_corner1)
         #declare _EX_ocentre = object_corner1 + (_EX_osize / 2);
      #else #ifdef (object_corner2)
         #declare _EX_ocentre = object_corner2 - (_EX_osize / 2);
      #else #declare _EX_ocentre = <0, 0, 0>;
   #end #end

// DETERMINE OBJECT CENTRE & SIZE IF NEITHER SPECIFIED
// ***************************************************
   #else #ifdef (object_corner1) #ifdef (object_corner2)
      #declare _EX_ocentre = (object_corner1 + object_corner2) / <2, 2, 2>;
      #declare _EX_osize   =  (object_corner1 - object_corner2) * <1, 1, 1>;
   #else
      #declare _EX_ocentre = <0, 0, 0>;
      #declare _EX_osize   = <2, 2, 2> * object_corner1;
   #end #else
      #ifdef (object_corner2)
         #declare _EX_ocentre = <0, 0, 0>;
         #declare _EX_osize   = <2, 2, 2> * object_corner2;
      #else
         #declare _EX_ocentre = <0, 0, 0>;
         #declare _EX_osize   = <2, 2, 2>;
   #end #end #end #end
   #declare _EX_osize = <abs(_EX_osize.x), abs(_EX_osize.y), abs(_EX_osize.z)>;

// DETERMINE PARTICLE PARAMETERS
// *****************************
   #ifdef (particle_res)
      #declare _EX_pres = particle_res * <1, 1, 1>;
      #declare _EX_pres = <abs(int(_EX_pres.x)), abs(int(_EX_pres.y)), abs(int(_EX_pres.z))>;
      #if (_EX_pres.x < 1) #declare _EX_pres = <1, _EX_pres.y, _EX_pres.z>; #end
      #if (_EX_pres.y < 1) #declare _EX_pres = <_EX_pres.x, 1, _EX_pres.z>; #end
      #if (_EX_pres.z < 1) #declare _EX_pres = <_EX_pres.x, _EX_pres.y, 1>; #end
   #else
      #declare _EX_pres = <3, 3, 3>;
   #end

   #ifndef (particle_object)  #declare particle_object  = box {<-.5, -.5, -.5>, <.5, .5, .5>}  #end
   #ifndef (particle_texture) #declare particle_texture = texture {pigment {rgb <.5, .5, .5>}} #end
   #ifndef (disintegration)   #declare disintegration   = .5;                                  #end
   #declare _EX_gridsize    = _EX_osize / _EX_pres;
   #declare _EX_gridstart   = _EX_ocentre + (_EX_gridsize / 2) - (_EX_osize / 2);
   #declare _EX_gridstop    = _EX_ocentre + (_EX_osize / 2);

   #declare _EX_pscale = _EX_gridsize;
   #if (disintegration != 0 & _EX_explife != 0)
      #declare _EX_pscale = _EX_pscale * (pow(1 - (_EX_clock / _EX_tscale / _EX_explife), disintegration) + .01);
   #end
   #declare _EX_pobject = object {particle_object scale _EX_pscale}

// DETERMINE EXPLOSION PARAMETERS
// ******************************
   #ifdef (exp_location) #declare _EX_eloc = exp_location * <1, 1, 1>;
      #else #declare _EX_eloc = <0, 0, 0>; #end
   #ifdef (exp_spin) #declare _EX_spin = exp_spin * <1, 1, 1>;
      #else #declare _EX_spin = <0, 0, 0>; #end
   #ifndef (exp_strength) #declare exp_strength = 10; #end
   #ifndef (exp_falloff)  #declare exp_falloff  =  0; #end
   #ifndef (exp_gravity)  #declare exp_gravity  =  0; #end
   #ifndef (exp_sky) #declare exp_sky = y;
      #else #declare exp_sky = vnormalize(exp_sky); #end
   #declare _EX_grav = -exp_sky * abs(exp_gravity);

// DETERMINE GROUND PARAMETERS
// ***************************
   #ifndef (ground_plane) #declare ground_plane = false;
      #else #if (ground_plane != false)
         #ifndef (ground_dist) #declare ground_dist = 0; #end
         #ifndef (ground_reflection) #declare ground_reflection = 0;
            #else #declare ground_reflection = abs(ground_reflection); #end
         #ifndef (max_bounces) #declare max_bounces = 1;
            #else #declare max_bounces = abs(max_bounces); #end
         #if (exp_sky.y != 1)
            #declare _EX_wrotx = vlength(exp_sky * <1, 0, 1>);
               #if (_EX_wrotx != 0 | exp_sky.y != 0) #declare _EX_wrotx = degrees(atan2(vlength(exp_sky * <1, 0, 1>), exp_sky.y)); #end
            #declare _EX_wroty = exp_sky.x;
               #if (_EX_wroty != 0 | exp_sky.z != 0) #declare _EX_wroty = degrees(atan2(exp_sky.x, exp_sky.z)); #end
            #declare _EX_grav  = -y * abs(exp_gravity);
   #end #end #end

// DETERMINE TURBULENCE (RANDOMNESS) PARAMETERS
// ********************************************
   #ifndef (exp_turb) #declare exp_turb = 0;
      #else #if (exp_turb != 0)
         #ifdef (exp_seed) #declare _EX_rand = seed(exp_seed);
            #else #declare _EX_rand = seed(0); #end
         #ifndef (scale_turb) #declare _EX_sturb = exp_turb;
            #else #declare _EX_sturb = scale_turb * exp_turb; #end
         #ifndef (rotate_turb) #declare _EX_rturb = exp_turb;
            #else #declare _EX_rturb = rotate_turb * exp_turb; #end
         #ifndef (vel_turb) #declare _EX_vturb = exp_turb;
            #else #declare _EX_vturb = vel_turb * exp_turb; #end
         #ifndef (dir_turb) #declare _EX_dturb = exp_turb;
            #else #declare _EX_dturb = dir_turb * exp_turb; #end
         #ifndef (spin_turb) #declare _EX_spturb = exp_turb;
            #else #declare _EX_spturb = spin_turb * exp_turb; #end
   #end #end

// CREATE EXPLOSION
// ****************
   union {
      #declare _EX_gridx = _EX_gridstart.x; #while (_EX_gridx < _EX_gridstop.x)
         #declare _EX_gridy = _EX_gridstart.y; #while (_EX_gridy < _EX_gridstop.y)
            #declare _EX_gridz = _EX_gridstart.z; #while (_EX_gridz < _EX_gridstop.z)

// CREATE PARTICLE FROM ORIGINAL OBJECT
// ************************************
   #if (exp_turb = 0)
      #declare _EX_pscale  = <1, 1, 1>;
      #declare _EX_protate = <0, 0, 0>;
   #else
      #declare _EX_pscale  = 1 + ((<rand(_EX_rand), rand(_EX_rand), rand(_EX_rand)> - .5) * _EX_sturb * 2);
      #declare _EX_protate = (1 + ((<rand(_EX_rand), rand(_EX_rand), rand(_EX_rand)> - .5) * _EX_rturb)) * 360;
   #end

   #declare _EX_ptrans = <_EX_gridx, _EX_gridy, _EX_gridz>;
   #if (_EX_objorient.x != 0 | _EX_objorient.y != 0 | _EX_objorient.z != 0)
      #declare _EX_ptrans = vrotate(_EX_ptrans - _EX_ocentre, _EX_objorient) + _EX_ocentre;
   #end

   #declare _EX_ptransform = transform {
      rotate _EX_protate
      rotate _EX_objorient
      translate _EX_ptrans}

   #declare _EX_particle = #if (object_hollow = false)
      intersection {object {explode_object}
         object {_EX_pobject  scale _EX_pscale * 1.01  transform _EX_ptransform
            texture {particle_texture}}
   #else object {explode_object #end
      clipped_by {_EX_pobject  scale _EX_pscale * 1.02  transform _EX_ptransform}
      translate -_EX_ptrans}

// CALCULATE INITIAL PARTICLE VELOCITY
// ***********************************
   #if (exp_strength = 0) #if (exp_turb = 0)
      #declare _EX_pvel = <0, 0, 0>;
      #else
         #declare _EX_pvel = (<rand(_EX_rand), rand(_EX_rand), rand(_EX_rand)> - .5) * _EX_gridsize * _EX_vturb * 2;
      #end
   #else
      #declare _EX_pvel = _EX_ptrans - _EX_eloc;
      #if (exp_falloff = 0)
         #declare _EX_pvel = vnormalize(_EX_pvel) * exp_strength;
      #else
         #declare _EX_pvel = vnormalize(_EX_pvel) * pow(.25, vlength(_EX_pvel) / exp_falloff) * exp_strength;
      #end
      #if (exp_turb != 0)
         #declare _EX_pvel = _EX_pvel * (1 + ((<rand(_EX_rand), rand(_EX_rand), rand(_EX_rand)> - .5) * _EX_vturb * 2));
         #declare _EX_pvel = vrotate(_EX_pvel, (<rand(_EX_rand), rand(_EX_rand), rand(_EX_rand)> - .5) * _EX_dturb * 360);
      #end
   #end

// CALCULATE PARTICLE LOCATION & SPIN
// **********************************
   #if (ground_plane = false)
      object {_EX_particle
      #if (exp_strength != 0 & vlength(_EX_spin) != 0)
         #declare _EX_pspin = _EX_spin * vlength(_EX_pvel) / exp_strength;
         #if (exp_turb != 0) #declare _EX_pspin = _EX_pspin * (1 + ((<rand(_EX_rand), rand(_EX_rand), rand(_EX_rand)> - .5) * _EX_spturb * 2)); #end
         rotate _EX_pspin * _EX_clock * 360
      #end
      translate _EX_ptrans + (_EX_pvel * _EX_clock) + (.5 * _EX_grav * _EX_clock * _EX_clock)
      }

// CREATE PARTICLE WITH GROUND PLANE
// *********************************
   #else #include "ExplodeG.inc" #end

// LOOP THROUGH PARTICLE GRID
// **************************
         #declare _EX_gridz = _EX_gridz + _EX_gridsize.z; #end
      #declare _EX_gridy = _EX_gridy + _EX_gridsize.y; #end
   #declare _EX_gridx = _EX_gridx + _EX_gridsize.x; #end
   }

   #else
      sphere {<0, 0, 0>, 0 pigment {rgb 0}}
   #end #end #end
   #version _EX_tempver;
