
//------------------------------------------
#if (show_Profil)
    #declare Profiltiefe  = 0.03;
    #declare Profillaenge = 0.08;
    #declare Profilbreite = 0.024;
    #declare Profilwinkel = 30;

    #declare Profil_hinten =
        difference {
            cylinder {z*-Profilbreite/2,z*Profilbreite/2,Hinterrad_Durchmesser/2+0.1}
            cylinder {z*-Profilbreite  ,z*Profilbreite  ,Hinterrad_Durchmesser/2-Profiltiefe}
            texture {cobraProfil}
    }
    #local Profil_U = 2*(Hinterrad_Durchmesser/2-Profiltiefe)*pi;
    #local Profil_n = 2 * int (0.5*Profil_U/Profillaenge);
    #declare Profillaenge = (Profil_U/Profil_n)/cos(radians(Profilwinkel));
    #local Profil_a = 360/Profil_n;
    #declare Profil_T1 = 
        box {
            <-Profillaenge/2-Profilbreite/2,0,-Profilbreite/2>
            < Profillaenge/2+Profilbreite/2,2*Profiltiefe,Profilbreite/2>
    }
    #declare Profil2_hinten =
    union {
        #local Cnt = 0;
        #while (Cnt<Profil_n)
            object { Profil_T1 rotate y*Profilwinkel translate y*(Hinterrad_Durchmesser/2-Profiltiefe) rotate z*Profil_a*Cnt} 
            object { Profil_T1 rotate y*-Profilwinkel translate y*(Hinterrad_Durchmesser/2-Profiltiefe) rotate z*(Profil_a*(Cnt+1))} 
            #local Cnt = Cnt+2;
        #end
        texture {cobraProfil}
    }
#end
//------------------------------------------

#declare Reifen_hinten =
union {
    #if (show_Profil)
        difference {
            sphere {
                0,Hinterrad_Durchmesser/2
                clipped_by {
                    plane{z,0.3}
                    plane{-z,0.3}
                }
                scale <1,1,1.5>
            }
            object {Profil_hinten}
            object {Profil2_hinten translate z*0.16}
            object {Profil2_hinten rotate z*Profil_a translate z*0.32}
            object {Profil2_hinten rotate z*Profil_a translate z*-0.16}
            object {Profil2_hinten translate -z*0.32}
    }
    #else
        sphere {
            0,Hinterrad_Durchmesser/2
            clipped_by {
                plane{z,0.3}
                plane{-z,0.3}
            }
            scale <1,1,1.5>
        }
    #end


    torus { 
        0.78464054,0.252856449 
        clipped_by { plane{y,0} }
        scale <1,0.3,1>
        rotate x*90
        translate -z*.45
    }
    torus { 
        0.78464054,0.252856449 
        clipped_by { plane{y,0} }
        scale <1,0.3,1>
        rotate -x*90
        translate z*.45
    }

    texture {cobraReifen}
}
//------------------------------------------
#if (show_Profil)
    #declare Profiltiefe  = 0.03;
    #declare Profillaenge = 0.08;
    #declare Profilbreite = 0.024;
    #declare Profilwinkel = 30;

    #declare Profil_vorne =
        difference {
            cylinder {z*-Profilbreite/2,z*Profilbreite/2,Vorderrad_Durchmesser/2+0.1}
            cylinder {z*-Profilbreite  ,z*Profilbreite  ,Vorderrad_Durchmesser/2-Profiltiefe}
            texture {cobraProfil}
    }
    #local Profil_U = 2*(Vorderrad_Durchmesser/2-Profiltiefe)*pi;
    #local Profil_n = 2 * int (0.5*Profil_U/Profillaenge);
    #declare Profillaenge = (Profil_U/Profil_n)/cos(radians(Profilwinkel));
    #local Profil_a = 360/Profil_n;
    #declare Profil_T1 = 
        box {
            <-Profillaenge/2-Profilbreite/2,0,-Profilbreite/2>
            < Profillaenge/2+Profilbreite/2,2*Profiltiefe,Profilbreite/2>
    }
    #declare Profil2_vorne =
    union {
        #local Cnt = 0;
        #while (Cnt<Profil_n)
            object { Profil_T1 rotate y*Profilwinkel translate y*(Vorderrad_Durchmesser/2-Profiltiefe) rotate z*Profil_a*Cnt} 
            object { Profil_T1 rotate y*-Profilwinkel translate y*(Vorderrad_Durchmesser/2-Profiltiefe) rotate z*(Profil_a*(Cnt+1))} 
            #local Cnt = Cnt+2;
        #end
        texture {cobraProfil}
    }
#end
//------------------------------------------
#declare Reifen_vorne =
union {
    #if (show_Profil)
        difference {
            sphere {
                0,Vorderrad_Durchmesser/2
                clipped_by {
                    plane{z,0.2}
                    plane{-z,0.2}
                }
                scale <1,1,2>
            }
            object {Profil_vorne}
            object {Profil2_vorne translate z*0.15}
            object {Profil2_vorne rotate z*Profil_a translate z*0.3}
            object {Profil2_vorne rotate z*Profil_a translate z*-0.15}
            object {Profil2_vorne translate -z*0.3}
    }
    #else
        sphere {
            0,Vorderrad_Durchmesser/2
            clipped_by {
                plane{z,0.2}
                plane{-z,0.2}
            }
            scale <1,1,2>
        }
    #end
    torus { 
        0.714890931,0.183106841 
        clipped_by { plane{y,0} }
        scale <1,0.3,1>
        rotate x*90
        translate -z*.4
    }
    torus { 
         0.714890931,0.183106841  
        clipped_by { plane{y,0} }
        scale <1,0.3,1>
        rotate -x*90
        translate z*.4
    }

    texture {cobraReifen}
}

#declare Radmutter_T1 =
union {
    box {<-0.04,-0.01,0><0.04,0.14,0.02> }
    cylinder {z*0,z*0.02,0.04 translate y*0.14}
}

#declare Radmutter =
union {
    cylinder { -z*0.43,-z*0.45,0.12 }
    #local Cnt = 0;
    #while (Cnt<3)
        object {Radmutter_T1 rotate x*-10 translate <0,0.12,-0.45> rotate z*(25+Cnt*120) }
        #local Cnt = Cnt+1;
    #end
    texture {cobraGold} 
}

#declare Speiche=
union {
    box {<-0.0,0,0><0.08,0.46,0.02> rotate z*15}
    box {<-0.08,0,0><0.0,0.46,0.02> rotate -z*15}
}

#declare Felge_hinten =
union {
    difference {
        cylinder { z*0.54,-z*0.54,0.6 }
        cylinder { z*0.56,-z*0.56,0.57 }
    }
    difference {
        cylinder { z*0.52,-z*0.52,0.57 }
        cylinder { z*0.56,-z*0.56,0.49 }
    }
    difference {
        cylinder { z*0.48,-z*0.48,0.49 }
        cylinder { z*0.56,-z*0.56,0.44 }
    }
    cylinder { z*0.43,-z*0.43,0.2 }
    #local Cnt = 0;
    #while (Cnt<6)
        object {Speiche rotate -x*10 translate -z*0.38 rotate z*(Cnt*60)}
        object {Speiche rotate  x*10 translate -z*0.43 rotate z*(30+Cnt*60)}
        #local Cnt = Cnt+1;
    #end
    cylinder { -z*0.43,-z*0.47,0.06 }
    sphere { 0,0.06 scale <1,1,0.5> translate -z*0.47 }
    object {Radmutter}
    texture {cobraChrom}
}
#declare Felge_vorne =
union {
    difference {
        cylinder { z*0.47,-z*0.47,0.6 }
        cylinder { z*0.56,-z*0.56,0.57 }
    }
    difference {
        cylinder { z*0.45,-z*0.45,0.57 }
        cylinder { z*0.56,-z*0.56,0.49 }
    }
    difference {
        cylinder { z*0.41,-z*0.41,0.49 }
        cylinder { z*0.56,-z*0.56,0.44 }
    }
    cylinder { z*0.36,-z*0.36,0.2 }
    #local Cnt = 0;
    #while (Cnt<6)
        object {Speiche rotate -x*10 translate -z*0.31 rotate z*(Cnt*60)}
        object {Speiche rotate  x*10 translate -z*0.36 rotate z*(30+Cnt*60)}
        #local Cnt = Cnt+1;
    #end
    cylinder { -z*0.36,-z*0.40,0.06 }
    sphere { 0,0.06 scale <1,1,0.5> translate -z*0.40 }
    object {Radmutter rotate z*12 translate z*0.07}
    texture {cobraChrom}
}

    #declare Vorderrad =
    union {
        object {Felge_vorne}
        object {Reifen_vorne}
    }
    #declare Hinterrad =
    union {
        object {Felge_hinten}
        object {Reifen_hinten}
    }
/*
#if (Test)
    #declare Vorderrad = object {Reifen_vorne}
    #declare Hinterrad = object {Reifen_hinten}
#else
    #declare Vorderrad =
    union {
        object {Felge_vorne}
        object {Reifen_vorne}
    }
    #declare Hinterrad =
    union {
        object {Felge_hinten}
        object {Reifen_hinten}
    }
#end

#declare Raeder =
union {
    object {Vorderrad 			   rotate -z*Vorderrad_Rotation rotate y*Lenk_Bewegung translate <0,Vorderrad_Durchmesser/2,-Rad_Abstand_vorne/2>}
    object {Vorderrad rotate y*180 rotate -z*Vorderrad_Rotation rotate y*Lenk_Bewegung translate <0,Vorderrad_Durchmesser/2, Rad_Abstand_vorne/2>}    
    object {Hinterrad 			   rotate -z*Hinterrad_Rotation translate <-Achs_Abstand,Hinterrad_Durchmesser/2,-Rad_Abstand_hinten/2>}
    object {Hinterrad rotate y*180 rotate -z*Hinterrad_Rotation translate <-Achs_Abstand,Hinterrad_Durchmesser/2, Rad_Abstand_hinten/2>}
}
*/