#declare dust_file2 = dust_file

#declare DustPos   = CobraPos+<-2,1.5,0>;
#declare DustStart = StartPos+<-2,1.5,0>;

#declare DustDir = <0,0.5,0>;

#declare DustRmin = 8;
#declare DustRmax = 12;

#declare DustTime = 0.4;

#declare DustStartTime = -DustTime;
#declare DustStopTime  = 1;
#declare DustTotalTime = DustStopTime - DustStartTime;

#declare DustAnz = int(0.25*Frames*DustTotalTime) + 1;
#declare DustInc = 4/Frames;

#declare MainColor  = <1.0, 0.85, 0.6>;
#declare SecondaryColor = <0,0,0>; 

#declare EmissValueMin = 0.10;
#declare EmissValueMax = 0.18;

#declare TurbValue  = 2.8;
#declare Roughness  = 10;
#declare MinSamples = 1;
#declare MaxSamples = 5;
#declare Seed = seed(4925);

#if(make_dust)

#fopen file2 dust_file2 write
#write(file2, "#declare Anzahl = ",DustAnz,";\n")
#write(file2, "#declare DustArray = array[Anzahl][11]{\n")
#declare Cnt=DustStartTime;
#while (Cnt<=DustStopTime)
    #declare DustWeg = Cnt*Weg;
    #declare DustPos  = DustStart+<DustWeg,0,0>;
    #local DustPosX   = DustPos.x+2*(rand(Seed)-0.5);
    #local DustPosY   = DustPos.y+1*(rand(Seed)-0.5);
    #local DustPosZ   = 0.2*(rand(Seed)-0.5);    
    #declare DustDirRX = DustDir.x*(0.9+rand(Seed)*0.2);  
    #declare DustDirRY = DustDir.y*(0.9+rand(Seed)*0.2);  
    #declare DustDirRZ = DustPosZ;  
    #declare DustRotRX = 360*rand(Seed);
    #declare DustRotRY = 360*rand(Seed);
    #declare DustScaR = 0.9+rand(Seed)*0.1;
    #declare DustDrilR = (0.8+rand(Seed)*0.4);
    #write(file2, "{",Cnt,",",DustPosX,",",DustPosY,",",DustPosZ,",",DustDirRX,",",DustDirRY,",",DustDirRZ,",", DustRotRX,",", DustRotRY,",",DustScaR,",",DustDrilR,"},\n")
    #declare Cnt=Cnt+DustInc;
#end
#write (file2, "}\n")
#fclose file2
#end


#if(show_dust)

#declare DustTex = 
texture{
    pigment { color rgbf <1, 1, 1, 1> }
  finish { ambient 0 diffuse 0 }   
} 
#declare Dens1 =
density{
    spherical
    ramp_wave
    turbulence TurbValue octaves 6 lambda 4 omega 0.3
    color_map{
        [0.0 color rgbf SecondaryColor]
        [1.0 color rgb MainColor]
    }         
    scale 0.5               
}                         
#declare Dens2 = density{ color rgbf SecondaryColor }         

#include dust_file

#declare Dust =
union {
        #declare Cnt=0;
        #while (Cnt<DustAnz)
            #declare DustClock = DustArray[Cnt][0];

            #if ( (DustClock<=clock) & (DustClock >= (clock-DustTime)) ) 

                #declare dclock = (DustClock-clock)/DustTime;
                #declare rclock = 1-dclock;
                #declare eclock = pow(dclock, 2);
                
                #declare DustDirR= <DustArray[Cnt][4],DustArray[Cnt][5],DustArray[Cnt][6]>;
                #declare DustPos = <DustArray[Cnt][1],DustArray[Cnt][2],DustArray[Cnt][3]>;
                #declare DustRotR= <DustArray[Cnt][7],DustArray[Cnt][8],0>;
                #declare DustScal= DustArray[Cnt][9];
                #declare DustDril= z*(360*DustArray[Cnt][10]*dclock);            
                #declare DustRad = DustRmin + (DustRmax-DustRmin)*rclock;
                #declare EmissValue = EmissValueMax; // EmissValueMin + eclock*(EmissValueMax-EmissValueMin);
                sphere { 
                0,1
                //
                material {
                    texture {DustTex}
                    interior {  
                        media{
                            emission rgb EmissValue*MainColor
                            absorption rgb EmissValue*MainColor
                            intervals (11-Roughness)
                            samples MinSamples, MaxSamples        
                            confidence 0.9
                            variance 1/1000
                            density{
                                spherical
                                density_map{
                                        [0.0 Dens2]
                                        [1.0 Dens1]                             
                                }
                            }
                        }   
                    }
                }          
                hollow                
                scale DustRad
                scale DustScal
                rotate DustRotR
                rotate DustDril 
                scale <1,0.6,1>
                translate DustPos
            }
            #end
            #declare Cnt=Cnt+1;
        #end
    clipped_by {plane{-y,0}}
}
object {Dust}
#end
