
#if (make_stone)
  #fopen file1 stone_file write
    #declare Cnt = 0;
    #write(file1, "#declare Anzahl = ",Anzahl,";\n")
    #write(file1, "#declare StonesArray = array[Anzahl][9]{\n")
    #while(Cnt<Anzahl)
        #declare tmpclock =  -0.2+rand(Seed)*7.5;
        #declare Point  =  DriveSpline(tmpclock);
        #declare AlphaC = asin(Point.z/Achs_Abstand);
        #declare XC     = sqrt((Achs_Abstand*Achs_Abstand)-(Point.z*Point.z))+Point.x-Achs_Abstand ;
        #declare RB     = (2*(rand(Seed)-0.5)*0.4);
        #declare VRB    = vrotate(<-0.3,0,RB>,<0,AlphaC,0>);
        #local PointX = Point.x+VRB.x-Achs_Abstand+(Rad_Abstand_hinten/2)*sin(AlphaC);
        #local PointZ = Point.z+VRB.z+(Rad_Abstand_hinten/2)*cos(AlphaC);
        #declare ZufallsWinkel = 360*rand(Seed);
        #declare WurfWinkel =  15+28*(2*(rand(Seed)-0.5));
        #declare RichtungsWinkel = AlphaC + 2*(2*(rand(Seed)-0.5));
        #declare Velo = (0.5+rand(Seed))*3;
        #declare Pigm = (0.5+rand(Seed));                
        #declare Scal = (0.6+0.4*rand(Seed));
        #write(file1, "{",tmpclock,",",PointX,",",PointZ,",",ZufallsWinkel,",",WurfWinkel,",",RichtungsWinkel,",",Velo,",",Pigm,",",Scal,"},\n")
        #declare Cnt = Cnt+1;
     #end
     #write(file1, "}\n")
  #fclose file1
#end

#if(show_stone)
//-----------------------------------------------------------------
  #declare MainColor  = <1.0, 0.85, 0.6>;
  #declare SecondaryColor = <0,0,0>;
  #declare DustRad = 0.4;
  #declare EmissValue = 6;
  #declare TurbValue  = 2.6;
  #declare Roughness  = 10;
  #declare MinSamples = 1;
  #declare MaxSamples = 5;
  #declare DustTex = 
  texture{
    pigment { color rgbf <1, 1, 1, 1> }
    finish { ambient 0 diffuse 0 }   
  } 
  #declare Dens1 =
  density{
    spherical
    ramp_wave
    turbulence TurbValue octaves 6 lambda 4 omega 0.3
    color_map{
        [0.0 color rgbf SecondaryColor]
        [1.0 color rgb MainColor]
    }         
    scale 0.5               
  }                         
  #declare Dens2 = density{ color rgbf SecondaryColor }   
//-----------------------------------------------------------------
  #include stone_file
    #declare gE = 6; // 9.81;     // m/s^2
    #declare Cnt = 0;
    #while(Cnt<Anzahl)
        #declare TimeVgl = StonesArray[Cnt][0];
        #if (TimeVgl<clock*6)
            #declare v0 = StonesArray[Cnt][6];       // m/s
            #declare rho = -StonesArray[Cnt][4];      // Grad
            #declare Dauer = 2*v0*sin(radians(rho))/gE;            // sec
            #if ((Dauer+TimeVgl)<clock*6)
                #declare Pigm = StonesArray[Cnt][7];
                #declare t1 = ((clock*6)-TimeVgl)/Dauer;
                #declare x1 =  v0*cos(radians(rho))*t1;
                #declare y1 = (v0*sin(radians(rho))*t1) - (gE*t1*t1*0.5);
                #declare V1 = vrotate(<x1,y1,0>,<0,StonesArray[Cnt][5],0>);
                #declare P =  <StonesArray[Cnt][1],0,StonesArray[Cnt][2]>+V1;
                sphere {
                    0, 1 
                    texture { 
                        pigment { color rgb <1.0, 0.85, 0.6>*Pigm }           
                        finish { ambient 0.15 diffuse 0.7 specular 0.1 }
                    }
                    scale <1,0.5,1>
                    rotate <StonesArray[Cnt][3],0,0.5*StonesArray[Cnt][3]>
                    scale R1*StonesArray[Cnt][8]
                    translate P
                }    
                #if(StonesArray[Cnt][7] >= 1.0) 
                  sphere {
                    0, 1 
                    material {
                      texture {DustTex}
                      interior {  
                        media{
                          emission rgb EmissValue*MainColor
                          absorption rgb EmissValue*MainColor
                          intervals (11-Roughness)
                          samples MinSamples, MaxSamples        
                          confidence 0.9
                          variance 1/1000
                          density{
                            spherical
                            density_map{
                              [0.0 Dens2]
                              [1.0 Dens1]                             
                            }
                          }
                        }   
                      }
                    }
                    hollow                
                    scale DustRad*StonesArray[Cnt][8]
                    rotate (clock*90)*z
                    translate P
                  }
                #end
            #end
        #end
        #declare Cnt = Cnt+1;
    #end
#end