// Persistence of Vision Ray Tracer Scene Description File
// File: dust.pov
// Vers: 3.5 
// Desc: Part of "topspeed - no risk"
// Date: Nov 2002
// Auth: D. Dittmann
//
// COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
//

#version 3.5;

#declare camera_type = 2;
#declare Frames = 120;

#declare Test       = off;

#declare show_fog   = on;
#declare show_rock  = on;
#declare show_sky   = on;
#declare show_road  = on;
#declare show_car   = on;
#declare show_palms = on;
#declare show_dust  = on;
#declare make_dust  = off;
#declare dust_file = "DustPara.inc" 

#declare show_Profil = off;
#declare show_Cockpit= on;
#declare show_Driver = on;

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "golds.inc"
#include "skies.inc"
#include "functions.inc"
#include "ts-textures.inc"

#default {finish {ambient 0.15}}

global_settings {
  max_trace_level 120
  assumed_gamma 2.4
}

#if (show_fog)
    fog {
        fog_type 2
        distance  8000
        color rgbt < 0.835, 0.835, 0.835,  0 >
        fog_alt  30
        fog_offset 50
    }
#end

#if (show_sky)
    #include "ts-sky.inc"
#else
    background { rgb 0 } //rgb <0.6,0.7,1.0> }
#end

// ----------------------------------------
#include "ts-params.inc"

#declare Weg = 200;
#declare Fahrweg = clock*Weg;
#declare StartPos = <-Weg/2,-0.1,0>;
#declare CobraPos = <Fahrweg,0,0>+StartPos;

#declare Lenk_Bewegung      =   0;

#declare Vorderrad_Rotation =  Fahrweg/(Vorderrad_Durchmesser*pi)*360;
#declare Hinterrad_Rotation =  Fahrweg/(Hinterrad_Durchmesser*pi)*360;

// ----------------------------------------

#if (show_car)
    #include "cobra_raeder.inc"
    #include "cobra_body.inc"
    #if (show_Driver)
        #include "driver.inc"
    #end
    #declare Raeder =
    union {
        object {Vorderrad          rotate -z*Vorderrad_Rotation rotate y*Lenk_Bewegung translate <0,Vorderrad_Durchmesser/2,-Rad_Abstand_vorne/2>}
        object {Vorderrad rotate y*180 rotate -z*Vorderrad_Rotation rotate y*Lenk_Bewegung translate <0,Vorderrad_Durchmesser/2, Rad_Abstand_vorne/2>}    
        object {Hinterrad          rotate -z*Hinterrad_Rotation translate <-Achs_Abstand,Hinterrad_Durchmesser/2,-Rad_Abstand_hinten/2>}
        object {Hinterrad rotate y*180 rotate -z*Hinterrad_Rotation translate <-Achs_Abstand,Hinterrad_Durchmesser/2, Rad_Abstand_hinten/2>}
    }   
    #declare Cobra =
    union{
        object {Raeder}
        object {cobraBody_T0}
        #if (show_Driver)
            object { Driver  scale 5.35 rotate y*90 translate<-4.3,-0.5,0.9>  translate y*Vorderrad_Durchmesser/2 }
        #end
        translate CobraPos
    }
    object {Cobra}
#end


// ----------------------------------------

#switch (camera_type)
#case (1)
    #declare camera_location        = <0, 2.2 , 60>; 
    #declare camera_direction       = <0, 0, 1>;
    #declare camera_sky             = <0, 1, 0>;
    #declare camera_right           = <image_width/image_height,0,0>;
    #declare camera_look_at         = CobraPos+<-6,0.5,0>;
    #break
#case (2)
    #declare camera_location        = <-12, 2.2 , 20>; 
    #declare camera_direction       = <0, 0, 2.6>;
    #declare camera_sky             = <0, 1, 0>;
    #declare camera_right           = <image_width/image_height,0,0>;
    #declare camera_look_at         = CobraPos+<-6,0.5,0>;
    #break
#end

camera {
    location        camera_location 
    direction       camera_direction
  sky             camera_sky  
  right           camera_right  
  look_at         camera_look_at
}

// ----------------------------------------

light_source {
        < -0.6, 0.54, 0.83>*150000
        SunCol2*1.5
        media_attenuation on
}
light_source {
        camera_location
        SunCol2*0.4
        shadowless
        media_attenuation off
}

// ----------------------------------------

#if (show_road)
    plane { y, 0 texture {Teer2 scale 400} }
#end
#if (clock>0.5)
#if(show_rock) 
  #declare filename = "Rocks.tga"
  object {
      height_field {
          tga filename
          texture {TerrainTex2}
      }  
      translate <-0.5,0,-0.5>
      scale  <HF_Length, HF_High,HF_Length>
      translate -y*Water_Level
      translate <3.5*HF_Length,0*HF_High,-0.2*HF_Length>
  } 
#end
#end
#if((make_dust)|(show_dust))
    #include "dust.inc"
#end

// ----------------------------------------
#if (clock>0.5)
#if(show_palms)
    #include "palms.inc"
    #declare Seed = seed(486);                     
    #declare cnt=0;
    #while (cnt<50)  
        #declare PalmScale = 1.5+(rand(Seed)-0.5);
        #declare PalmPosY = 0;
        #declare PalmPosX = 30*cnt+1200; 
        #while (abs(PalmPosY)<10)
            #declare PalmPosY = (rand(Seed)-0.5)*80;  
        #end
        #declare PalmPos = <PalmPosX,0,PalmPosY>;
        palmtree(PalmScale,PalmPos)
    #declare cnt=cnt+1;
    #end
#end
#end