// LENS EFFECTS: FLICKERING CANDLE ANIMATION
// *****************************************
// This animation shows how you can use the effect_flicker,
// effect_jitter, and rays_flicker options to animate lens effects.
// It also shows how the options_only variable can be used when
// creating multiple copies of the same lens effect.

// BACKGROUND
   plane {z, 20 pigment {rgb <.3, 0, 0>} normal {bumps 1 scale <5, 25, 5>}}

// CANDLESTICK
   union {
      cone {<0, 2, 0>, .5, <0, 2.5, 0>, 1 open} sphere {<0, 2, 0>, .6}
      cone {<5, 0, 0>, .5, <5, .5, 0>, 1 open} sphere {<5, 0, 0>, .6}
      cone {<-5, 0, 0>, .5, <-5, .5, 0>, 1 open} sphere {<-5, 0, 0>, .6}
      cylinder {<0, -10, 0>, <0, 2, 0>, .3}
      torus {5, .2 rotate x * 90 clipped_by {box {<-6, -6, -1>, <6, 0, 1>}}}
      torus {1.1, .1 rotate x * 90 translate y * -5} sphere {y * -5, .5}
      pigment {rgb <.8, .7, .2>} finish {phong .8 phong_size 95 reflection .4 metallic}
      no_shadow}

// CANDLES
   union {
      cylinder {<0, 2, 0>, <0, 9, 0>, .5}
      cylinder {<5, 0, 0>, <5, 7, 0>, .5}
      cylinder {<-5, 0, 0>, <-5, 6.5, 0>, .5}
      pigment {rgb 1} finish {phong .3 phong_size 3}
      no_shadow}

// LIGHTING
   light_source {<0, 40, -80> rgb 1}

// CAMERA OPTIONS
   #declare camera_location = <4, 4, -20>;
   #declare camera_look_at = <0, 4, 0>;

// EFFECT OPTIONS
   #declare effect_brightness = 2;
   #declare effect_intensity = 2;
   #declare effect_type = "Candle"
   #declare options_only = true;
   #include "LENS.INC"

// EFFECT ANIMATION OPTIONS
   #declare effect_flicker = .2;
   #declare rays_flicker = true;
   #declare effect_jitter = .1;

// CREATE MULTIPLE LENS EFFECTS
   #declare effect_location = <0, 10, 0>; #include "LNSEFCTS.INC"
   #declare effect_location = <5, 8, 0>; #include "LNSEFCTS.INC"
   #declare effect_location = <-5, 7.5, 0>; #include "LNSEFCTS.INC"

   global_settings {max_trace_level 20}
