
// =================================================
/*

  POV-Ray 3.5 Source

  Created by Richard Webster irtc_mail@yahoo.co.uk

  for the Internet Ray Tracing Competition

  April 2003 Animation Round www.irtc.org

*/
// =================================================


#include "scene.inc"
#include "figure.inc"

// lead runner
#declare p_fig = <0,0,0> + x * (145 + real_time*running_speed);
#declare v_dir = <1,0,0>;
#declare v_side = <0,1,0>;
#declare v_up = <0,0,1>;

// -------------------------------------------------------

#declare R1 = seed(1);
#declare ni = 5;
#declare i=0;
#while(i<ni)

  #if ( i=0 )
    #declare action_delay = 0;
  #else
    #declare action_delay = 0.25 + 0.25*i;
  #end

  #declare t_move = transition(-1, 2, real_time - action_delay);

  #declare ti=i/(ni-1);
  #declare fig_phase = ti;
  #declare fx = p_fig.x - 4*i/3;
  #declare fy = p_fig.y - 5.7 + 6.7*motion(t_move);
  #declare fz = p_fig.z;

    set_pose_running( pose, real_time+fig_phase )

    #declare cross_theta = 40 * (1-pow(t_move,3));
    #declare v_dir_cross = vrotate(v_dir,<0,0,cross_theta>);
    #declare v_side_cross = vrotate(v_side,<0,0,cross_theta>);

    object{make_figure( <fx,fy+0.1*sin((0.3*real_time-fig_phase)*2*pi),fz>,
           v_dir_cross, v_side_cross, v_up, pose ) }

  #declare i=i+1;
#end



// rolling rocks

#declare dir_rock = <1,2.5,0>;

#declare R2 = seed(2);
#declare ni = 5;
#declare i=0;
#while(i<ni)

  #if( real_time < 4 )
    #declare p_rock = p_fig - 7*x - i*0.8*dir_rock - 6.5*dir_rock + real_time*dir_rock*3.5;
  #else
    #declare p_rock = p_fig - 7*x - i*0.8*dir_rock - 6.5*dir_rock + 5*dir_rock*3.5;
  #end
  
  object{rock scale 0.35 rotate<360*rand(R2),360*rand(R2),360*rand(R2)>
         texture{T_rock}
         rotate <-2*real_time*360, 0, -40> translate p_rock + z*0.38
        }

  #declare i=i+1;
#end

// --------------------------------------------------------------------

// Camera

#declare film_size = 0.035;
#declare focal_length = 0.05;
#declare aspect_ratio = image_height / image_width;

#if(real_time < 4)
  #declare p_cam = <p_fig.x+5,0,1.5>;
  #declare theta = 90;
#else
  #declare p_cam = <175,-4,1.4>;
  #declare theta = 90+degrees(atan2(p_cam.y-p_fig.y,p_cam.x-p_fig.x));
#end

#declare fade_start = 9.5;
#declare fade_stop = 10.5;

#if (real_time > fade_start)

  #if (real_time <= fade_stop)
    #declare fade = 1-(real_time-fade_start)/(fade_stop-fade_start);
  #else
    #declare fade = 0;
  #end

  sphere{p_cam, 0.1 pigment{color rgbt<0,0,0,fade>}finish{ambient 1} no_shadow hollow}
#end

camera{perspective
      location <0,0,0>
      direction <0,focal_length,0>
      right <film_size,0,0>
      up <0,0,film_size*aspect_ratio>
      rotate<-6,0,0>
      rotate theta*z
      translate p_cam
}


