
// =================================================
/*

  POV-Ray 3.5 Source

  Created by Richard Webster irtc_mail@yahoo.co.uk

  for the Internet Ray Tracing Competition

  April 2003 Animation Round www.irtc.org

*/
// =================================================

#include "scene.inc"
#include "figure.inc"


// lead runner

#declare p_fig = <0,0,0> + x * (75 + real_time*running_speed);
#declare v_dir = <1,0,0>;
#declare v_side = <0,1,0>;
#declare v_up = <0,0,1>;

// -------------------------------------------------------

#declare cross1_start = 0;
#declare cross1_stop = 3.5;

#declare cross2_start = 4;
#declare cross2_stop = 7.5;

#declare cross3_start = 9.5;
#declare cross3_stop = 13;

#declare R1 = seed(1);
#declare R2 = seed(5);
#declare ni = 5;
#declare i=0;
#while(i<ni)
  #declare ti=i/(ni-1);
  #declare fig_phase = ti;
  #declare action_delay = 0.2*i;

  #declare figs = 0;

  // ----------------------------------------------------

  #if( (real_time >= cross1_start) & (real_time <= cross1_stop))
    
    #declare figs = 1;

    #declare tc = (real_time-action_delay-cross1_start)/(cross1_stop-cross1_start);

    #declare cross_theta = -40-180;

    #declare fx = p_fig.x - 3*i/3;
    #declare fy = p_fig.y + 0.1*sin((0.3*real_time-fig_phase)*2*pi) + (1*i/3)
                + 4 - 15 * tc;
    #declare fz = p_fig.z;

    set_pose_running_backwards( pose, real_time-fig_phase )

  #end

  // --------------------------------------------------

  #if( (real_time >= cross2_start) & (real_time <= cross2_stop))
    
    #declare figs = 1;

    #declare tc = (real_time-action_delay-cross2_start)/(cross2_stop-cross2_start);

    #declare cross_theta = 40;

    #declare fx = p_fig.x - 3*i/3;
    #declare fy = p_fig.y + 0.1*sin((0.3*real_time-fig_phase)*2*pi) - (1*i/3)
                - 4 + 15 * tc;
    #declare fz = p_fig.z;  

    set_pose_hands( pose, real_time-fig_phase )

  #end

  // --------------------------------------------------

  #if( (real_time >= cross3_start) & (real_time <= cross3_stop))
    
    #declare figs = 1;

    #declare tc = (real_time-action_delay-cross3_start)/(cross3_stop-cross3_start);

    #declare cross_theta = -40;

    #declare fx = p_fig.x - 3*i/3;
    #declare fy = p_fig.y + 0.1*sin((0.3*real_time-fig_phase)*2*pi) + (1*i/3)
                + 4 - 15 * tc;
    #declare fz = p_fig.z;

    set_pose_carrying( pose, real_time-fig_phase )

    object{rock scale 0.35 rotate<360*rand(R2),360*rand(R2),360*rand(R2)>
           texture{T_rock}
           translate (<fx,fy,0> + <0.33,-0.33,osc(1.8, 1.7, 2*(5/3), 0.0, real_time-fig_phase)> )
           }
      
  #end

  // --------------------------------------------------

  #if(figs)
    #declare v_dir_cross = vrotate(v_dir,<0,0,cross_theta>);
    #declare v_side_cross = vrotate(v_side,<0,0,cross_theta>);
    object{make_figure( <fx,fy,fz>, v_dir_cross, v_side_cross, v_up, pose ) }
  #end

  #declare i=i+1;
#end


// --------------------------------------------------------------------

// Camera

#declare film_size = 0.035;
#declare focal_length = 0.05;
#declare aspect_ratio = image_height / image_width;


camera{perspective
      location <0,0,0>
      direction <0,focal_length,0>
      right <film_size,0,0>
      up <0,0,film_size*aspect_ratio>
      rotate<-6,0,90>
      translate<p_fig.x+5,0,1.5>    
}


