
// =================================================
/*

  POV-Ray 3.5 Source

  Created by Richard Webster irtc_mail@yahoo.co.uk

  for the Internet Ray Tracing Competition

  April 2003 Animation Round www.irtc.org

*/
// =================================================


global_settings{ambient_light rgb 1}
camera{orthographic
       location<0,0,1>
       right<2,0,0>
       up<0,2,0>
       direction<0,0,-1>}

#declare P_flat = pigment{color rgb 0};
#declare P_lo = pigment{
  bozo frequency 1 turbulence 0.2 octaves 4 omega 0.3 lambda 2
   translate <0,0,0> scale 0.15
  color_map{[0 color rgb 0][1 color rgb 1]}
};
#declare P_hi = pigment{
  bozo frequency 1 turbulence 0.2 octaves 4 omega 0.3 lambda 2
   translate <0,0,0> scale 0.07
  color_map{[0 color rgb 0][1 color rgb 1]}
};
#declare P_hills = pigment{average pigment_map{[1 P_lo][1 P_hi]}};

plane{z,0
      pigment{cylindrical poly_wave 1 rotate 90*x
              pigment_map{[0 P_flat][0.1 P_hills][0.4 P_flat][1 P_flat]}}
      finish{ambient 1}
}
