
// =================================================
/*

  POV-Ray 3.5 Source

  Created by Richard Webster irtc_mail@yahoo.co.uk

  for the Internet Ray Tracing Competition

  April 2003 Animation Round www.irtc.org

*/
// =================================================


#include "scene.inc"
#include "figure.inc"


// lead runner
#declare p_fig = <0,1.2,0> + x * (-100 + real_time*running_speed);

#declare v_dir = <1,0,0>;
#declare v_side = <0,1,0>;
#declare v_up = <0,0,1>;

// -------------------------------------------------------

#declare R1 = seed(1);
#declare ni = 5;
#declare i=0;
#while(i<ni)
  #declare ti=i/(ni-1);
  #declare fig_phase = ti;
  #declare fx = p_fig.x - 4*i/3;
  #declare fy = p_fig.y + 0.2*sin((0.1*real_time-fig_phase)*2*pi);
  #declare fz = p_fig.z;

  set_pose_running( pose, real_time+ti ) 

  object{make_figure( <fx,fy+0.1*sin((0.3*real_time-fig_phase)*2*pi),fz>, v_dir, v_side, v_up, pose ) }

  #declare i=i+1;
#end


// --------------------------------------------------------------------

// Camera

#declare film_size = 0.035;
#declare focal_length = 0.05;
#declare aspect_ratio = image_height / image_width;


#declare p_cam = <-90,0,1.6>;
#declare fade_time = 0.75;

#if (real_time <= fade_time)
  #declare fade = real_time/fade_time;
  sphere{p_cam 0.01 pigment{color rgbt<0,0,0,fade>}finish{ambient 1} no_shadow hollow}
#end


camera{perspective
       location <0,0,0>
       direction <0,focal_length,0>
       right <film_size,0,0>
       up <0,0,film_size*aspect_ratio>
       rotate<-6,0,-90>
       translate p_cam}

