
// =================================================
/*

  POV-Ray 3.5 Source

  Created by Richard Webster irtc_mail@yahoo.co.uk

  for the Internet Ray Tracing Competition

  April 2003 Animation Round www.irtc.org

*/
// =================================================




// ----------------------------------------------------------------------------

// phase of flapping things

#declare whip = 1/3;

// ------------------------------------------------------------------------------

// Generate an oscillating parameter

#macro osc( o_min, o_max, o_freq, o_phase, time )
  (0.5*(o_max-o_min)*sin(time*o_freq*2*pi+o_phase*2*pi) + 0.5*(o_min+o_max))
#end

// ------------------------------------------------------------------------------

// Interpolate between two arrays of values

#macro Array_Interpolate( S, A, B, C )

  // set each C[i] to value interpolated between A[i] and B[i]

  #local n = dimension_size(A,1);
  #local i=0;
  #while(i<n)
    #declare C[i] = (1-S)*A[i] + S*B[i];
    #local i=i+1;
  #end
#end

// ------------------------------------------------------------------------------

// Interpolate between three arrays of values

#macro Array_Interpolate3( S, A, B, C, D )

  // set each D[i] to value interpolated between A[i] through B[i] to C[i]

  #local n = dimension_size(A,1);

  #if(S < 0.5)
    #local T = 2*S;
    #local i=0;
    #while(i<n)
      #declare D[i] = (1-T)*A[i] + T*B[i];
      #local i=i+1;
    #end
  #else
    #local T = 2*(S-0.5);
    #local i=0;
    #while(i<n)
      #declare D[i] = (1-T)*B[i] + T*C[i];
      #local i=i+1;
    #end
  #end

#end

// ------------------------------------------------------------------------------

// Interpolate between four arrays of values

#macro Array_Interpolate4( S, A, B, C, D, E )

  // set each E[i] to value interpolated between A[i], B[i], C[i] to D[i]

  #local n = dimension_size(A,1);

  #if(S < 1/3)
    #local T = 3*S;
    #local i=0;
    #while(i<n)
      #declare E[i] = (1-T)*A[i] + T*B[i];
      #local i=i+1;
    #end
  #end

  #if((S >= 1/3) & (S < 2/3))
    #local T = 3*(S-1/3);
    #local i=0;
    #while(i<n)
      #declare E[i] = (1-T)*B[i] + T*C[i];
      #local i=i+1;
    #end
  #end

  #if(S >= 2/3)
    #local T = 3*(S-2/3);
    #local i=0;
    #while(i<n)
      #declare E[i] = (1-T)*C[i] + T*D[i];
      #local i=i+1;
    #end
  #end

#end


// ------------------------------------------------------------------------------
//                               POSES
// ------------------------------------------------------------------------------

// running

#macro set_pose_running( pose_array, time )

  #local freq = 5/3;

  #declare pose_array[i_head_turn] = osc(-15, 15, freq, 0, time);
  #declare pose_array[i_head_swing] = osc(10, 5, 2*freq, 0, time);
  #declare pose_array[i_head_tilt] = osc(2, -2, freq, whip, time);

  #declare pose_array[i_upper_back_bend] = osc(5, 10, 2*freq, 0, time);
  #declare pose_array[i_upper_back_twist] = osc(15, -15, freq, 0, time);
  #declare pose_array[i_upper_back_tilt] = osc(-2, 2, freq, whip, time);

  #declare pose_array[i_lower_back_bend] = osc(-5, 0, 2*freq, 0, time);
  #declare pose_array[i_lower_back_twist] = osc(-5, 5, freq, 0, time);
  #declare pose_array[i_lower_back_tilt] = osc(-5, 5, freq, whip, time);

  #declare pose_array[i_left_arm_swing] = osc(-60, 20, freq, 0.0, time);
  #declare pose_array[i_left_arm_tilt] = 10;
  #declare pose_array[i_left_arm_twist] = -5;
  #declare pose_array[i_left_elbow_bend] = osc(70, 130, -freq, -whip, time);

  #declare pose_array[i_right_arm_swing] = osc(-60, 20, freq, 0.5, time);
  #declare pose_array[i_right_arm_tilt] = 10;
  #declare pose_array[i_right_arm_twist] = 5;
  #declare pose_array[i_right_elbow_bend] = osc(70, 130, -freq, 0.5-whip, time);

  #declare pose_array[i_left_leg_swing] = osc(-40, 60, freq, 0.5, time);
  #declare pose_array[i_left_leg_tilt] = 3;
  #declare pose_array[i_left_knee_bend] = osc(10, 130, -freq, 0.5+whip, time);
  #declare pose_array[i_left_ankle_bend] = osc(-15, 30, freq, 0.5+whip, time);

  #declare pose_array[i_right_leg_swing] = osc(-40, 60, freq, 0.0, time);
  #declare pose_array[i_right_leg_tilt] = 3;
  #declare pose_array[i_right_knee_bend] = osc(10, 130, -freq, whip, time);
  #declare pose_array[i_right_ankle_bend] = osc(-15, 30, freq, whip, time);

  #declare pose_array[i_height_offset] = 1.08 + osc(0, 0.15, 2*freq, 0, time);

#end

// -----------------------------------------------------------------------------

// clean mask while running
 
#macro set_pose_clean( pose_array, time )

  set_pose_running( pose_array, time )  
  #declare pose_array[i_right_arm_swing] = 110;
  #declare pose_array[i_right_arm_tilt] = 15;
  #declare pose_array[i_right_arm_twist] = 55;
  #declare pose_array[i_right_elbow_bend] = 120;

#end

// -----------------------------------------------------------------------------

// look at watch while running
 
#macro set_pose_watch_front( pose_array, time )

  #local freq = 5/3;
  set_pose_running( pose_array, time )
  #declare pose_array[i_head_swing] = osc(40, 35, 2*freq, 0, time);
  #declare pose_array[i_left_arm_swing] = 70;
  #declare pose_array[i_left_arm_tilt] = osc(10, 30, freq, 0, time);;
  #declare pose_array[i_left_arm_twist] = -90;
  #declare pose_array[i_left_elbow_bend] = osc(85, 95, freq, -whip, time);

#end

// -----------------------------------------------------------------------------

// look back while running
 
#macro set_pose_look_back_left( pose_array, time )

  #local freq = 5/3;
  set_pose_running( pose_array, time )
  #declare pose_array[i_upper_back_twist] = osc(-5, 25, freq, 0, time);
  #declare pose_array[i_head_swing] = osc(10, 15, 2*freq, 0, time);
  #declare pose_array[i_head_turn] = osc(80, 110, -freq, 0, time);
  #declare pose_array[i_head_tilt] = osc(5, -5, freq, 0.0, time);

#end

// -----------------------------------------------------------------------------

// look back while running

#macro set_pose_look_back_right( pose_array, time )

  #local freq = 5/3;
  set_pose_running( pose_array, time )
  #declare pose_array[i_upper_back_twist] = osc(5, -25, freq, 0, time);
  #declare pose_array[i_head_swing] = osc(15, 10, 2*freq, 0, time);
  #declare pose_array[i_head_turn] = osc(-80, -110, -freq, 0, time);
  #declare pose_array[i_head_tilt] = osc(-5, 5, freq, 0.0, time);

#end

// --------------------------------------------------------------------------

// flail limbs around

#macro set_pose_flap( pose_array, time )

  #local freq = 5/3;

  #declare pose_array[i_head_turn] = osc(-25, 25, freq, 0, time);
  #declare pose_array[i_head_swing] = osc(10, 5, 2*freq, 0, time);
  #declare pose_array[i_head_tilt] = osc(2, -2, freq, whip, time);

  #declare pose_array[i_upper_back_bend] = osc(5, 10, 2*freq, 0, time);
  #declare pose_array[i_upper_back_twist] = osc(25, -25, freq, 0, time);
  #declare pose_array[i_upper_back_tilt] = osc(-2, 2, freq, whip, time);

  #declare pose_array[i_lower_back_bend] = osc(-5, 0, 2*freq, 0, time);
  #declare pose_array[i_lower_back_twist] = osc(-5, 5, freq, 0, time);
  #declare pose_array[i_lower_back_tilt] = osc(-25, 25, freq, whip, time);

  #declare pose_array[i_left_arm_swing] = osc(-60, 20, freq, 0.0, time);
  #declare pose_array[i_left_arm_tilt] = 70;
  #declare pose_array[i_left_arm_twist] = 10;
  #declare pose_array[i_left_elbow_bend] = osc(30, 90, -freq, -whip, time);

  #declare pose_array[i_right_arm_swing] = osc(-60, 20, freq, 0.5, time);
  #declare pose_array[i_right_arm_tilt] = 70;
  #declare pose_array[i_right_arm_twist] = -10;
  #declare pose_array[i_right_elbow_bend] = osc(30, 90, -freq, 0.5-whip, time);

  #declare pose_array[i_left_leg_swing] = osc(-40, 60, freq, 0.5, time);
  #declare pose_array[i_left_leg_tilt] = 40;
  #declare pose_array[i_left_knee_bend] = osc(10, 130, -freq, 0.5+whip, time);
  #declare pose_array[i_left_ankle_bend] = osc(-15, 30, freq, 0.5+whip, time);

  #declare pose_array[i_right_leg_swing] = osc(-40, 60, freq, 0.0, time);
  #declare pose_array[i_right_leg_tilt] = 40;
  #declare pose_array[i_right_knee_bend] = osc(10, 130, -freq, whip, time);
  #declare pose_array[i_right_ankle_bend] = osc(-15, 30, freq, whip, time);

  #declare pose_array[i_height_offset] = 1.08 + osc(0, 0.15, 2*freq, 0, time);

#end

// -----------------------------------------------------------------------------
 
// run left quickly

#macro set_pose_dart_left( pose_array, time )

  #local freq = 5/3;
  set_pose_running( pose_array, time )

  #declare pose_array[i_head_tilt] = 15;
  #declare pose_array[i_upper_back_tilt] = -15;
  #declare pose_array[i_lower_back_tilt] = osc(25, 15, freq, whip, time);

  #declare pose_array[i_left_arm_swing] = osc(-60, 40, freq, 0.0, time);
  #declare pose_array[i_left_arm_tilt] = 30;
  #declare pose_array[i_left_arm_twist] = 5;
  #declare pose_array[i_left_elbow_bend] = osc(50, 120, -freq, -whip, time);

  #declare pose_array[i_right_arm_swing] = osc(-5, 5, freq, 0.5, time);
  #declare pose_array[i_right_arm_tilt] = 70;
  #declare pose_array[i_right_arm_twist] = -5;
  #declare pose_array[i_right_elbow_bend] = osc(20, 40, -freq, 0.5-whip, time);

  #declare pose_array[i_left_leg_swing] = osc(-50, 60, freq, 0.5, time);
  #declare pose_array[i_left_leg_tilt] = 10;
  #declare pose_array[i_left_knee_bend] = osc(70, 140, -freq, 0.5+whip, time);
  #declare pose_array[i_left_ankle_bend] = osc(-50, 10, freq, 0.5+whip, time);

  #declare pose_array[i_right_leg_swing] = osc(-40, 40, freq, 0.0, time);
  #declare pose_array[i_right_leg_tilt] = 8;
  #declare pose_array[i_right_knee_bend] = osc(10, 130, -freq, whip, time);
  #declare pose_array[i_right_ankle_bend] = osc(-10, 20, freq, whip, time);

  #declare pose_array[i_height_offset] = 1.0 + osc(0,0.2, 2*freq, 0, time);

#end

// ------------------------------------------------------------------------------

// Running backwards

#macro set_pose_running_backwards( pose_array, time )

  #local freq = 5/3;

  #declare pose_array[i_head_turn] = osc(10, -10, -freq, 0, time);;
  #declare pose_array[i_head_swing] = osc(1, 20, 2*freq, 0, time);;
  #declare pose_array[i_head_tilt] = 0;

  #declare pose_array[i_upper_back_bend] = osc(-5, -20, 2*freq, 0, time);
  #declare pose_array[i_upper_back_twist] = osc(10, -10, freq, 0, time);
  #declare pose_array[i_upper_back_tilt] = 0;
  
  #declare pose_array[i_lower_back_bend] = osc(20, 0, 2*freq, 0, time);
  #declare pose_array[i_lower_back_twist] = osc(-8, 8, freq, 0, time);
  #declare pose_array[i_lower_back_tilt] = osc(-10, 10, freq, whip, time);;

  #declare pose_array[i_left_arm_swing] = osc(60, 140, -freq, 0.5, time);
  #declare pose_array[i_left_arm_tilt] = 50;
  #declare pose_array[i_left_arm_twist] = -5;
  #declare pose_array[i_left_elbow_bend] = osc(10, 30, -freq, 0.5-whip, time);

  #declare pose_array[i_right_arm_swing] = osc(60, 140, -freq, 0.0, time);
  #declare pose_array[i_right_arm_tilt] = 50;
  #declare pose_array[i_right_arm_twist] = 5;
  #declare pose_array[i_right_elbow_bend] = osc(10, 30, -freq, -whip, time);

  #declare pose_array[i_left_leg_swing] = osc(70, -15, freq, 0.5, time);
  #declare pose_array[i_left_leg_tilt] = 10;
  #declare pose_array[i_left_knee_bend] = osc(10, 110, freq, 0.5+whip, time);
  #declare pose_array[i_left_ankle_bend] = osc(-10, -50, freq, 0.5+whip, time);

  #declare pose_array[i_right_leg_swing] = osc(70, -15, freq, 0.0, time);
  #declare pose_array[i_right_leg_tilt] = 10;
  #declare pose_array[i_right_knee_bend] = osc(10, 110, freq, whip, time);
  #declare pose_array[i_right_ankle_bend] = osc(-10, -50, freq, whip, time);

  #declare pose_array[i_height_offset] = 1.11 + osc(0,0.15, 2*freq, 0, time);

#end

// -----------------------------------------------------------------------

// carry heavy object on back

#macro set_pose_carrying( pose_array, time )

  #local freq = 5/3;

  #declare pose_array[i_head_turn] = osc(-5, 5, freq, 0, time);
  #declare pose_array[i_head_swing] = osc(60, 65, 2*freq, 0, time);
  #declare pose_array[i_head_tilt] = osc(-5, 5, freq, whip, time);;

  #declare pose_array[i_upper_back_bend] = osc(50, 55, 2*freq, 0, time);
  #declare pose_array[i_upper_back_twist] = 0;
  #declare pose_array[i_upper_back_tilt] = 0;

  #declare pose_array[i_lower_back_bend] = osc(5, 6, 2*freq, 0, time);
  #declare pose_array[i_lower_back_twist] = osc(-5, 5, freq, 0, time);
  #declare pose_array[i_lower_back_tilt] = osc(5, -5, freq, whip, time);

  #declare pose_array[i_left_arm_swing] = osc(130, 140, 2*freq, 0.0, time);
  #declare pose_array[i_left_arm_tilt] = 10;
  #declare pose_array[i_left_arm_twist] = -5;
  #declare pose_array[i_left_elbow_bend] = osc(60, 61, freq, -whip, time);

  #declare pose_array[i_right_arm_swing] = osc(130, 140, 2*freq, 0.0, time);
  #declare pose_array[i_right_arm_tilt] = 10;
  #declare pose_array[i_right_arm_twist] = 5;
  #declare pose_array[i_right_elbow_bend] = osc(60, 61, freq, 0.5-whip, time);

  #declare pose_array[i_left_leg_swing] = osc(55, 70, freq, 0.5, time);
  #declare pose_array[i_left_leg_tilt] = 3;
  #declare pose_array[i_left_knee_bend] = osc(40, 150, -freq, 0.5+whip, time);
  #declare pose_array[i_left_ankle_bend] = osc(-40, -10, freq, 0.5+whip, time);

  #declare pose_array[i_right_leg_swing] = osc(55, 70, freq, 0.0, time);
  #declare pose_array[i_right_leg_tilt] = 3;
  #declare pose_array[i_right_knee_bend] = osc(40, 150, -freq, whip, time);
  #declare pose_array[i_right_ankle_bend] = osc(-40, -10, freq, whip, time);

  #declare pose_array[i_height_offset] = 0.9 + osc(0, 0.1, 2*freq, 0.5, time);

#end

// ----------------------------------------------------------------------------

// run in a hand-stand

#macro set_pose_hands( pose_array, time )

  #local freq = 5/3;

  #declare pose_array[i_head_turn] = osc(-15, 15, freq, 0, time);
  #declare pose_array[i_head_swing] = osc(-40, -30, 2*freq, 0, time);
  #declare pose_array[i_head_tilt] = osc(2, -2, freq, whip, time);

  #declare pose_array[i_upper_back_bend] = osc(160, 170, 2*freq, 0, time);
  #declare pose_array[i_upper_back_twist] = osc(15, -15, freq, 0, time);
  #declare pose_array[i_upper_back_tilt] = osc(-10, 10, freq, whip, time);

  #declare pose_array[i_lower_back_bend] = osc(160, 170, 2*freq, 0, time);
  #declare pose_array[i_lower_back_twist] = osc(-5, 5, freq, 0, time);
  #declare pose_array[i_lower_back_tilt] = osc(-10, 10, freq, whip, time);

  #declare pose_array[i_left_arm_swing] = osc(110, 170, -freq, 0.0, time);
  #declare pose_array[i_left_arm_tilt] = 8;
  #declare pose_array[i_left_arm_twist] = -5;
  #declare pose_array[i_left_elbow_bend] = osc(10, 110, -freq, -whip, time);

  #declare pose_array[i_right_arm_swing] = osc(110, 170, -freq, 0.5, time);
  #declare pose_array[i_right_arm_tilt] = 8;
  #declare pose_array[i_right_arm_twist] = 5;
  #declare pose_array[i_right_elbow_bend] = osc(10, 110, -freq, 0.5-whip, time);

  #declare pose_array[i_left_leg_swing] = osc(-7, -17, -2*freq, whip, time);
  #declare pose_array[i_left_leg_tilt] = 5;
  #declare pose_array[i_left_knee_bend] = osc(98, 110, -2*freq, whip, time);
  #declare pose_array[i_left_ankle_bend] = osc(2, 62, -2*freq,  whip, time);

  #declare pose_array[i_right_leg_swing] = osc(-5, -15, -2*freq, whip, time);
  #declare pose_array[i_right_leg_tilt] = 5;
  #declare pose_array[i_right_knee_bend] = osc(100, 112, -2*freq, whip, time);
  #declare pose_array[i_right_ankle_bend] = osc(0, 60, -2*freq, whip, time);

  #declare pose_array[i_height_offset] = 1.15 + osc(0, 0.10, 2*freq, 0, time);

#end

