
// =================================================
/*

  POV-Ray 3.5 Source

  Created by Richard Webster irtc_mail@yahoo.co.uk

  for the Internet Ray Tracing Competition

  April 2003 Animation Round www.irtc.org

*/
// =================================================


#include "functions.inc"

#declare running_speed = 5.0;
#declare real_time = clock * (final_frame-initial_frame) * 0.04;

global_settings{max_trace_level 5}
global_settings{ambient_light rgb 1}
light_source{<3e5,-3e5,0.5e6> color rgb<1,1,1> }
light_source{<-3e5,3e5,-0.5e6> color rgb 0.5 shadowless}

sky_sphere{pigment{gradient z
                   color_map{[0 color rgb <0.8,0.9,1>]
                               [0.25 color rgb<0.2,0.3,1>]
                               [1 color rgb <0.0,0.1,1>]}
                   translate -1
                  }
}


// ground

#declare P_veg = 
pigment{granite color_map{[0 color rgb<0.6,0.6,0.4>]
                          [1 color rgb<0.5,0.5,0.3>]}
scale 0.04};

#declare P_sand = 
pigment{granite color_map{[0 color rgb<0.6,0.6,0.3>]
                          [0.5 color rgb<0.6,0.6,0.3>]
                          [0.8 color rgb<0.4,0.4,0.1>]
                          [1 color rgb<0.4,0.4,0.1>]}
scale 0.04};

#declare P_rock = 
pigment{granite color_map{[0 color rgb<0.7,0.7,0.4>]
                          [0.2 color rgb<0.7,0.7,0.4>]
                          [0.5 color rgb<0.5,0.5,0.3>]
                          [1 color rgb<0.5,0.5,0.3>]}
scale 0.04};

// ---------------------------------------------------

#declare T_road = texture{
 pigment{bozo scale 0.2 color_map{[0 color rgb <0.4,0.4,0.3>][1 color rgb<0.5,0.5,0.3>]}}
 finish{ambient 0.5 diffuse 0.8 phong 1 phong_size 10}
 normal{crackle 1 scale 0.01}
};

#declare T_dust = texture{
 pigment{color rgb <0.5,0.5,0.3>}
 finish{ambient 0.5 diffuse 0.8 phong 0 phong_size 10}
  normal{granite 0.1 scale 0.2}
};

#declare T_desert = texture{
  pigment{granite scale 1 pigment_map{
       [0.0 P_sand][0.3 P_sand][0.5 P_rock][1 P_rock]} scale 5}
    finish{ambient 0.5 diffuse 0.8}
};


#declare T_ground =
      texture{planar scale 3 turbulence 0.3
         texture_map{[0 T_desert]
                     [0.15 T_dust]
                     [0.16 T_dust]
                     [0.3 T_road]
                     [1 T_road]}
       };
 
// ground

plane{z, 0 texture{T_ground}hollow no_shadow }

// Distant hills

#declare P_hills_lo =
  pigment{bozo scale 5
          color_map{[0 color rgb <0.4,0.4,0.2>][1 color rgb<0.7,0.7,0.3>]}
};

#declare P_hills_hi =
  pigment{bozo scale 5
          color_map{[0 color rgb <0.7,0.7,0.65>][1 color rgb<0.7,0.7,0.8>]}
};

#declare T_hills = texture{
  pigment{gradient z scale <1,1,100>
          pigment_map{[0.0 P_hills_lo][0.99 P_hills_hi][1 P_hills_hi]}}
  finish{ambient 0.2 diffuse 0.8}
};

height_field{png "hills.png" smooth
     translate<-0.5,0,-0.5>rotate<90,0,0>
     texture{T_hills scale <1/2000,1/2000,1/100>}     
     scale<2000,2000,100>
     translate<0,0,-1>
}


// rocks

#declare T_rock = texture{
  pigment{granite scale 6
          pigment_map{[0 P_rock][0.1 P_rock][0.2 P_sand][1 P_sand]}}
  finish{ambient 0.5 diffuse 0.7}
};

#declare rock = 
isosurface{
 function{ (sqrt(x*x+y*y+z*z)-1)
           - 0.9*f_noise3d(1*x, 1*y, 1*z)
           + 0.05*f_noise3d(25*x, 25*y, 25*z)
          }
 contained_by{box{<-1.9,-1.9,-1.9>,<1.9,1.9,1.9>}}
  max_gradient 2.5
  accuracy 0.01
};


#declare R1 = seed(1);
#declare R2 = seed(1);

#declare ni=700;
#declare y_range = 100;
#declare i=0;
#while(i<ni)
   #declare tx = i/(ni-1);
   #declare rx = -300 + tx*700;
   #declare ry = (6 + rand(R1)*y_range);
   #if (rand(R2)<0.5)
     #declare ry = -ry;
   #end
   #declare rz = 0.2+0.3*rand(R1);

   #declare p = <rx,ry,rz>;

   object{rock rotate<360*rand(R2),360*rand(R2),360*rand(R2)>
          scale 0.5 texture{T_rock}translate p }

  #declare i=i+1;
#end


#declare motion = function(m){0.5*(1+cos(pi*(m+1)))};

#macro transition(t_start, t_stop, t_now)

   #if(t_now < t_start)
    #local tr = 0;
   #else
     #if((t_now >= t_start) & (t_now < t_stop))
      #local tr = ((t_now - t_start)/(t_stop - t_start));
     #else
      #local tr = 1;
     #end
   #end
 (tr)
#end
