
// =================================================
/*

  POV-Ray 3.5 Source

  Created by Richard Webster irtc_mail@yahoo.co.uk

  for the Internet Ray Tracing Competition

  April 2003 Animation Round www.irtc.org

*/
// =================================================


#include "scene.inc"
#include "figure.inc"


// lead runner
#declare p_fig = <0,0,0> + x * (50 + real_time*running_speed);

#declare v_dir = <1,0,0>;
#declare v_side = <0,1,0>;
#declare v_up = <0,0,1>;

// -------------------------------------------------------

#declare R1 = seed(1);
#declare ni = 5;
#declare i=0;
#while(i<ni)


  #if ( i=0 )
    #declare action_delay = 0;
  #else
    #declare action_delay = 0.3 + 0.25*i;
  #end


  #declare t_move = transition(0, 4,  real_time - action_delay);


  #declare ti=i/(ni-1);
  #declare fig_phase = ti;
  #declare fx = p_fig.x - 4*i/3;
  #declare fy = p_fig.y + 0.1*sin((0.1*real_time-fig_phase)*2*pi)
                -1.2 + 10 * motion(pow(t_move,1.5));
  #declare fz = p_fig.z;

    #if(i=0)
      set_pose_look_back_right( pose1, real_time+fig_phase )
      set_pose_dart_left( pose2, real_time+fig_phase )
      Array_Interpolate( pow(t_move,0.4), pose1, pose2, pose )
    #else
      set_pose_flap( pose1, real_time+fig_phase )
      set_pose_dart_left( pose2, real_time+fig_phase )
      Array_Interpolate( pow(t_move,0.4), pose1, pose2, pose )
      
    #end

  object{make_figure( <fx,fy,fz>, v_dir, v_side, v_up, pose ) }

  #declare i=i+1;
#end


// --------------------------------------------------------------------

// Camera

#declare film_size = 0.035;
#declare focal_length = 0.05;
#declare aspect_ratio = image_height / image_width;


camera{perspective
      location <0,0,0>
      direction <0,focal_length,0>
      right <film_size,0,0>
      up <0,0,film_size*aspect_ratio>
      rotate<-6,0,90>
      translate<p_fig.x+5,0,1.5>    
}


