
// =================================================
/*

  POV-Ray 3.5 Source

  Created by Richard Webster irtc_mail@yahoo.co.uk

  for the Internet Ray Tracing Competition

  April 2003 Animation Round www.irtc.org

*/
// =================================================


#include "scene.inc"
#include "figure.inc"


// lead runner
#declare p_fig = <0,1.2,0> + x * (-70 + real_time*running_speed);

#declare v_dir = <1,0,0>;
#declare v_side = <0,1,0>;
#declare v_up = <0,0,1>;

// -------------------------------------------------------

#declare pan_start = 6;
#declare pan_hold = 9;
#declare pan_stop = 10;

#declare R1 = seed(1);
#declare ni = 5;
#declare i=0;
#while(i<ni)
  #declare ti=i/(ni-1);
  #declare fig_phase = ti;
  #declare fx = p_fig.x - 4*i/3;
  #declare fy = p_fig.y + 0.1*sin((0.1*real_time-fig_phase)*2*pi);
  #declare fz = p_fig.z;
  

  #if( real_time < pan_stop)

     set_pose_running( pose1, real_time+fig_phase )
     set_pose_clean( pose2, real_time+fig_phase ) 
     set_pose_watch_front( pose3, real_time+fig_phase )
     #if ( i=0 )
        set_pose_look_back_right( pose4, real_time+fig_phase ) 
     #else
        set_pose_watch_front( pose4, real_time+fig_phase )
     #end

     #if ( i=0 )
       #declare action_delay = 0;
     #else
       #declare action_delay = 1.5 + 1*i;
     #end

     #declare t_pose = transition( 0, 6, real_time - action_delay);
     Array_Interpolate4( t_pose, pose1, pose2, pose3, pose4, pose )

  #else

    #if ( i=0 )

      // look at camera
      #declare t_pose = transition(pan_stop, pan_stop+2, real_time);
      #declare look_hold = 0.6;
      #declare look_start = 0.5;
      #declare look_stop = 0.8;
      #if(t_pose<look_start)
         #declare t_pose = motion(t_pose/look_start) * look_hold;
      #end
      #if((t_pose>=look_start)&(t_pose<look_stop))
         #declare t_pose = look_hold;
      #end
      #if(t_pose>=look_stop)
         #declare t_pose = look_hold + (1-look_hold)*motion((t_pose-look_stop)/(1-look_stop));
      #end

      set_pose_look_back_right( pose1, real_time+fig_phase )
      set_pose_running( pose2, real_time+fig_phase )
      Array_Interpolate( t_pose, pose1, pose2,  pose )

    #else

      set_pose_watch_front( pose, real_time+fig_phase )

    #end

  #end


  object{make_figure( <fx,fy+0.1*sin((0.3*real_time-fig_phase)*2*pi),fz>,
                      v_dir, v_side, v_up, pose ) }

  #declare i=i+1;
#end


// --------------------------------------------------------------------

// Camera

#declare film_size = 0.035;
#declare focal_length = 0.05;
#declare aspect_ratio = image_height / image_width;

#if(real_time < pan_stop)
  #declare tp = transition( pan_start, pan_hold, real_time );
#else
  #declare tp = 0;
#end

camera{perspective
      location <0,0,0>
      direction <0,focal_length,0>
      right <film_size,0,0>
      up <0,0,film_size*aspect_ratio>
      rotate<-4,0,45+15*motion(tp)>
      translate<p_fig.x+2.5,-1.2,1.6>    
}


