/* DAM.INC - Programmed by Maarten Hofman */
/* 070203: Started programming */
/* 270203: Added the wheel to control the flow */
/* 280203: Made amount of water out of outlet changeable */
/* 070303: Tried to make it seem like the water actually rises */

#declare water = texture {
  pigment {
    rgbt <0,0.5,1,0.8>      
  }                
  normal {
    bumps 0.5
    scale 4
  }      
  finish {
    reflection 0.2
  }
}

difference {
  box {
    <812,0,795>,
    <880,waterlevel+2,789>
  }                      
  box {
    <845,waterlevel+1.9,796>,
    <830,waterlevel+0.1,788>     
  }
  box {
    <847,waterlevel+1.9,796>,
    <862,waterlevel+0.1,788>
  }   
  box {
    <845,waterlevel+1.9,788>,
    <830,waterlevel-5,794>
  }      
  cylinder {
    <845,waterlevel-5,788>,
    <830,waterlevel-5,788>,6
  }
  cylinder {
    <847,waterlevel-5,788>,
    <862,waterlevel-5,788>,6
  }
  box {
    <847,waterlevel+1.9,788>,
    <862,waterlevel-5,794>
  }         
  box {
    <811,0,788>,
    <881,waterlevel+1.9,790>
  }
  texture {
    T_Stone8
  }
}

#declare logo = box {
  <0,0,0>,
  <1,1,-0.01>
  pigment {
    image_map {
      png "logo.png"
    }
  }
}

object {
  logo                         
  scale <15,10,1>
  translate <849,waterlevel-21,790>
}

cylinder {
  <851,waterlevel-24,783>,
  <851,waterlevel-24,790>,2
  texture {
    T_Brass_1B
  }
}

/* Stand for the wheel */
box {
  <850.8,waterlevel+2,795>,
  <851.2,waterlevel+4,794.6>
  texture {
    T_Stone8
  }
}

#declare wheel = union {
  torus { 1,0.1 rotate <90,0,0> }
  cylinder { <0,0,-0.2>,<0,0,0.2>,0.2 }
  cylinder { <0,1,0>,<0,-1,0>,0.1 }
  cylinder { <1,0,0>,<-1,0,0>,0.1 }
  texture {
    T_Copper_1C
  }                                   
}

object {
  wheel                               
  rotate <0,0,-clock*180>
  translate <851,waterlevel+3.8,794.4>
}
  
difference {
  torus {
    2,1.6*watersize
    rotate <0,0,90>
  }
  box {
    <-2,-6,0>,
    <2,6,6>
  }  
  texture {
    bozo
    texture_map {
      [0.0 water]
      [1.0 pigment { White } ]
    }                         
    rotate <-clock*90,0,0>
  }
  translate <851.3,waterlevel-27.6+1.6*watersize,783>
}

/* Pool of water part */
#if (clock>2)
#declare morewater = (clock-2)/3;
#if (morewater>1)
#declare morewater = 1;
#end
sphere {
  <0,0,0>,2
  scale <morewater*2,1,morewater*4>
  texture {
    bozo
    texture_map {
      [0.0 water]
      [1.0 pigment { White } ]
    }
    rotate <-clock*90,0,0>      
  }
  translate <851,waterlevel-29+morewater,781-morewater*2>
}
#end

cylinder {
  <829,waterlevel+3,788>
  <829,0,788>,1
  texture {
    T_Stone8
  }
}
cylinder {
  <846,waterlevel+3,788>
  <846,0,788>,1
  texture {
    T_Stone8
  }
}
cylinder {
  <863,waterlevel+3,788>
  <863,0,788>,1
  texture {
    T_Stone8
  }
}

box {
  <775,waterlevel,955>,
  <880,waterlevel+0.1,794>  
  texture {
    water
  }
}
