/* ELEC.POV - Programmed by Maarten Hofman */
/* 040203: Started programming */
/* 050203: Added proper landscape */
/* 060203: Worked on the lower part of the dam */
/* 070203: View inside the building at the dam */
/* 110203: Added first pylon */
/* 120203: Added the wires to the pylon */
/* 130203: Added the next pylon */
/* 140203: Added another pylon */
/* 170203: Added platform for new substation */
/* 190203: Changed viewpoint for wooden pylons */
/* 200203: Changed viewpoint */
/* 210203: Added the final destination: the house */
/* 240203: Started on the inside of the house */
/* 270203: Changed viewpoint again */
/* 280203: 2: View moves to the outlet */
/* 030303: View moves to door */
/* 040303: Added the spark */
/* 050303: Moved through the window */
/* 060303: Moving through the house */
/* 070303: Renamed and edited for details */
/* 100303: Added the third type of pylon, including continuation (might not be 
           all the way visible */
/* 120303: Added the road signs and other road stuff */
/* 130303: Added another pole to make sure things seem continuous */
/* 160303: Made the movement to the top of the mountain quadratic */
/* 180303: New compression, made animation longer */
/* 190303: Added the bear */

#include "colors.inc"
#include "skies.inc"
#include "stones.inc"
#include "functions.inc"
#include "metals.inc"
#include "woods.inc"
#include "glass.inc"
#include "vitara.inc"
#include "bear.inc"

#declare waterlevel = 190;  

#if (clock<2)
#declare watersize = 0.01;
#else
#if (clock<5)
#declare watersize = (clock-2)/3;
#else
#declare watersize = 1;
#end
#end                   

#if (clock<6)
#declare tl = 0;
#else
#if (clock<7)
#declare tl = clock-6;
#else
#declare tl = 1;
#end
#end

#if (clock<7)
#declare td = 0;
#else
#if (clock<8)
#declare td = (clock-7)*85;
#else
#declare td = 85;
#end
#end

#if (clock<8)
#declare tl2 = 0;
#else
#if (clock<9)
#declare tl2 = clock-8;
#else
#declare tl2 = 1;
#end
#end

#if (clock<32)  
#declare hl = 0; 
#else
#if (clock<33)
#declare hl = clock-32;
#else
#declare hl = 1;
#end
#end

#if (clock<34)  
#declare hd = 0; 
#else
#if (clock<35)
#declare hd = (clock-34)*85;
#else
#declare hd = 85;
#end
#end

#if (clock<36)  
#declare hl2 = 0; 
#else
#if (clock<37)
#declare hl2 = 1;
#else           
#declare hl2 = 0;
#end
#end
                  
#include "dam.inc"
#include "turbine.inc"
#include "substation.inc"
#include "pylons.inc"
#include "house.inc"
#include "road.inc"

light_source { <0,1000,0> color White }
light_source { <1,1000,1> color White }

/* Silly immitation sun, just in case a camera view slides by (hopefully not) */
cylinder {
  <0,1001,0>,
  <0,1002,0>,100
  pigment {
    Yellow
  }
  finish {
    ambient 1.0
    diffuse 0.8
  }
}
  
camera {     
  /* First, the wheel */
#if (clock<1)
#declare watersize=0.01;
  location <850,waterlevel+3,785>
  look_at <851,waterlevel+3.8,794.4>
#end               
/* Then go down to the pipe */
#if ((clock>=1) & (clock<2))
#declare aid = clock-1;
  location <850,waterlevel+3-aid*10,785-aid*15>
  look_at <851,waterlevel+3.8-aid*27.8,794.4-11.4*aid>
#end                          
/* Which gives water */
#if ((clock>=2) & (clock<5)) 
  location <850,waterlevel-7,770>
  look_at <851,waterlevel-24,783>
#end                       
/* Go up to the door */ 
#if ((clock>=5) & (clock<6))
#declare aid = clock-5;                 
  location <850-aid*30,waterlevel-7+10*aid,770+21*aid>
  look_at <851-39*aid,waterlevel-24+28*aid,783+8*aid>
#end                   
/* Lights go on and door opens */
#if ((clock>=6) & (clock<9))
  location <820,waterlevel+3,791>
  look_at <812,waterlevel+4,791>
#end                             
/* Go into turbine room */
#if ((clock>=9) & (clock<10))                            
#declare aid = clock-9;
  location <820-20*aid,waterlevel+3+4.5*aid,791>
  look_at <812-7*aid,waterlevel+4+aid*2,791-15*aid>
#end                      
/* Watch turbine */                         
#if ((clock>=10) & (clock<11))
#declare aid = clock-10;
  location <800,waterlevel+7.5,791-20.5*aid>
  look_at <805,waterlevel+6,776>
#end                        
#if ((clock>=11) & (clock<12))
/* Watch turbine some more */
  location <800,waterlevel+7.5,770.5>
  look_at <805,waterlevel+6,776>
#end
/* Follow flash */           
#if ((clock>=12) & (clock<13))
#declare aid = clock-12;
  location <800,waterlevel+7.5,770.5>
  look_at <805+6*aid,waterlevel+6-aid*2,776-aid*9>
#end              
/* Move out of the turbine building */
#if ((clock>=13) & (clock<14))
#declare aid = clock-13;
  location <800+aid*20,waterlevel+7.5,770.5>
  look_at <811+aid*2,ssa+12-aid,767+aid>
#end                         
#if ((clock>=14) & (clock<15))
#declare aid = clock-14;
  location <820+aid*5,ssa+15.5-15.5*aid,770.5-30.5*aid>
  look_at <813+aid*3,ssa+11-7*aid,768>
#end
#if ((clock>=15) & (clock<16))
  location <825,ssa,740>
  look_at <816,ssa+4,768>
#end                        
#if ((clock>=16) & (clock<17))        
#declare aid = clock-16;
  location <825-100*aid,182-20*aid,740-aid*220>
  look_at <816-49*aid,186-aid*64,768-106*aid>
#end
#if ((clock>=17) & (clock<18))
  location <725,162,520>
  look_at <767,122,662>
#end
#if ((clock>=18) & (clock<19))        
#declare aid = clock-18;
  location <725-115*aid,162-62*aid,520-216*aid>
  look_at <767-150*aid,122-8*aid,662-329*aid>
#end
#if ((clock>=19) & (clock<22))
  location <610,100,304>
  look_at <617,114,333>
#end
#if ((clock>=22) & (clock<23))
#declare aid = clock-22;
#declare qaid = 1-((1-aid)*(1-aid));
  location <610-25*aid,100+15*qaid,304+36*aid>
  look_at <617-11*aid,114-10*aid,333+4*aid>  
#end
#if ((clock>=23) & (clock<24))
#declare aid = clock-23;
  location <585,115,340>
  look_at <606-21*aid,104+18*aid,337+14*aid>  
#end
#if ((clock>=24) & (clock<25))
#declare aid = clock-24;
  location <585,115,340>
  look_at <585-20*aid,122-50*aid,351+4*aid>  
#end
#if ((clock>=25) & (clock<26))
#declare aid = clock-25;
  location <585-135*aid,115-85*aid,340+50*aid>
  look_at <565-100*aid,72-41*aid,355+50*aid>  
#end
#if ((clock>=26) & (clock<31))
  location <450,30,390>
  look_at <465,31,405>
#end
#if ((clock>=31) & (clock<32))
#declare aid=clock-31;
  location <450+12*aid,30-8*aid,390+10*aid>
  look_at <465-5*aid,31-11.5*aid,405+4*aid>
#end
#if ((clock>=32) & (clock<33))
  location <462,22,400>
  look_at <460,19.5,409>
#end                  
/* Move inside */
#if ((clock>=33) & (clock<34))
#declare aid = clock-33;
  location <462,22,400+aid*10>
  look_at <460,19.5+1.5*aid,409>
#end                    
/* Open breaker box */
#if ((clock>=34) & (clock<35))
  location <462,22,410>
  look_at <460,21,409>
#end
/* Move to television */
#if ((clock>=35) & (clock<36))
#declare aid = clock-35;
  location <462+aid*3,22,410+7*aid>
  look_at <460+aid,21-aid*0.5,409+5*aid>
#end
/* Watch television */

#if (clock>=36)
  location <465,22,417>
  look_at <461,20.5,414>
#end

  /* Look at the dam */
//  location <850,200,750>
//  look_at <700,100,1000>

  /* View from above */
//  location <500,1050,500>
//  look_at <500,0,500>

  /* Look inside the building */
//  location <799,waterlevel+8,767>
//  look_at <811,waterlevel+7,770>

  /* Look at the substation */
//  location <825,waterlevel,760>
//  look_at <815,waterlevel-2,770>

  /* Look at the pylon */
//  location <810,180,750>
//  look_at <818,195,755>

  /* Look at the second pylon */
//  location <750,140,600>
//  look_at <787.5,162,710>

  /* Look at the third pylon */
//  location <700,160,500>
//  look_at <770,108,660>

  /* Look at the fourth pylon */
//  location <650,140,450>
//  look_at <670,150,483>

  /* Look at the sun */
//  location <650,140,450>
//  look_at <0,1000,0>    

  /* Look at the fifth pylon */
//  location <600,120,300>
//  look_at <620,110,330>

  /* Look at the wooden pylon */
//  location <450,40,350>
//  look_at <480,30,405>
  
  /* Look at the house */
//  location <450,30,390>
//  look_at <460,29,407>

  /* Look in the house */
//  location <467,23,422>
//  look_at <460,19,408>

  /* Look at the new type of pylon */
//  location <700,190,280>
//  look_at <725,180,308>

  /* Look at lowest part */
//  location <450,20,420>
//  look_at <450,0,500>

  /* Look at new pole */
//  location <400,50,350> 
//  look_at <415,25,405>
}

sky_sphere {
  S_Cloud2
}

plane {
  y,0
  texture {
    T_Stone4
  }
}

height_field {
  png "heightfield.png"
  smooth    
  scale <1000,300,1000>
  translate <0,-15,0>
  texture {
    T_Grnt25
  }
}

height_field {
  png "road.png"
  smooth    
  scale <1000,300,1000>
  translate <0,-14,0>
  texture {
    bozo
    texture_map {
      [0.3 pigment { rgbt <1,1,1,1> } ]
      [1.0 T_Stone10]
    }
  }
}

#declare flash = union {
  cylinder {
    <0.1,0,0.1>,
    <-0.1,0,-0.1>,0.05
  }
  cone {
    <0.1,0,0.1>,0.05,
    <-0.3,0,0.1>,0
  }
  cone {
    <-0.1,0,-0.1>,0.05,
    <0.3,0,-0.1>,0
  }
  pigment {
    LightBlue
  }
  finish {
    ambient 0.9
    diffuse 0.7
  }
}

#if ((clock>12) & (clock<13))
object {
  flash
  translate <806.5+aid*4.5,waterlevel+3+aid,772-aid*5>
}
#end

#if ((clock>13) & (clock<14))
object {
  flash
  translate <812+aid*1.25,ssa+12-aid,767+aid>
}
#end

#if ((clock>14) & (clock<15))
object {
  flash
  translate <813.25+aid*2.5,ssa+11-aid*7,768+aid*0.25>
}
#end

#if ((clock>15) & (clock<16))
#declare aid = clock-15;
object {
  flash    
  scale 2
  translate <814.75-5.75*aid,185.5+6.5*aid,767.25-9.75*aid>
}
#end

#if ((clock>16) & (clock<17))
object {
  flash         
  scale 2
  translate <808.5-42*aid,192-70*aid,757.5-95*aid>
}                                      
#end

#if ((clock>17) & (clock<18))
#declare aid = clock-17;
object {
  flash  
  scale 2
  translate <766.5-50*aid,122+46*aid,662.5-127*aid>
}                                      
#end

#if ((clock>18) & (clock<19))
object {
  flash  
  scale 2
  translate <716.5-50*aid,168-14*aid,535.5-50*aid>
}                                      
#end

#if ((clock>19) & (clock<20))
#declare aid = clock-19;
object {
  flash  
  scale 2
  translate <666.5-50*aid,154-40*aid,485.5-153*aid>
}                                      
#end

#if ((clock>20) & (clock<21))
#declare aid = clock-20;
object {
  flash  
  scale 2
  translate <616.5-4.5*aid,114-5*aid,332.5-2.2*aid>
}                                      
#end

#if ((clock>21) & (clock<22))
#declare aid = clock-21;
object {
  flash  
  scale 2
  translate <612-3*aid,109-3.9*aid,330.3+1.7*aid>
}                                      
#end

#if ((clock>22) & (clock<23))
object {
  flash  
  translate <609-3*aid,101+3.3*aid,333.3+3.7*aid>
}                                      
#end

#if ((clock>23) & (clock<24))
object {
  flash  
  translate <606-21*aid,104.3+18*aid,337+14*aid>
}                                      
#end

#if ((clock>24) & (clock<25))
object {
  flash  
  translate <585-20*aid,122.3-50*aid,351+5*aid>
}                                      
#end

#if ((clock>25) & (clock<26))
object {
  flash  
  translate <565-50*aid,72.3-28*aid,356+25*aid>
}                                      
#end

#if ((clock>26) & (clock<27))
#declare aid = clock-26;
object {
  flash  
  translate <515-50*aid,44.3-11*aid,381+15*aid>
}                                      
#end

#if ((clock>27) & (clock<28))
#declare aid = clock-27;
object {
  flash  
  translate <465+0.5*aid,33.3-1.1*aid,406-1*aid>
}                                      
#end

#if ((clock>28) & (clock<29))
#declare aid = clock-28;
object {
  flash  
  translate <465.5-aid*0.5,30.9-4.9*aid,405+2.6*aid>
}                                      
#end

#if ((clock>29) & (clock<29.5))
#declare aid = (clock-29)*2;
object {
  flash  
  translate <465,26-1.5*aid,407.95>
}                                      
#end

#if ((clock>29.5) & (clock<30.5))
#declare aid = clock-29.5;
object {
  flash  
  translate <465-5.05*aid,24.5,407.95>
}                                      
#end

#if ((clock>30.5) & (clock<31))
#declare aid = (clock-30.5)*2;
object {
  flash  
  translate <459.95,24.5,407.95+1.05*aid>
}                                      
#end

#if ((clock>31) & (clock<32))
object {
  flash  
  translate <459.95+0.05*aid,24.5-5*aid,409>
}                                      
#end

#if ((clock>35) & (clock<36))
object {
  flash  
  translate <460.2+0.8*aid,19.85-0.35*aid,413.45+1.55*aid>
}                                      
#end
