/* HOUSE.INC - Programmed by Maarten Hofman */
/* 210203: Started programming */
/* 240203: Fixed the roof and added some lights */
/* 250203: Added light */
/* 260203: Added television */
/* 050303: The door seems a tad too long? */
/* 060303: Added the breaker door and the television display */
/* 130303: Adjusted the roof a little bit */
/* 180303: Updated clock for slightly longer animation */
/* 190303: Added the bear */

#declare housebody = difference {
  box {
    <0,-100,0>,
    <10,10,30>
  }
  box {       
    <0,0,-1>,
    <10,10,31>
    rotate <0,0,40>
    translate <0,6,0>
  }                    
  box {
    <0,0,-1>,
    <10,10,31>
    rotate <0,0,-40>
    translate <5,10,0>
  }
  box {
    <8,0,-1>,
    <11,10,10>
  }           
  box {
    <0.1,0.1,0.1>,
    <7.9,5.9,29.9>
  }
  box { 
    <1.5,2,-1>,
    <2.5,4,1>
  }
  box { 
    <5.5,2,-1>,
    <6.5,4,1>
  }
  box {
    <-1,2,10>,
    <1,4,11>
  }
  box {
    <-1,2,20>,
    <1,4,21>
  }

  pigment {
    gradient y
    color_map {
      [0.8 LightBlue]
      [1 Black]
    }             
    scale 0.5
  }
}

#declare roof = union {
  box {       
    <0,0,-0.2>,
    <6.5,0.2,30.2>
    rotate <0,0,40>
    translate <0,6,0>
    pigment {
      White
    }
  }                    
  box {
    <0,0,-0.2>,
    <7.5,0.2,30.2>
    rotate <0,0,-40>
    translate <5,10,0>
    pigment {
      White
    }
  }
  box {       
    <0.1,0.2,0>,
    <6.4,0.3,30>
    rotate <0,0,40>
    translate <0,6,0>
    pigment {
      brick pigment { Black} pigment { DarkSlateGray }
      scale 0.2
    }                                               
  }                    
  box {
    <0.1,0.2,0>,
    <7.4,0.3,30>
    rotate <0,0,-40>
    translate <5,10,0>
    pigment {
      brick pigment { Black} pigment { DarkSlateGray }
      scale 0.2
    }                                               
  }            
}

#declare windowframe = difference {
  box {
    <-1,1.9,-0.2>,
    <2,4.1,0.2>
  }
  box {
    <0,2,-1>,
    <1,4,1>
  }
  box {
    <-0.2,-1,-1>,
    <1.2,5,-0.1>
  }
  box {
    <-0.9,2,-1>,
    <-0.3,4,-0.1>
  }
  box {
    <1.3,2,-1>,
    <1.9,4,-0.1>
  }
  pigment {
    White
  }
}

#declare meterglass = difference {
  sphere {
    <0,0,0>,0.5
  }
  sphere {
    <0,0,0>,0.4
  }
  texture {
    T_Glass1
  }
  interior {
    I_Glass
  }
}
  
#declare meter = union {
  sphere {
    <0,0,0>,0.2
    texture {
      T_Chrome_1A
    }
  }
  object {
    meterglass
  }
  clipped_by {
    box {
      <0,-1,-1>,
      <-1,1,1>   
    }
  }
}

#declare house = union {
  object {
    housebody
  }
  object {
    roof
  }          
  /* Porch */
  box {
    <10,0,0>,
    <9.8,6,0.2>
    texture {
      T_Chrome_3C
    }
  }
  /* Window */
  box { 
    <1.5,2,0>,
    <2.5,4,0.1>           
    texture {
      T_Glass1
    }
    interior {
      I_Glass
    } 
  }
  object {
    windowframe
    translate <1.5,0,0>
  }
  box { 
    <6.5,2,0>,
    <5.5,4,0.1>           
    texture {
      T_Glass1
    }
    interior {
      I_Glass
    } 
  }
  object {
    windowframe
    translate <5.5,0,0>
  }
  box { <0,2,10>,<0.1,4,11> texture { T_Glass1 } interior { I_Glass } }
  box { <0,2,20>,<0.1,4,21> texture { T_Glass1 } interior { I_Glass } }
  object {
    windowframe
    rotate <0,90,0> translate <0,0,11>
  }
  object {
    windowframe
    rotate <0,90,0> translate <0,0,21>
  }       
  box {
    <4.7,9,-0.1>,
    <5.3,8.4,0>
    pigment {
      White
    }
  }                                 
  object {
    sinsulator
    translate <5,7,-0.2>
  }
  cylinder { <5,7,-0.05>,<5,5.5,-0.05>,0.05 pigment { LightBlue } }
  cylinder { <5,5.5,-0.05>,<-0.05,5.5,-0.05>,0.05 pigment { LightBlue } }
  cylinder { <-0.05,5.5,-0.05>,<-0.05,5.5,1>,0.05 pigment { LightBlue } }
  cylinder { <-0.05,5.5,1>,<-0.05,0.5,1>,0.05 pigment { LightBlue } }
  object {
    meter
    translate <0,0.5,1>
  }
}

object {
  house
  translate <460,19,408>
}

cylinder {
  <465+0.5,19+12-0.1,405>,<460+5,19+7,408-0.4>,0.05
  pigment {
    Black
  }
  finish {
    phong .75
    phong_size 25
  }
}         

light_source { <464,24,416> color <hl,hl,hl> }
light_source { <464,24,431> color <hl,hl,hl> }
         
sphere {
  <464,25,416>,0.5
  pigment {
    White
  }
  finish {
    ambient 1
    diffuse 0.8
  }
}
  
difference {
  box {
    <460.1,19.1,408.1>,
    <460.4,24.9,410>  
  }
  box {
    <460.2,20,408.7>,
    <461,21,409.3>
  }
  pigment {
    CadetBlue
  }
}

/* Wall */
box {
  <460.1,19.1,422.9>,
  <467.9,24.9,423.1>
  pigment {
    CadetBlue
  }
}

/* Door in wall */
box {
  <462,19,422.8>,
  <463.5,22,423.2>
  texture {
    T_Wood1
  }
}

/* Breakers */
box {
  <460.2,20,408.7>,
  <460.3,21,409.3>
  pigment {
    Black
  }
}

/* Door */
box {
  <467.8,19,410>,
  <468.2,22,411.5>
  texture {
    T_Wood1
  }
}

/* Lightswitch and other outlets */
union {
  box {
    <460.1,21,412>,
    <460.2,21.3,412.3>
  }
  cylinder {
    <460.1,21.15,412.15>,
    <460.3,21.15,412.15>,0.1
  }
  box {
    <460.1,20,413>,
    <460.2,19.7,413.6>
  }
  pigment {
    White
  }
}

/* Wire to television */
cylinder {
  <460.2,19.85,413.45>,
  <461,19.5,415>,0.01
  pigment {
    Black
  }
}
  
/* Nice floor */
box {
  <460.1,19.1,408.1>,
  <467.9,19.2,436.9>
  texture {
    T_Stone5
  }
}

/* Table */
#declare table = union {
  box { 
    <0,0,0>,
    <0.1,1,0.1>
  }
  box {
    <1,0,0>,
    <0.9,1,0.1>
  }
  box {
    <1,0,2>,
    <0.9,1,1.9>
  }
  box {
    <0,0,2>,
    <0.1,1,1.9>
  }
  box {
    <0,1,0>,
    <1,0.9,2>
  }
  texture {
    T_Wood1
  }
}

object {
  table
  translate <461,19,414>
}

#declare tv_body = difference {
  box { <0,0,0>,<2,2,-1> } 
  box { <-0.1,-0.1,0.1>,<0.1,0.1,-1.1> }
  box { <1.9,-0.1,0.1>,<2.1,0.1,-1.1> }
  box { <0.1,0.5,-0.9>,<1.9,1.8,-1.1> }
  box { <0.5,0.2,-0.97>,<1.5,0.3,-1.1> }
  cylinder { <1,-1,-0.99>,<1,-1,-1.1>,3 }
  pigment { Black }
}

#declare television = union {
  object { tv_body }                   
#if (clock<37)
  box { <0.1,0.5,-0.9>,<1.9,1.8,-0.95> texture { T_Glass2 } interior { I_Glass } }
#else
  /* We need to add an image to the television */
  box { 
    <0.1,0.5,-0.9>,
    <1.9,1.8,-0.95> 
    pigment { 
      image_map { 
        png "journey.png"
      } 
      scale <2,2,1>
    } 
    finish {
#if (clock<38) 
      ambient (clock-37) 
#else
      ambient 1
#end
    } 
  }    
#end
  sphere { <1,0.1,-1>,0.02 pigment { Red } finish { ambient hl2 } } // Make sure LED turns on and off later on
  cylinder { <0.5,0.15,-1>,<0.5,0.15,-1.1>,0.03 pigment { Yellow } }
  cylinder { <0.4,0.15,-1>,<0.4,0.15,-1.1>,0.02 pigment { White } }
}

object {
  television
  rotate <0,-90,0>
  translate <461,20,414>
}             

/* Breaker door */
#declare breakerdoor = union {
  box {
    <0,0,0>,
    <0.1,1,0.6>
    pigment {
      CadetBlue
    }
  }
  box {
    <0.1,0.5,0.5>,
    <0.2,0.7,0.4>
    pigment {
      Black
    }
  }
  box {
    <-0.02,0.5,0.61>,
    <0,0.7,0.5>  
    pigment {
      Black
    }
  }    
  box {
    <0,0.1,0>,
    <-0.01,0.9,0.5>
    pigment {
      image_map {
        png "breakers.png"
      }
      rotate <0,90,0>
      translate <0,0.1,0>
      scale <1,0.8,0.5>
    }
  }
}  

object {  
  breakerdoor
  rotate <0,hd,0>
  translate <460.4,20,408.7>
}

object {
  br_bear   
  scale <0.7,0.7,0.7>
  rotate <0,-90,0>
  translate <460.8,19.5,411.5>
}
