/* SUBSTATION.INC - Programmed by Maarten Hofman */
/* 120203: Moved data here */
/* 130203: Fixed some issues with the pylon */
/* 170203: Added the second substation */
/* 190203: Added wires to the pole */
/* 160303: Added warning label to the pylon */

box {
  <812,0,765>,
  <822,waterlevel-8,776.5>
  texture {
    T_Stone8
  }
}

#declare crossbar = union {
  cylinder {
    <0,0,0>,
    <0,2,0>,0.02
  }
  cylinder {
    <0.5,0,0>,
    <0.5,2,0>,0.02
  }
  cylinder {
    <0.5,0,0.5>,
    <0.5,2,0>,0.02
  }
  cylinder {
    <0,0,0.5>,
    <0,2,0.5>,0.02
  }
  cylinder {
    <0,0,0>,
    <0,0,0.5>,0.02
  }
  cylinder {
    <0,0,0>,
    <0.5,0,0>,0.02
  }
  cylinder {
    <0.5,0,0.5>,
    <0,0,0.5>,0.02
  }
  cylinder {
    <0.5,0,0.5>,
    <0.5,0,0>,0.02
  }
  cylinder {
    <0,2,0>,
    <0,2,0.5>,0.02
  }
  cylinder {
    <0,2,0>,
    <0.5,2,0>,0.02
  }
  cylinder {
    <0.5,2,0.5>,
    <0,2,0.5>,0.02
  }
  cylinder {
    <0.5,2,0.5>,
    <0.5,2,0>,0.02
  }
  cylinder {
    <0,0,0>,
    <0,2,0.5>,0.02
  }
  cylinder {
    <0,0,0>,
    <0.5,2,0>,0.02
  }
  cylinder {
    <0,2,0>,
    <0.5,0,0>,0.02
  }
  cylinder {
    <0,2,0>,
    <0,0,0.5>,0.02
  }
  cylinder {
    <0.5,0,0.5>,
    <0,2,0.5>,0.02
  }
  cylinder {
    <0.5,0,0.5>,
    <0.5,2,0>,0.02
  }
  cylinder {
    <0.5,2,0.5>,
    <0.5,0,0>,0.02
  }
  cylinder {
    <0.5,2,0.5>,
    <0,0,0.5>,0.02
  }
  texture {
    T_Chrome_3C
  }
}

#declare insulator = union {
  cone {
    <0,0,0>,0.2
    <0,1,0>,0.02
    pigment {
      DarkBrown
    }
  }
  torus { 0.18,0.02 translate <0,0.13,0> pigment { DarkGreen } }
  torus { 0.15,0.02 translate <0,0.25,0> pigment { DarkGreen } }
  torus { 0.13,0.02 translate <0,0.38,0> pigment { DarkGreen } }
  torus { 0.1,0.02 translate <0,0.5,0> pigment { DarkGreen } }
  torus { 0.08,0.02 translate <0,0.63,0> pigment { DarkGreen } }
  torus { 0.05,0.02 translate <0,0.75,0> pigment { DarkGreen } }
  torus { 0.03,0.02 translate <0,0.88,0> pigment { DarkGreen } }
}

#declare ssa = waterlevel-8;

object { crossbar translate <813,ssa,766> }
box { <812.9,ssa,765.9>,<813.6,ssa+0.1,766.6> texture { T_Stone2 } }
object { crossbar translate <813,ssa+2,766> }
object { crossbar translate <813,ssa+4,766> }
object { crossbar translate <813,ssa+6,766> }
object { crossbar translate <813,ssa+8,766> }
object { crossbar rotate <90,0,0> translate <813,ssa+10,766.5> }
object { crossbar rotate <90,0,0> translate <813,ssa+10,768.5> }
object { crossbar translate <813,ssa,770.5> }
box { <812.9,ssa,770.4>,<813.6,ssa+0.1,771.1> texture { T_Stone2 } }  
object { crossbar translate <813,ssa+2,770.5> }
object { crossbar translate <813,ssa+4,770.5> }
object { crossbar translate <813,ssa+6,770.5> }
object { crossbar translate <813,ssa+8,770.5> }
object { crossbar rotate <90,0,0> translate <813,ssa+10,771> }
object { crossbar rotate <90,0,0> translate <813,ssa+10,773> }      
box { <812.9,ssa,774.9>,<813.6,ssa+0.1,775.6> texture { T_Stone2 } }
object { crossbar translate <813,ssa,775> }
object { crossbar translate <813,ssa+2,775> }
object { crossbar translate <813,ssa+4,775> }
object { crossbar translate <813,ssa+6,775> }
object { crossbar translate <813,ssa+8,775> }

object { crossbar translate <819.5,ssa,766> }
box { <819.4,ssa,765.9>,<820.1,ssa+0.1,766.6> texture { T_Stone2 } }
box { <819.4,ssa,770.4>,<820.1,ssa+0.1,771.1> texture { T_Stone2 } }  
box { <819.4,ssa,774.9>,<820.1,ssa+0.1,775.6> texture { T_Stone2 } }
object { crossbar translate <819.5,ssa+2,766> }
object { crossbar translate <819.5,ssa+4,766> }
object { crossbar translate <819.5,ssa+6,766> }
object { crossbar translate <819.5,ssa+8,766> }
object { crossbar rotate <90,0,0> translate <819.5,ssa+10,766.5> }
object { crossbar rotate <90,0,0> translate <819.5,ssa+10,768.5> }
object { crossbar translate <819.5,ssa,770.5> }
object { crossbar translate <819.5,ssa+2,770.5> }
object { crossbar translate <819.5,ssa+4,770.5> }
object { crossbar translate <819.5,ssa+6,770.5> }
object { crossbar translate <819.5,ssa+8,770.5> }
object { crossbar rotate <90,0,0> translate <819.5,ssa+10,771> }
object { crossbar rotate <90,0,0> translate <819.5,ssa+10,773> }
object { crossbar translate <819.5,ssa,775> }
object { crossbar translate <819.5,ssa+2,775> }
object { crossbar translate <819.5,ssa+4,775> }
object { crossbar translate <819.5,ssa+6,775> }
object { crossbar translate <819.5,ssa+8,775> }

object { crossbar rotate <90,0,0> rotate <0,90,0> translate <814,ssa+8.5,766> }
object { crossbar rotate <90,0,0> rotate <0,90,0> translate <816,ssa+8.5,766> }
object { crossbar rotate <90,0,0> rotate <0,90,0> translate <818,ssa+8.5,766> }
object { crossbar rotate <90,0,0> rotate <0,90,0> translate <814,ssa+8.5,775> }
object { crossbar rotate <90,0,0> rotate <0,90,0> translate <816,ssa+8.5,775> }
object { crossbar rotate <90,0,0> rotate <0,90,0> translate <818,ssa+8.5,775> }

object { insulator translate <813.25,ssa+10,768> }
object { insulator translate <813.25,ssa+10,769> }
object { insulator translate <813.25,ssa+10,770> }
object { insulator translate <819.75,ssa+10,775> }
object { insulator translate <819.75,ssa+10,774> }
object { insulator translate <819.75,ssa+10,773> }

object { insulator rotate <180,0,0> translate <813.25,ssa+9.5,775> }
object { insulator rotate <180,0,0> translate <813.25,ssa+9.5,774> } 
object { insulator rotate <180,0,0> translate <813.25,ssa+9.5,768.5> }
object { insulator rotate <180,0,0> translate <813.25,ssa+9.5,769.5> } 

object { insulator rotate <180,0,0> translate <819.25,ssa+9.5,767> }
object { insulator rotate <180,0,0> translate <819.25,ssa+9.5,768> } 
object { insulator rotate <180,0,0> translate <819.25,ssa+9.5,769> }
object { insulator rotate <180,0,0> translate <819.25,ssa+9.5,772> } 
object { insulator rotate <180,0,0> translate <819.25,ssa+9.5,773> }
object { insulator rotate <180,0,0> translate <819.25,ssa+9.5,774> } 


/* Put in wires from house */
union {
  cylinder {
    <812,waterlevel+4,767>,
    <813.25,ssa+11,768>,0.05
  }
  cylinder {
    <812,waterlevel+4,768>,
    <813.25,ssa+11,769>,0.05
  }
  cylinder {
    <812,waterlevel+4,769>,
    <813.25,ssa+11,770>,0.05
  }
  texture {
    T_Chrome_1A
  }
}

/* Put in wires through substation */
union {
  cylinder { <813.25,ssa+11,768>,<814+1.75,ssa+4,767+1.25>,0.05 }       
  cylinder { <814+0.75,ssa+3.5,767+0.25>,<812-3.5,178+15-1,755+2.5>,0.05 }
  cylinder { <814+1.25,ssa+3.5,767+0.25>,<812+8.5,178+15-1,755+2.5>,0.05 }     
  cylinder { <813.25,ssa+11,770>,<814+1.75,ssa+4,772+1.25>,0.05 }
/* cylinder { <814+0.75,ssa+3.5,772+0.25>,<812-3.5,178+17.5-1,755+2.5>,0.05 } Redirect */
  cylinder { <814+0.75,ssa+3.5,772+0.25>,<819.25,ssa+8.5,767>,0.05 } /* Redirection */
  cylinder { <819.25,ssa+8.5,767>,<812-3.5,178+17.5-1,755+2.5>,0.05 } /* Redirection II */ 
  cylinder { <814+1.25,ssa+3.5,772+0.25>,<812+8.5,178+17.5-1,755+2.5>,0.05 }
  cylinder { <813.25,ssa+11,769>,<819+1.75,ssa+4,767+1.25>,0.05 }
  cylinder { <819+0.75,ssa+3.5,767+0.25>,<812-3.5,178+20-1,755+2.5>,0.05 }
  cylinder { <819+1.25,ssa+3.5,767+0.25>,<812+8.5,178+20-1,755+2.5>,0.05 }   
/*
  pigment {
    Green
  }
  finish {
    ambient 0.6
    diffuse 0.4
  }
*/
  texture {
    T_Chrome_1A
  }      
}

#declare transformer = union {
  box {
    <0,0,0>, 
    <2,0.1,2>
    texture {
      T_Stone2
    }
  }
  box {
    <0.5,0,0.1>,
    <1.5,2.5,1.9>
    pigment {
      DarkGreen
    }
  }
  object { insulator translate <0.75,2.5,0.25> }
  object { insulator translate <1.25,2.5,0.25> }
  object { insulator translate <0.75,2.5,1.75> }
  object { insulator translate <1.25,2.5,1.75> }  
  box {
    <0.1,0,0.5>,
    <1.9,3,1.5>
    pigment {
      DarkGreen
    }
  }
  object { insulator translate <0.25,3,0.75> }
  object { insulator translate <0.25,3,1.25> }
  object { insulator translate <1.75,3,0.75> }
  object { insulator translate <1.75,3,1.25> }  
}

object {
  transformer
  translate <814,ssa,767>
}       
object {
  transformer 
  translate <814,ssa,772>
}      
object {
  transformer 
  translate <819,ssa,767>
}
object {
  transformer
  translate <819,ssa,772>
}

#declare sidebarmetal = union {
  /* Left */
  cylinder { <2,0,2>,<-4,0.25,2.25>,0.05 }
  cylinder { <2,0,3>,<-4,0.25,2.75>,0.05 }
  cylinder { <2,1,2>,<-4,0.75,2.25>,0.05 }
  cylinder { <2,1,3>,<-4,0.75,2.75>,0.05 }
  cylinder { <-4,0.25,2.25>,<-4,0.25,2.75>,0.05 }
  cylinder { <-4,0.25,2.75>,<-4,0.75,2.75>,0.05 }
  cylinder { <-4,0.75,2.75>,<-4,0.75,2.25>,0.05 }
  cylinder { <-4,0.75,2.25>,<-4,0.25,2.25>,0.05 }
  cylinder { <-4,0.25,2.25>,<-4,0.75,2.75>,0.05 }
  cylinder { <-4,0.25,2.75>,<-4,0.75,2.25>,0.05 }
  cylinder { <2,0,2>,<-1,0.13,2.87>,0.05 }
  cylinder { <2,0,2>,<-1,0.87,2.13>,0.05 }
  cylinder { <2,1,3>,<-1,0.13,2.87>,0.05 }
  cylinder { <2,1,3>,<-1,0.87,2.13>,0.05 }
  cylinder { <2,1,2>,<-1,0.13,2.13>,0.05 }
  cylinder { <2,1,2>,<-1,0.87,2.87>,0.05 }
  cylinder { <2,0,3>,<-1,0.13,2.13>,0.05 }
  cylinder { <2,0,3>,<-1,0.87,2.87>,0.05 }
  cylinder { <-1,0.13,2.87>,<-1,0.87,2.87>,0.05 }
  cylinder { <-1,0.87,2.87>,<-1,0.87,2.13>,0.05 }
  cylinder { <-1,0.87,2.13>,<-1,0.13,2.13>,0.05 }
  cylinder { <-1,0.13,2.13>,<-1,0.13,2.87>,0.05 }
  cylinder { <-1,0.13,2.13>,<-4,0.25,2.75>,0.05 }
  cylinder { <-1,0.13,2.13>,<-4,0.75,2.25>,0.05 }
  cylinder { <-1,0.87,2.87>,<-4,0.25,2.75>,0.05 }
  cylinder { <-1,0.87,2.87>,<-4,0.75,2.25>,0.05 }
  cylinder { <-1,0.13,2.87>,<-4,0.25,2.25>,0.05 }
  cylinder { <-1,0.13,2.87>,<-4,0.75,2.75>,0.05 }
  cylinder { <-1,0.87,2.13>,<-4,0.25,2.25>,0.05 }
  cylinder { <-1,0.87,2.13>,<-4,0.75,2.75>,0.05 }
  /* Right */
  cylinder { <3,0,2>,<9,0.25,2.25>,0.05 }
  cylinder { <3,0,3>,<9,0.25,2.75>,0.05 }
  cylinder { <3,1,2>,<9,0.75,2.25>,0.05 }
  cylinder { <3,1,3>,<9,0.75,2.75>,0.05 }
  cylinder { <9,0.25,2.25>,<9,0.25,2.75>,0.05 }
  cylinder { <9,0.25,2.75>,<9,0.75,2.75>,0.05 }
  cylinder { <9,0.75,2.75>,<9,0.75,2.25>,0.05 }
  cylinder { <9,0.75,2.25>,<9,0.25,2.25>,0.05 }
  cylinder { <9,0.25,2.25>,<9,0.75,2.75>,0.05 }
  cylinder { <9,0.25,2.75>,<9,0.75,2.25>,0.05 }
  cylinder { <3,0,2>,<6,0.13,2.87>,0.05 }
  cylinder { <3,0,2>,<6,0.87,2.13>,0.05 }
  cylinder { <3,1,3>,<6,0.13,2.87>,0.05 }
  cylinder { <3,1,3>,<6,0.87,2.13>,0.05 }
  cylinder { <3,1,2>,<6,0.13,2.13>,0.05 }
  cylinder { <3,1,2>,<6,0.87,2.87>,0.05 }
  cylinder { <3,0,3>,<6,0.13,2.13>,0.05 }
  cylinder { <3,0,3>,<6,0.87,2.87>,0.05 }
  cylinder { <6,0.13,2.87>,<6,0.87,2.87>,0.05 }
  cylinder { <6,0.87,2.87>,<6,0.87,2.13>,0.05 }
  cylinder { <6,0.87,2.13>,<6,0.13,2.13>,0.05 }
  cylinder { <6,0.13,2.13>,<6,0.13,2.87>,0.05 }
  cylinder { <6,0.13,2.13>,<9,0.25,2.75>,0.05 }
  cylinder { <6,0.13,2.13>,<9,0.75,2.25>,0.05 }
  cylinder { <6,0.87,2.87>,<9,0.25,2.75>,0.05 }
  cylinder { <6,0.87,2.87>,<9,0.75,2.25>,0.05 }
  cylinder { <6,0.13,2.87>,<9,0.25,2.25>,0.05 }
  cylinder { <6,0.13,2.87>,<9,0.75,2.75>,0.05 }
  cylinder { <6,0.87,2.13>,<9,0.25,2.25>,0.05 }
  cylinder { <6,0.87,2.13>,<9,0.75,2.75>,0.05 }
}
                     
#declare sidebar = union {
  object {
    sidebarmetal
  }
  object {
    insulator
    rotate <180,0,0>
    translate <-3.5,0,2.5>
  }
  object {
    insulator
    rotate <180,0,0>
    translate <8.5,0,2.5>
  }
}
                       
#declare metalpylon = union {
  /* Main bars */
  cylinder { <0,0,0>,<2,15,2>,0.05 }
  cylinder { <5,0,0>,<3,15,2>,0.05 }
  cylinder { <0,0,5>,<2,15,3>,0.05 }
  cylinder { <5,0,5>,<3,15,3>,0.05 }
  /* In between main bars */
  cylinder { <0,0,0>,<4.33,4.33,0.67>,0.05 }  
  cylinder { <0,0,0>,<0.67,4.33,4.33>,0.05 }
  cylinder { <5,0,0>,<0.67,4.33,0.67>,0.05 }
  cylinder { <5,0,0>,<4.33,4.33,4.33>,0.05 }
  cylinder { <0,0,5>,<4.33,4.33,4.33>,0.05 }
  cylinder { <0,0,5>,<0.67,4.33,0.67>,0.05 }
  cylinder { <5,0,5>,<4.33,4.33,0.67>,0.05 }
  cylinder { <5,0,5>,<0.67,4.33,0.67>,0.05 }  
  cylinder { <4.33,4.33,0.67>,<0.67,4.33,0.67>,0.05 }
  cylinder { <0.67,4.33,0.67>,<0.67,4.33,4.33>,0.05 }
  cylinder { <0.67,4.33,4.33>,<4.33,4.33,4.33>,0.05 }
  cylinder { <4.33,4.33,4.33>,<4.33,4.33,0.67>,0.05 } 
  cylinder { <0.67,4.33,0.67>,<1,8,4>,0.05 }
  cylinder { <0.67,4.33,0.67>,<4,8,1>,0.05 }
  cylinder { <0.67,4.33,4.33>,<1,8,1>,0.05 }
  cylinder { <0.67,4.33,4.33>,<4,8,4>,0.05 }
  cylinder { <4.33,4.33,0.67>,<1,8,1>,0.05 }
  cylinder { <4.33,4.33,0.67>,<4,8,4>,0.05 }
  cylinder { <4.33,4.33,4.33>,<1,8,4>,0.05 }
  cylinder { <4.33,4.33,4.33>,<4,8,1>,0.05 }
  cylinder { <1,8,4>,<4,8,4>,0.05 }
  cylinder { <4,8,4>,<4,8,1>,0.05 }
  cylinder { <4,8,1>,<1,8,1>,0.05 }
  cylinder { <1,8,1>,<1,8,4>,0.05 }
  cylinder { <1,8,1>,<1.5,11,3.5>,0.05 }
  cylinder { <1,8,1>,<3.5,11,1.5>,0.05 }
  cylinder { <4,8,1>,<1.5,11,1.5>,0.05 }
  cylinder { <4,8,1>,<3.5,11,3.5>,0.05 }
  cylinder { <4,8,4>,<1.5,11,3.5>,0.05 }
  cylinder { <4,8,4>,<3.5,11,1.5>,0.05 }
  cylinder { <1,8,4>,<1.5,11,1.5>,0.05 }
  cylinder { <1,8,4>,<3.5,11,3.5>,0.05 }
  cylinder { <1.5,11,1.5>,<3.5,11,1.5>,0.05 }
  cylinder { <3.5,11,1.5>,<3.5,11,3.5>,0.05 }
  cylinder { <3.5,11,3.5>,<1.5,11,3.5>,0.05 }
  cylinder { <1.5,11,3.5>,<1.5,11,1.5>,0.05 }    
  cylinder { <1.5,11,1.5>,<1.75,13.33,3.25>,0.05 }
  cylinder { <1.5,11,1.5>,<3.25,13.33,1.75>,0.05 }
  cylinder { <3.5,11,3.5>,<1.75,13.33,3.25>,0.05 }
  cylinder { <3.5,11,3.5>,<3.25,13.33,1.75>,0.05 }
  cylinder { <1.5,11,3.5>,<1.75,13.33,1.75>,0.05 }
  cylinder { <1.5,11,3.5>,<3.25,13.33,3.25>,0.05 }
  cylinder { <3.5,11,1.5>,<1.75,13.33,1.75>,0.05 }
  cylinder { <3.5,11,1.5>,<3.25,13.33,3.25>,0.05 }
  cylinder { <1.75,13.33,3.25>,<3.25,13.33,3.25>,0.05 }
  cylinder { <3.25,13.33,3.25>,<3.25,13.33,1.75>,0.05 }
  cylinder { <3.25,13.33,1.75>,<1.75,13.33,1.75>,0.05 }
  cylinder { <1.75,13.33,1.75>,<1.75,13.33,3.25>,0.05 }
  cylinder { <1.75,13.33,1.75>,<3,15,2>,0.05 }
  cylinder { <1.75,13.33,1.75>,<2,15,3>,0.05 }
  cylinder { <3.75,13.33,3.75>,<3,15,2>,0.05 }
  cylinder { <3.75,13.33,3.75>,<2,15,3>,0.05 }
  cylinder { <1.75,13.33,3.75>,<2,15,2>,0.05 }
  cylinder { <1.75,13.33,3.75>,<3,15,3>,0.05 }
  cylinder { <3.75,13.33,1.75>,<2,15,2>,0.05 }
  cylinder { <3.75,13.33,1.75>,<3,15,3>,0.05 }
  cylinder { <2,15,2>,<3,15,2>,0.05 }
  cylinder { <3,15,2>,<3,15,3>,0.05 }
  cylinder { <3,15,3>,<2,15,3>,0.05 }
  cylinder { <2,15,3>,<2,15,2>,0.05 }       
  /* Top bars */
  cylinder { <2,15,2>,<2,21,2>,0.05 }
  cylinder { <3,15,2>,<3,21,2>,0.05 }
  cylinder { <2,15,3>,<2,21,3>,0.05 }
  cylinder { <3,15,3>,<3,21,3>,0.05 }
  /* Crosses in top bars */
  cylinder { <2,15,2>,<2,18,3>,0.05 }
  cylinder { <2,15,2>,<3,18,2>,0.05 }
  cylinder { <3,15,3>,<2,18,3>,0.05 }
  cylinder { <3,15,3>,<3,18,2>,0.05 }
  cylinder { <2,18,2>,<2,15,3>,0.05 }
  cylinder { <2,18,2>,<3,15,2>,0.05 }
  cylinder { <3,18,3>,<2,15,3>,0.05 }
  cylinder { <3,18,3>,<3,15,2>,0.05 }
  cylinder { <2,18,2>,<2,21,3>,0.05 }
  cylinder { <2,18,2>,<3,21,2>,0.05 }
  cylinder { <3,18,3>,<2,21,3>,0.05 }
  cylinder { <3,18,3>,<3,21,2>,0.05 }
  cylinder { <2,21,2>,<2,18,3>,0.05 }
  cylinder { <2,21,2>,<3,18,2>,0.05 }
  cylinder { <3,21,3>,<2,18,3>,0.05 }
  cylinder { <3,21,3>,<3,18,2>,0.05 }
  /* Pointy top */
  cylinder { <2,21,2>,<2.5,22,2.5>,0.05 }
  cylinder { <3,21,2>,<2.5,22,2.5>,0.05 }
  cylinder { <2,21,3>,<2.5,22,2.5>,0.05 }
  cylinder { <3,21,3>,<2.5,22,2.5>,0.05 }
}

#declare warningsign = box {
  <0,0,0>,
  <1,1,0.1>
  pigment {
    image_map {
       gif "voltage2.gif"
    }
  }
  finish {
    F_MetalC
  }
}
       
#declare pylon = union {
  object {
    metalpylon
  }
  box { <-0.2,0,-0.2>,<0.2,-100,0.2> texture { T_Stone2 } } 
  box { <4.8,0,-0.2>,<5.2,-100,0.2>  texture { T_Stone2 } }
  box { <-0.2,0,4.8>,<0.2,-100,5.2>  texture { T_Stone2 } }
  box { <4.8,0,4.8>,<5.2,-100,5.2>   texture { T_Stone2 } }
  object {
    sidebar
    translate <0,15,0>
  }
  object {
    sidebar 
    translate <0,17.5,0>
  }
  object {
    sidebar
    translate <0,20,0>
  }
  object {
    warningsign
    translate <2,3.33,0.67>
  }
  object {
    warningsign
    rotate <0,180,0>
    translate <3,3.33,4.67>
  }
  object {
    warningsign
    rotate <0,90,0>
    translate <0.67,3.33,3>
  }
  object {
    warningsign
    rotate <0,270,0>
    translate <4.67,3.33,2>
  }
  texture {
    T_Chrome_3C
  }
}

object {
  pylon
  translate <812,178,755>
}

/* Second substation */

box {
  <618,99,334>,
  <608,0,324>
  texture {
    T_Stone3
  }
}

#declare hbar = difference {
  box {
    <0,0,0>,
    <0.3,1,0.3>
  }
  box {
    <-1,-1,0.02>,
    <0.14,2,0.28>
  }
  box {
    <0.16,-1,0.02>,
    <2,2,0.28>
  }
  pigment {
    MediumSeaGreen
  }
  finish {
    F_MetalC
  }
}
  
object {
  hbar                  
  scale <1,10,1>
  translate <609,99,329>
}

object {
  hbar                  
  scale <1,10,1>
  translate <613,99,329>
}

object {
  hbar                  
  scale <1,10,1>
  translate <617,99,329>
}               

object {
  hbar                  
  scale <1,10,1>
  translate <609,99,325>
}

object {
  hbar                  
  scale <1,10,1>
  translate <613,99,325>
}

object {
  hbar                  
  scale <1,10,1>
  translate <617,99,325>
}

object {
  hbar
  scale <1,8,1>
  rotate <0,0,90>
  rotate <90,0,0>
  translate <617,104,325>
}

object {
  hbar
  scale <1,8,1>
  rotate <0,0,90>
  rotate <90,0,0>
  translate <617,109,325>
}

object {
  hbar
  scale <1,8,1>
  rotate <0,0,90>
  rotate <90,0,0>
  translate <617,103,329>
}

object {
  hbar
  scale <1,8,1>
  rotate <0,0,90>
  rotate <90,0,0>
  translate <617,109,329>
}

object {
  hbar
  scale <1,8,1>
  rotate <0,0,90>
  rotate <90,0,0>
  translate <617,106,329>
}

object {
  hbar
  scale <1,8,1>
  rotate <0,0,90>
  rotate <90,0,0>
  translate <617,109,327>
}

object {
  hbar
  scale <1,8,1>
  rotate <0,0,90>
  rotate <90,0,0>
  translate <617,109,323>
}

object {
  hbar
  scale <1,6,1>
  rotate <90,0,0>
  translate <609,109,323>
}

object {
  hbar
  scale <1,6,1>
  rotate <90,0,0>
  translate <617,109,323>
}

object {
  hbar
  scale <1,6,1>
  rotate <90,0,0>
  translate <613,109,323>
}

object { insulator translate <610,109,323.15> }
object { insulator translate <611,109,323.15> }
object { insulator translate <612,109,323.15> }
object { insulator translate <616,109,323.15> }
object { insulator translate <615,109,323.15> }
object { insulator translate <614,109,323.15> }
object { insulator rotate <-90,0,0> translate <610,109,323> }
object { insulator rotate <-90,0,0> translate <611,109,323> }
object { insulator rotate <-90,0,0> translate <612,109,323> }
object { insulator rotate <-90,0,0> translate <616,109,323> }
object { insulator rotate <-90,0,0> translate <615,109,323> }
object { insulator rotate <-90,0,0> translate <614,109,323> }
object { insulator translate <609.15,109,324> }
object { insulator translate <609.15,109,325> }
object { insulator translate <609.15,109,329> }
object { insulator translate <609.15,109,328> }
object { insulator translate <609.15,109,327> }
object { insulator translate <613.15,109,329> }
object { insulator translate <613.15,109,328> }
object { insulator translate <613.15,109,327> }
object { insulator rotate <90,0,0> translate <610,109,329.3> }
object { insulator rotate <90,0,0> translate <611,109,329.3> }
object { insulator rotate <90,0,0> translate <612,109,329.3> }
object { insulator rotate <90,0,0> translate <616,109,329.3> }
object { insulator rotate <90,0,0> translate <615,109,329.3> }
object { insulator rotate <90,0,0> translate <614,109,329.3> }
object { insulator translate <610,103,329.15> }
object { insulator translate <611,103,329.15> }
object { insulator translate <612,103,329.15> }
object { insulator translate <616,103,329.15> }
object { insulator translate <615,103,329.15> }
object { insulator translate <614,103,329.15> }                     
                   
union {
  cylinder { <620-3.5,100+15-1,330+2.5>,<612,109,330.3>,0.05 }
  cylinder { <620-3.5,100+17.5-1,330+2.5>,<611,109,330.3>,0.05 }
  cylinder { <620-3.5,100+20-1,330+2.5>,<610,109,330.3>,0.05 }  
  cylinder { <612,109,330.3>,<609,105.1,332>,0.05 }
  cylinder { <611,109,330.3>,<609,105.1,331.5>,0.05 }
  cylinder { <610,109,330.3>,<609,105.1,332>,0.05 }
  texture {
    T_Chrome_1A
  }
}
                   
superellipsoid {
  <0.25,0.25>
  scale <1,2,1.5>
  translate <609,102,331.5>
  pigment {
    MediumSeaGreen
  }
  finish {
    F_MetalC
  }    
}

superellipsoid {
  <0.25,0.25>
  scale <1,2,1.5>
  translate <616,102,331.5>
  pigment {
    MediumSeaGreen
  }
  finish {
    F_MetalC
  }    
}

box {
  <615.5,99,329.9>,
  <616.5,104.1,333.1>
  pigment {
    MediumSeaGreen
  }
  finish {
    F_MetalC
  }    
}

box {
  <608.5,99,329.9>,
  <609.5,104.1,333.1>
  pigment {
    MediumSeaGreen
  }
  finish {
    F_MetalC
  }    
}

object { insulator translate <609,104.1,331> }
object { insulator translate <609,104.1,331.5> }
object { insulator translate <609,104.1,332> }
object { insulator translate <616,104.1,331> }
object { insulator translate <616,104.1,331.5> }
object { insulator translate <616,104.1,332> }

#declare sinsulator = sphere {
  <0,0,0>,0.2
  texture {
    T_Glass2
  }
  interior {
    I_Glass
  }
}

object { sinsulator translate <609,101,333.3> }
object { sinsulator translate <609,102,333.3> }
object { sinsulator translate <609,103,333.3> }
object { sinsulator translate <616,101,333.3> }
object { sinsulator translate <616,102,333.3> }
object { sinsulator translate <616,103,333.3> }

#declare pole = union {
  cylinder {
    <0,0,0>,
    <0,-100,0>,0.2
    pigment {
      Yellow
    }
  }
  cylinder {
    <0,0,0>,
    <0,14,0>,0.2
    texture {
      T_Wood2
    }
  }
  box {
    <-0.3,14,1>,
    <0.3,14.1,-1>
    texture {
      T_Wood2
    }
  }
  object {
    sinsulator
    translate <0,14.3,0>
  }
  object {
    sinsulator
    translate <0,14.3,1>
  }
  object {
    sinsulator
    translate <0,14.3,-1>
  }                    
}

object {
  pole
  translate <606,90,336>
}

cylinder {
  <606,90+14.3,336>,<608,80,334>,0.03
  texture {
    T_Chrome_1A
  }
}

cylinder {
  <606,90+14.3,336>,<608,80,338>,0.03
  texture {
    T_Chrome_1A
  }
}
                                                  
/* Wire the pole */
union {
  cylinder { <606,90+14.3,336+1>,<609,101,333.3>,0.05 }
  cylinder { <606,90+14.3,336>,<609,102,333.3>,0.05 }
  cylinder { <606,90+14.3,336-1>,<609,102,333.3>,0.05 }
  pigment {
    Black
  }
  finish {
    phong .75
    phong_size 25
  }
}
                                                 
