/* VITARA.INC - Programmed by Maarten Hofman */
/* 130303: Started programming */

#if (0)       
#include "colors.inc"
#include "skies.inc"
#include "stones.inc"
#include "metals.inc"
#include "glass.inc"

sky_sphere {
  S_Cloud2
}

plane {
  y,0
  texture {
    T_Stone4
  }
}

light_source { <0,1000,0> color White }
light_source { <1,1000,1> color White }

camera {
  location <0,1,-5>
  look_at <1.5,2,0>        
}
#end
        
#declare v_glass = difference {
  box {
    <1.2,1.3,0.1>,
    <2.8,2,0.9>
  }
  box {
    <1.3,1,0.2>,
    <2.7,3,0.8>
  }
  texture {
    T_Glass1
  }
  interior {
    I_Glass
  }
}

#declare v_cover = cylinder {
  <2.9,1.5,0.5>
  <3.2,1.5,0.5>,0.4
  pigment {
    Black
  }
  finish {
    phong .75
    phong_size 25  
  }
}

#declare v_roofred = union {
  box {
    <1.2,2,0.1>,
    <2.8,2.1,0.9>
  }
  cylinder {
    <1.1,1.2,0>
    <1.3,2.1,0.1>,0.1
  }
  cylinder {
    <1.1,1.2,1>,
    <1.3,2.1,0.9>,0.1
  }
  cylinder {
    <2.9,1.2,0>,
    <2.8,2.1,0.1>,0.1
  }
  cylinder {
    <2.9,1.2,1>,
    <2.8,2.1,0.9>,0.1
  }                  
  /* Mirrors */
  superellipsoid {
    <0.25,0.25>
    scale <0.05,0.1,0.15>
    translate <0.05,0.1,0.15>
    translate <1,1.3,-0.3>
  }
  superellipsoid {
    <0.25,0.25>
    scale <0.05,0.1,0.15>
    translate <0.05,0.1,0.15>
    translate <1,1.3,1>
  }
  pigment {
    Red
  }
  finish {
    F_MetalA
  }
}

#declare v_roofblack = union {
  cylinder {
    <2,1.3,0>,
    <2,2,0.1>,0.1
  }
  cylinder {
    <2,1.3,1>,
    <2,2,0.9>,0.1
  }  
  pigment {
    Black
  }              
  finish {
    phong .75
    phong_size 25  
  }
}
   
#declare v_roof = union {
  object {
    v_roofred
  } 
  object {
    v_roofblack
  }
}
     
#declare v_main = difference {
  superellipsoid {
    <0.25,0.25>
    scale <1.8,0.35,0.5>
    translate <1.8,0.35,0.5>
    translate <-0.3,0.6,0>
  }
  cylinder {
    <0.5,0.4,-1>,
    <0.5,0.4,2>,0.6
  }
  cylinder {
    <2.5,0.4,-1>,
    <2.5,0.4,2>,0.6
  }            
  pigment {
    Red
  }
  finish {
    F_MetalA
  }
}

#declare v_bottom_lump = union {
  superellipsoid {
    <0.25,0.25>
    scale <1.9,0.15,0.6>
    translate <1.9,0.15,0.6>
    translate <-0.4,0.3,-0.1>
  }
  cylinder {
    <0.5,0.4,-0.1>,
    <0.5,0.4,1.1>,0.7
  }
  cylinder {
    <2.5,0.4,-0.1>,
    <2.5,0.4,1.1>,0.7
  }  
}

#declare v_bottom = difference {
  object {
    v_bottom_lump
  }
  cylinder {
    <0.5,0.4,-1>,
    <0.5,0.4,2>,0.6
  }
  cylinder {
    <2.5,0.4,-1>,
    <2.5,0.4,2>,0.6
  }       
  box {
    <-1,0.3,-1>,
    <4,-1,2>
  }
  texture {
    T_Chrome_3C
  }
}

#declare v_tire = torus {
  0.3,0.2
  rotate <90,0,0>
  translate <0.5,0.5,0.2>
  pigment {
    Black
  }
  finish {  
    phong .75
    phong_size 25
  }
}

#declare v_wheel_base = difference {    
  cylinder {
    <0.5,0.5,0>,
    <0.5,0.5,0.3>,0.3
  }
  cylinder {
    <0.5,0.5,-1>,
    <0.5,0.5,1>,0.2
  }
}

#declare v_spokes = union {
  object {
    v_wheel_base
  }
  cylinder {
    <0.5,0.2,0.15>,
    <0.5,0.8,0.15>,0.1
  }
  cylinder {
    <0.2,0.5,0.15>,
    <0.8,0.5,0.15>,0.1
  }
  texture {
    T_Chrome_3C
  }
}
   
#declare v_wheel = union {
  object {
    v_tire
  }
  object {
    v_spokes
  }
}
    
#declare vitara = union {
  object {
    v_main
  }
  object {
    v_bottom
  }
  object {
    v_wheel
  }
  object {
    v_wheel
    translate <0,0,0.8>
  }
  object {
    v_wheel
    translate <2,0,0>
  }
  object {
    v_wheel
    translate <2,0,0.8>
  }
  object {
    v_glass
  }  
  object {
    v_roof
  }
  object {
    v_cover
  }
}
  
object {
  vitara       
  scale <2,2,2>  
  rotate <0,0,5>
  rotate <0,40,0>
  translate <472,17.5,411>
}

    