//+kf3.5 +kff105 +o9tran

#declare frame_start=835;

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "metals.inc"
#include "golds.inc"
#include "chess2.inc"
#include "stones.inc"
#include "pgn.inc"
#include "anim2.pgn.inc"
#include "lights.inc"

#declare quick=0;

#if (quick)
	light_source {
		<40, 80, -20>
		color rgb 1
	}
#else
	light_source {
		<40, 80, -20>
		color rgb sun_color/2//<1, 1, 1>
		spotlight
		point_at <32, 0, 32>
		radius 20
	}
	light_source {
		<10, 70, 20>
		color rgb flood1_color/2//<0.9, 0.9, 0.8>
		spotlight
		point_at <31, 0, 31>
		radius 25
	}
	light_source {
		<-20, 100, -20>
		color rgb flood2_color/2//<0.7, 0.5, 1>*0.6
		spotlight
		point_at <33, 0, 33>
		radius 22
	}
#end

#declare TransformClock=min(clock, 1);
#declare DecayClock=min(1, max((clock-1)*2,0));
#declare ErodeClock=min(1.1, max(clock-1.5, 0)*0.55);

#if (quick)
	#declare T_WhitePiece=texture {
		pigment { rgb 2 }
	}
	#declare T_BlackPiece=texture {
		pigment { red 2 }
	}
	#declare T_Sand=texture {
		pigment { rgb 1 }
	}
	_Table()
	_Board(0)
#else
	#include "env.inc"
	#declare T_WhitePiece=texture {
		T_Chrome_5B
	}
	#declare T_BlackPiece=texture {
		T_Gold_5B
	}
	#declare T_Sand=texture {
		pigment { rgb 1 }
		normal {
			average
			normal_map {
				[2.0 bumps DecayClock*3 scale 0.25]
				[1.0 agate scale 1]
			}
		}
		finish {
			diffuse 0.4
			specular 0.0
		}
	}
#end

#declare T_Transform=texture {
	average
	texture_map {
		[1-TransformClock T_BlackPiece]
		[TransformClock T_Sand]
	}
}

object {
	Pawn
	#declare loc=S_QRP_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_QNP_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_QBP_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_QP_White(39);
	translate loc*8
	texture { T_WhitePiece }
}

object {
	Pawn
	#declare loc=S_KP_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_KBP_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_KNP_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_KRP_White(39);
	translate loc*8
	texture { T_WhitePiece }
}

object {
	Rook
	#declare loc=S_KR_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Rook
	#declare loc=S_QR_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Knight
	#declare loc=S_KN_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Knight
	#declare loc=S_QN_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Bishop
	#declare loc=S_KB_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Bishop
	#declare loc=S_QB_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	King
	#declare loc=S_K_White(39);
	translate loc*8
	texture { T_WhitePiece }
}
//--------------------------------------------------------------------------------
object {
	Pawn
	#declare loc=S_QRP_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_QNP_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_QBP_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_QP_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}

object {
	Pawn
	#declare loc=S_KP_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_KBP_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_KNP_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Rook
	#declare loc=S_KR_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Rook
	#declare loc=S_QR_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Knight
	rotate y*180
	#declare loc=S_KN_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Knight
	rotate y*180
	#declare loc=S_QN_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Bishop
	rotate y*180
	#declare loc=S_KB_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Bishop
	rotate y*180
	#declare loc=S_QB_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Queen
	#declare loc=S_Q_Black(39);
	translate loc*8
	texture { T_BlackPiece }
}

/*camera {
	location <40, 8, 36>
	right x*(image_width/image_height)
	up y
	angle 60
	look_at <56, 6, 56>
}*/

#declare S_L=spline {
	linear_spline
	0, <40, 6.5, 36>
	1.5, <56, 6.5, 56>
}
#declare S_A=spline {
	quadratic_spline
	0, (x+y+z)*60
	1/3, (x+y+z)*75
	1.5, (x+y+z)*150
}

camera {
	location S_L(min(clock,1.1))
	right x*(image_width/image_height)
	up y
	angle S_A(min(clock,1.1)).x
	look_at <56, 6.5, 56>
	#if ((ErodeClock<0.25) & (DecayClock>0))
		//#error "\nI am here"
		#declare vt=vturbulence(2.0, 2.0, 8, clock)/256;
		#debug concat("\nvturb came up with <",vstr(3, vt, ",", -1, -1), ">\n")
		translate vt
	#end
}

object {
	Queen
	#declare loc=S_Q_White(39);
	translate loc*8
	texture { T_WhitePiece }
}

#declare S_PawnWidth=spline {
 cubic_spline
 -0.1000, <0.000001, 0.000000, 14.500000>
 0.0000, <0.000001, 0.000000, 13.500000>
 0.1000, <0.000001, 0.000000, 12.150000>
 0.2000, <0.000001, 0.000000, 10.800000>
 0.3000, <0.000001, 0.000000, 9.450000>
 0.4000, <1.020129, 0.000000, 8.100000>
 0.5000, <1.479502, 0.000000, 6.750000>
 0.6000, <1.130029, 0.000000, 5.400000>
 0.7000, <0.587740, 0.000000, 4.050000>
 0.8000, <1.056167, 0.000000, 2.700000>
 0.9000, <2.135170, 0.000000, 1.350000>
 1.0000, <2.500000, 0.000000, -0.000000>
 1.1000, <2.500000, 0.000000, -1.000000>
}
#declare S_KingWidth=spline {
 cubic_spline
 -0.1000, <0.250000, 0.000000, 14.500000>
 0.0000, <0.250000, 0.000000, 13.500000>
 0.1000, <0.166773, 0.000000, 12.150000>
 0.2000, <1.343488, 0.000000, 10.800000>
 0.3000, <1.027055, 0.000000, 9.450000>
 0.4000, <1.811806, 0.000000, 8.100000>
 0.5000, <0.625477, 0.000000, 6.750000>
 0.6000, <1.019576, 0.000000, 5.400000>
 0.7000, <1.045198, 0.000000, 4.050000>
 0.8000, <2.196560, 0.000000, 2.700000>
 0.9000, <2.687665, 0.000000, 1.350000>
 1.0000, <3.000000, 0.000000, -0.000000>
 1.1000, <3.000000, 0.000000, -1.000000>
}
#declare Removal=intersection {
	plane {
		y, 1
	}
	plane {
		-y, 0
	}
	translate y*(13.5-13.5*ErodeClock)
}

#declare DeadPawn=object { Pawn }
#declare DeadKing=object { King }
#declare PawnBlow=intersection {
	object { DeadPawn }
	object { Removal }
}
#declare KingBlow=intersection {
	object { DeadKing }
	object { Removal }
}
#declare PawnWindWidth=S_PawnWidth(ErodeClock).x;
#declare KingWindWidth=S_KingWidth(ErodeClock).x;
#declare PawnVortex=cone {
	0, PawnWindWidth, x*PawnWindWidth*6, 0
	//rotate y*45
	translate y*(13.5-13.5*ErodeClock)
}

#declare KingVortex=cone {
	0, KingWindWidth, x*KingWindWidth*6, 0
	//rotate y*45
	translate y*(13.5-13.5*ErodeClock)
}
#declare PawnSand=intersection {
	union {
		object { PawnBlow }
		object { PawnVortex }
	}
	object { Removal }
}
#declare KingSand=intersection {
	union {
		object { KingBlow }
		object { KingVortex }
	}
	object { Removal }
}

#declare WindPlane=plane {
	y, 13.5-13.5*ErodeClock
	texture {
		pigment { rgb 1 }
		finish {
			diffuse 0.4
			specular 0
		}
		normal {
			agate
			scale <1, 1, 0.25>
		}
	}
}

#declare M_BlowingSand=material {
	texture {
		pigment {
			bumps
			color_map {
				[0.2 rgb 1]
				//[0.9 rgb 2]
				[0.6 rgbf 1]
			}
			scale 0.25
		}
		finish {
			diffuse 0.4
			specular 0
		}
	}
}

#if (ErodeClock > 0)
	#if (PawnWindWidth>0.25)
		object {
			PawnSand
			translate <7, 0, 6>*8
			material { M_BlowingSand }
		}
	#end
	object {
		KingSand
		translate <7, 0, 7>*8
		material { M_BlowingSand }
	}
#end

intersection {
	object {
		DeadPawn
		texture { T_Transform }
	}
	object { WindPlane }
	translate <7, 0, 6>*8
}
intersection {
	object {
		DeadKing
		texture { T_Transform }
	}
	object { WindPlane }
	translate <7, 0, 7>*8
}
