//+ft +w360 +h203 +a0.3 -j +l..\ +kf39 +kff1490 +ef120 +oopen
#declare frame_start=265;

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "metals.inc"
#include "golds.inc"
#include "stones.inc"
#include "pgn.inc"
#include "lights.inc"

#declare quick=0;

#if (quick)
	#declare T_WhitePiece=texture {
		pigment { rgb 2 }
	}
	#declare T_BlackPiece=texture {
		pigment { red 2 }
	}
	_Table()
	_Board(0)
#else
	#include "env.inc"
	#declare T_WhitePiece=texture {
		T_Chrome_5B
	}
	#declare T_BlackPiece=texture {
		T_Gold_5B
	}
#end

camera {
	location <32, 8, 52>
	right x*(image_width/image_height)
	up y
	angle 60
	look_at <32, 7, 48>
}

#if (quick)
	light_source {
		<40, 80, -20>
		color rgb 1
	}
#else
	light_source {
		<40, 80, -20>
		color rgb sun_color/2//<1, 1, 1>
		spotlight
		point_at <32, 0, 32>
		radius 20
	}
	light_source {
		<10, 70, 20>
		color rgb flood1_color/2//<0.9, 0.9, 0.8>
		spotlight
		point_at <31, 0, 31>
		radius 25
	}
	light_source {
		<-20, 100, -20>
		color rgb flood2_color/2//<0.7, 0.5, 1>*0.6
		spotlight
		point_at <33, 0, 33>
		radius 22
	}
#end

#include "anim2.pgn.inc"

object {
	Pawn
	#declare loc=S_QRP_White(clock);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_QNP_White(clock);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_QBP_White(clock);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_QP_White(clock);
	translate loc*8
	texture { T_WhitePiece }
}

object {
	Pawn
	#declare loc=S_KP_White(clock);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_KBP_White(clock);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_KNP_White(clock);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Pawn
	#declare loc=S_KRP_White(clock);
	translate loc*8
	texture { T_WhitePiece }
}

object {
	Rook
	#declare loc=S_KR_White(clock);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Rook
	#declare loc=S_QR_White(clock);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Knight
	#declare loc=S_KN_White(clock);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Knight
	#declare loc=S_QN_White(clock);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Bishop
	#declare loc=S_KB_White(clock);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Bishop
	#declare loc=S_QB_White(clock);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	Queen
	#declare loc=S_Q_White(clock);
	translate loc*8
	texture { T_WhitePiece }
}
object {
	King
	#declare loc=S_K_White(clock);
	translate loc*8
	texture { T_WhitePiece }
}
//--------------------------------------------------------------------------------
object {
	Pawn
	#declare loc=S_QRP_Black(clock);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_QNP_Black(clock);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_QBP_Black(clock);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_QP_Black(clock);
	translate loc*8
	texture { T_BlackPiece }
}

object {
	Pawn
	#declare loc=S_KP_Black(clock);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_KBP_Black(clock);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_KNP_Black(clock);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Pawn
	#declare loc=S_KRP_Black(clock);
	translate loc*8
	texture { T_BlackPiece }
}

object {
	Rook
	#declare loc=S_KR_Black(clock);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Rook
	#declare loc=S_QR_Black(clock);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Knight
	rotate y*180
	#declare loc=S_KN_Black(clock);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Knight
	rotate y*180
	#declare loc=S_QN_Black(clock);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Bishop
	rotate y*180
	#declare loc=S_KB_Black(clock);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Bishop
	rotate y*180
	#declare loc=S_QB_Black(clock);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	Queen
	#declare loc=S_Q_Black(clock);
	translate loc*8
	texture { T_BlackPiece }
}
object {
	King
	#declare loc=S_K_Black(clock);
	translate loc*8
	texture { T_BlackPiece }
}
