//+ft +w360 +h203 +a0.3 -j +l..\ +kf0.267857142857 +kff75 +ounfill

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "metals.inc"
#include "golds.inc"
#include "stones.inc"

#declare _textures=array[4];
#declare _textures[0]=texture { T_Chrome_5B }
#declare _textures[1]=texture { T_Gold_5B }

#declare frame_start=440;
#include "pgn.inc"
//#include "env.inc"
#include "..\inspection\inspection.inc"

#include "lightsys_CIE-sRGB.inc"
#include "lightsys.inc"
#declare WHITE_POINT=Wp_Daylight_Film;

#declare quick=0;
#declare lb=sphere {
	0, 0.375
	pigment { rgb Light_Color(Cl_Incandescent_60w,Lm_Incandescent_25w/50)*1000 }
	finish { ambient 10000 }
}
#if (quick)
	#declare LS=light_source {
		<0, 0, 0>
		color rgb 1
		looks_like { lb }
		Light_Fading()
	}
#else
	#declare LS=light_source {
		<0, 0, 0>
		Light_Color(Cl_Incandescent_60w,Lm_Incandescent_25w/10)
		looks_like { lb }
		Light_Fading()
	}
#end

//-----------------clock-----------------
//0-1:	king glows, changes to sand
//1-3:  king gets sucked up
//---------------------------------------

#declare adj_clock=clock*(3.0/0.267857142857);
#declare gild_clock=min(max(adj_clock-0, 0), 1);
#declare KingShrink_clock=min(max(adj_clock-1, 0), 2)/2;
#declare KingGrow_clock=1-KingShrink_clock;

#declare king_loc=<32, 0, 0>;

#declare T_WhitePiece=texture {
	T_Chrome_5B
}
#declare T_BlackPiece=texture {
	T_Gold_5B
}
#declare T_Sand=texture {
	pigment { rgb 1 }
	normal {
		average
		normal_map {
			[1.0 bumps 0.5 scale 0.25]
			[1.0 agate scale 1]
		}
	}
	finish {
		diffuse 0.4
		specular 0.0
	}
}
#declare T_Recay=texture {
	average
	texture_map {
		[1-gild_clock T_Gold_5B]
		[gild_clock T_Sand]
	}
}
#declare M_BlowingSand=material {
	texture {
		pigment {
			bumps
			color_map {
				[0.2 rgb 1]
				//[0.9 rgb 2]
				[0.6 rgbf 1]
			}
			scale 0.25
		}
		finish {
			diffuse 0.4
			specular 0
		}
	}
	translate y*(adj_clock*13.5*4)
}

camera {
	location <-25, 8, 0>
	right x*(image_width/image_height)
	up y
	angle 60
	look_at <32, 8, 0>
}

#declare S_KingWidth=spline {
 cubic_spline
 -0.0250, <-1.000000, 0.000000, 13.500000>
 0.0000, <0.000000, 0.000000, 13.500000>
 0.0250, <0.274727, 0.000000, 13.288561>
 0.0500, <0.251597, 0.000000, 12.811949>
 0.0750, <0.181606, 0.000000, 12.337991>
 0.1000, <0.357390, 0.000000, 11.987634>
 0.1250, <0.836644, 0.000000, 11.998362>
 0.1500, <1.313789, 0.000000, 12.046896>
 0.1750, <1.512887, 0.000000, 11.724772>
 0.2000, <1.393326, 0.000000, 11.260195>
 0.2250, <1.342952, 0.000000, 10.783467>
 0.2500, <1.301216, 0.000000, 10.305800>
 0.2750, <1.174162, 0.000000, 9.843694>
 0.3000, <1.007999, 0.000000, 9.393528>
 0.3250, <0.860982, 0.000000, 8.937024>
 0.3500, <0.860053, 0.000000, 8.466123>
 0.3750, <1.275389, 0.000000, 8.276951>
 0.4000, <1.721471, 0.000000, 8.161009>
 0.4250, <1.579790, 0.000000, 7.740703>
 0.4500, <1.114678, 0.000000, 7.649419>
 0.4750, <0.638736, 0.000000, 7.612931>
 0.5000, <0.476780, 0.000000, 7.203585>
 0.5250, <0.599955, 0.000000, 6.740553>
 0.5500, <0.761685, 0.000000, 6.288755>
 0.5750, <0.914131, 0.000000, 5.833832>
 0.6000, <1.024718, 0.000000, 5.367255>
 0.6250, <1.063036, 0.000000, 4.889359>
 0.6500, <1.054221, 0.000000, 4.409638>
 0.6750, <1.060924, 0.000000, 3.930219>
 0.7000, <1.208567, 0.000000, 3.479217>
 0.7250, <1.584009, 0.000000, 3.190887>
 0.7500, <2.042430, 0.000000, 3.050679>
 0.7750, <2.478893, 0.000000, 2.881363>
 0.8000, <2.073684, 0.000000, 2.644091>
 0.8250, <1.698432, 0.000000, 2.364364>
 0.8500, <1.940744, 0.000000, 1.977007>
 0.8750, <2.319254, 0.000000, 1.682140>
 0.9000, <2.676505, 0.000000, 1.362792>
 0.9250, <2.916744, 0.000000, 0.951124>
 0.9500, <2.997665, 0.000000, 0.479781>
 0.9750, <3.000000, 0.000000, 0.000000>
 1.0000, <3.000000, 0.000000, -1.000000>
}

#declare KingGrow=union {
	intersection {
		object { King }
		plane { y, KingGrow_clock*13.5 }
	}
	cone {
		y*KingGrow_clock*13.5, S_KingWidth(1-KingGrow_clock).x,
		y*min(max(KingGrow_clock*13.51,KingGrow_clock*13.5+S_KingWidth(1-KingGrow_clock).x*1), 13.51), 0.5
	}
	texture { T_Sand }
}

#switch (adj_clock)
#range (1,3)
	union {
		object { KingGrow }
		cylinder {
			0, y*120, 0.5
			material { M_BlowingSand }
		}
		translate king_loc
		//translate y*(plat_drop_dist-plat_drop)
	}
	#break
#range (0,1)
	sphere {
		0, 1
		hollow
		pigment { rgbf 1 }
		interior {
			media {
				emission rgb 0.5*(1-(abs(1-gild_clock*2)))
				density {
					spherical
				}
			}
		}
		scale <6, 12, 6>
		translate king_loc+y*6.5
	}
	object {
		King
		texture { T_Recay }
		translate king_loc
	}
#end

//sun
light_source {
	 <-100, 100, 500>
	//color 1
	Light_Color(Cl_Moonlight,12000/2)
	//Cl_Sunlight
	Light_Fading()
}

//hall lights
#include "swing.inc"
#declare swing_clock=clock+1.5714;
#local a=S_Swing(mod(swing_clock*2*1.75,1)).x*30-15;
#local b=S_Swing(mod(swing_clock*2*2,1)).x*30-15;
#declare SS_Cord=sphere_sweep {
	cubic_spline
	4,
	y*-2, 0.125
	<0, 0, 0>, 0.125
	<2*sin(radians(a)), -2*cos(radians(a)), 0>, 0.125
	<4*sin(radians(a)), -4*cos(radians(a)), 0>, 0.125
	no_shadow
}
union {
	object {
		LS
		translate y*-2.375
		rotate z*a
	}
	object {
		SS_Cord
		texture {
			pigment { rgb 0.2 }
			finish {
				diffuse 0.8
				specular 1
			}
		}
	}
	rotate y*80
	translate <-25, 17, 0>
}
#declare SS_Cord=sphere_sweep {
	cubic_spline
	4,
	y*-2, 0.125
	<0, 0, 0>, 0.125
	<2*sin(radians(b)), -2*cos(radians(b)), 0>, 0.125
	<4*sin(radians(b)), -4*cos(radians(b)), 0>, 0.125
	no_shadow
}
union {
	object {
		LS
		translate y*-2.375
		rotate z*b
	}
	object {
		SS_Cord
		texture {
			pigment { rgb 0.2 }
			finish {
				diffuse 0.8
				specular 1
			}
		}
	}
	rotate y*255
	translate <25, 17, 0>
}

//floor
plane {
	y, 0
	texture {
		pigment { rgb 1 }
		finish {
			diffuse 0.2
		}
		normal {
			average
			normal_map {
				[2.0 crackle 2 scale 2]
			}
		}
	}
	texture {
		pigment {
			bozo
			color_map {
				[0.3 rgbf 1]
				[0.8 rgbf <0.2, 0.3, 0.4, 0.7>]
			}
			scale <4, 1/2, 1/2>
		}
		finish {
			diffuse 0.4
		}
		normal {
			average
			normal_map {
				[2.0 crackle 2 scale 2]
			}
		}
	}
}

//ceiling
intersection {
	plane {
		-y, -17
		texture {
			pigment { rgb 0.5 }
			finish {
				diffuse 0.8
			}
			normal {
				crackle
				scale 4
			}
		}
		texture {
			pigment {
				bozo
				color_map {
					[0.3 rgbf 1]
					[0.8 rgbf <0.2, 0.3, 0.4, 0.7>]
				}
				scale 4
			}
			finish {
				diffuse 0.1
			}
			normal {
				crackle
				scale 4
			}
		}
	}
	box {
		<-40, 0, -24-7>, <40, 24, 24+7>
	}
}
object {
	side_of_cells
}
object {
	side_of_cells
	scale <1, 1, -1>
}

//prisoners------------------------------------------------------------------------
#declare T_Dirty=
texture {
	pigment {
		bozo
		color_map {
			[0.4 rgbf 1]
			[0.9 rgbf <0.2, 0.3, 0.4, 0.7>/2]
		}
	}
	finish {
		diffuse 0.5
	}
	normal {
		bozo 4
	}
	scale <2, 1, 1>*2
}

#if (quick)
	#declare T_WhitePiece=texture {
		pigment { rgb 2 }
	}
	#declare T_BlackPiece=texture {
		pigment { red 2 }
	}
#else
	#declare T_WhitePiece=
		texture {T_Chrome_4A}
		texture {T_Dirty}
	#declare T_BlackPiece=
		texture {T_Gold_2A}
		texture {T_Dirty}
#end

union {
	#include "prison.pgn.inc"
	translate <-28, 0, -28>
}
union {
	#declare wall_len=100;
	#declare wall_hi=10;
	union {
		wall(wall_len, wall_hi)
		translate -x*block_size.x/2
	}
	union {
		wall(wall_len, wall_hi)
		translate z*(wall_len-0.5)*block_size.x
	}
	union {
		wall(wall_len, wall_hi)
		rotate y*-90
	}
	union {
		wall(wall_len, wall_hi)
		rotate y*-90
		translate x*(wall_len-0.5)*block_size.x
	}
	translate x*(-wall_len*block_size.x/2+28)
	translate z*(-wall_len*block_size.x/2+28)
}
