// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Orthographic Scene Example
//       useful for generating image_maps, heightfields, etc.
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  orthographic
  location <0,0,1>     // position & direction of view
  look_at  <0,0,0>
  right 1*x            // horizontal size of view  \___ to be rendered at square size
  up 1*y               // vertical size of view    /
}

// ----------------------------------------


#declare ag = function {
  pattern { agate }
}

#declare gry = function {
  pattern { gradient <0,1,0> }
}

#declare grx = function {
  pattern { gradient <1,0,0> }
}


box {                  // this box fits exactly in view
  <-0.5, -0.5, 0>, <0.5, 0.5, 0>
  texture {
    pigment {
      function { pow(grx(x,y,z)*grx(-x,y,z)*16*gry(x,y,z)*gry(x,-y,z),2)*ag(x,y,z)  }
      color_map {
        [0.0 color rgb 0.0 ]
        [1.0 color rgb 1.0 ]
      }
    }
    finish {
      ambient 1.0
      diffuse 0.0
    }  
     translate x/2+y/2
  }
  
}

