// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Orthographic Scene Example
//       useful for generating image_maps, heightfields, etc.
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  orthographic
  location <0,0,1>     // position & direction of view
  look_at  <0,0,0>
  right 1*x            // horizontal size of view  \___ to be rendered at square size
  up 1*y               // vertical size of view    /
}


#declare scl = 3.8;
#declare gap =0.1;

box {                  // this box fits exactly in view
  <0, 0, 0>, <1, 1, 0>
  texture {
    pigment {
         waves 
       scale 1/scl
      pigment_map {
        [0.0 image_map { tga "postA.tga" } scale scl]
        [0.5-gap/2 image_map { tga "postA.tga" } scale scl]
        [0.5+gap/2 image_map { tga "postB.tga" } scale scl]
        [1.0 image_map { tga "postB.tga" } scale scl]
      }
      
    }
    finish {
      ambient 1.0
      diffuse 0.0
      reflection 1.0
      conserve_energy
    }   
    
  }
  translate -0.5
}

// create a TrueType text shape
text {
  ttf             // font type (only TrueType format for now)
  "c:\\windows\\fonts\\angsa.ttf",  // Microsoft Windows-format TrueType font file name
  "Evolution of a RayTracer",      // the string to create
  2,              // the extrusion depth
  0               // inter-character spacing  
  scale <-0.1,0.15,-0.15>
  translate 0.33*x    
  translate -0.4*y
}
