// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Radiosity Scene Template
// Date: mm/dd/yy
// Auth: ?
//
#include "colors.inc"      
#include "textures.inc" 
#include "skies.inc"            
                     
#include "msac.inc"    
// anim params: +ft +KI21 +KF23.96 +KFI0 +KFF74
// clock from 21 to 23.96
// frames from 0 to 74   
                      
#version 3.5;


#declare brt = (clock-21)/3;

global_settings {
  assumed_gamma 1.0
  max_trace_level 20
}

#default {
  texture {
    pigment {rgb 1}
      finish {
        ambient 1*brt
        diffuse 0
        specular 0
      }
  }
}

// ----------------------------------------


sky_sphere {
  pigment {
    color rgb <0.6,0.7,1.0>*brt
  }
}

// ----------------------------------------



camera {
  right x*image_width/image_height
  location  <6,3,-8>
  look_at   <0,0.75,0>     
  rotate y*35*(clock-msac)
}


/*
plane {
  y, 0
  texture {
    pigment { checker rgb <1.0, 0.2, 0.2> rgb <0.2, 1.0, 0.2> }
  }
}
*/

plane {
  y, -1
    pigment { color Blue }
}
               

// create a superquadric ellipsoid shape
// As the exponents approach 1.0, the edges get rounder
#declare BiTile = union
{
box {
  <0,-0.05,0> <1,0.0,1>
  pigment {color rgb 0.5*y}
}
box {
  <-1,-0.05,0> <0,0.0,1>
  pigment {color rgb <0.8,0.5,0.5>}
}
box {
  <-1,-0.05,-1> <0,0.0,0>
  pigment {color rgb <0,0.5,0>}
}
box {
  <0,-0.05,-1> <1,0.0,0>
  pigment {color rgb <0.8,0.5,0.5>}
}
}

      /*
#declare b2=-50;
#while (b2 <= 50)
#declare b1 = -50;
#while (b1 <= 50)
  object{BiTile translate b1*2*x+b2*2*z}
  #declare b1 = b1+1;   // increment our counter
#end
#declare b2 = b2+1;
#end
    */
intersection {
  plane { y,0 }
  box { <-101,-1,-101> <101,1,101> }
  pigment {checker  color rgb <0,0.5,0> color rgb <0.8,0.5,0.5>}
}




#declare M_Glass=    // Glass material
material {
  texture {
    finish {
    reflection {
        1.0
      }
      ambient 0.0
    }
  }
}

#declare R_Glass=    // Glass material
material {
  texture {
    finish {
      reflection {
        1.0
      }
      ambient 0.0
    }
  }
}



// torus {MAJOR, MINOR} // (in the X-Z plane)
// MAJOR = float value giving the major radius
// MINOR = float specifying the minor radius
// The major radius extends from the center of the hole
// to the mid-line of the rim while the minor radius
// is the radius of the cross-section of the rim.

     
  
      
      
union {
    
    
cylinder { -z,z,1 scale 0.8 pigment {color rgb <1,0.5,0>} 
 rotate 90*z
 translate 2.8*y       
 rotate 180*y
 rotate 90*y
}

            /*
#if (lm < 0.25)
superellipsoid { <1,2*lm> scale <4/5,4/5,4/5> pigment{torpg}
 rotate 90*z
 translate 2.8*y       
 rotate 180*y
// translate y 
 rotate 90*y  
}
#else    
isosurface {
  function {
     ( pow(sqrt(x*x+z*z)-r2,2)+pow(y-alp,2)-r1*r1 ) *
     ( pow(sqrt(x*x+z*z)-r2,2)+pow(y+alp,2)-r1*r1 ) * (1-pow((4/3)*ml,2.5))
          + pow((4/3)*ml,2.5) * ( sqrt(pow(pow(x*5/4,2)+pow(z*5/4,2),2)+pow(y*5/4,4))-1  )
      +(lm-0.25)*ml*0.1/(1+(x-lm)*(x-lm)+(y-ml/2)*(y-ml/2)+(z+ml/3)*(z+ml/3))
      -(lm-0.25)*ml*0.1/(1+(x+lm/3)*(x+lm/3) + (y+lm/4)*(y+lm/4) + (z-lm/2)*(z-lm/2))
     
   }   
   contained_by { box {<-1,-1,-1>,<1,1,1> }}
   max_gradient 8
   pigment { torpg }
// translate -0.375*y  
 rotate 90*z
 translate 2.8*y       
 rotate 180*y
// translate y   
}
#end      
 */
/*
 torus {
  0.6,
  0.2
  pigment{color Red}
 translate -0.375*y
 rotate 90*z
 translate 2.8*y       
 rotate 180*y
 }
 torus {
  0.6,
  0.2
  pigment{color Yellow}
  translate 0.75*y
 translate -0.375*y
 rotate 90*z
 translate 2.8*y       
 rotate 180*y
 }
   */
sphere {
  <0,1,2>, 1
//  translate <2.0,0,2.3>
  material { M_Glass }

  translate 2*z

}

sphere {
  <0,1,-2>, 1
//  translate <2.0,0,2.3>
  material { R_Glass }

  translate -2*z

}





// create a superquadric ellipsoid shape
// As the exponents approach 1.0, the edges get rounder
box {
  -<1,1,1>, <1,1,1>
  //  rotate 35*y
  translate y
//  translate <-2.2,1,1.8>
  texture { finish {reflection 1.0 ambient 0.0}  }
}

sphere {
  <0,0,0>, 1  

  pigment {
     color rgb 0.5
  }
  translate <4,1,0>

}
         
 rotate 35*y         

          
}
         
       
/*#declare mountainclip = merge {
  box {<ml,-1.1,ml> <1+lm,1.1,1+lm>}
  box {<ml,ml,-1.1> <1+lm,1+lm,1.1>}
  box {<-1.1,ml,ml> <1.1,1+lm,1+lm>}
  scale 1/2
  translate 1/2
} 
*/


#declare cones = intersection {
   merge {
     cone { <.25,0,.25> .25 <.25,.75,.25> 0 }
     cone { <.3,0,.6>  .3 <.3,.9,.6> 0}
     cone { <.5,0,.7> .33 <.5,.99,.7> 0}
     cone { <.85,0,.7> .2 <.85,.6,.7> 0}
     cone { <.8, 0, .3> .15 <.8,.45,.3> 0}
     box { <0,0,0> <1,0.01,1> }
   }
   box { 0,1 }                          
}

object{cones
  pigment { color rgb y } 
  scale <198,35,198>
  translate <-99,-2,99>
}
  

