// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Radiosity Scene Template
// Date: mm/dd/yy
// Auth: ?
//
#include "colors.inc"      
#include "textures.inc" 
#include "skies.inc"            
                     
#include "msac.inc"    
// anim params: +ft +KI27 +KF29.96 +KFI0 +KFF74
// clock from 27 to 29.96
// frames from 0 to 74   
                      
#declare brt = (clock-27)/3;
#declare brt = 1-(1-brt)*(1-brt);
                      
#version 3.5;


global_settings {
  assumed_gamma 1.0
  max_trace_level 20
}

#default {
  texture {
    pigment {rgb 1}
      finish {
        ambient 0.1+0.9*(1-brt)
        diffuse 0.6*(brt)
        specular 0.3*(brt)
      }
  }
}

// ----------------------------------------


sky_sphere {
  pigment {
    color rgb <0.6,0.7,1.0>
  }
}

// ----------------------------------------



camera {
  right x*image_width/image_height
  location  <6,3,-8>
  look_at   <0,0.75,0>     
  rotate y*35*(clock-msac)
}

light_source {
  <500,300,-150>       // light's position
  color rgb 1.3*brt       // light's color
}


/*
plane {
  y, 0
  texture {
    pigment { checker rgb <1.0, 0.2, 0.2> rgb <0.2, 1.0, 0.2> }
  }
}
*/

plane {
  y, -1
    pigment { color Blue }
}
               

// create a superquadric ellipsoid shape
// As the exponents approach 1.0, the edges get rounder
#declare BiTile = union
{
box {
  <0,-0.05,0> <1,0.0,1>
  pigment {color rgb 0.5*y}
}
box {
  <-1,-0.05,0> <0,0.0,1>
  pigment {color rgb <0.8,0.5,0.5>}
}
box {
  <-1,-0.05,-1> <0,0.0,0>
  pigment {color rgb <0,0.5,0>}
}
box {
  <0,-0.05,-1> <1,0.0,0>
  pigment {color rgb <0.8,0.5,0.5>}
}
}

      /*
#declare b2=-50;
#while (b2 <= 50)
#declare b1 = -50;
#while (b1 <= 50)
  object{BiTile translate b1*2*x+b2*2*z}
  #declare b1 = b1+1;   // increment our counter
#end
#declare b2 = b2+1;
#end
    */
intersection {
  plane { y,0 }
  box { <-101,-1,-101> <101,1,101> }
  pigment {checker  color rgb <0,0.5,0> color rgb <0.8,0.5,0.5>}
}




#declare M_Glass=    // Glass material
material {
  texture {
    pigment {rgbf <1,0.5,0.8,1>}
    finish {
      ambient 0.0
      diffuse 0.05*brt
      specular 0.6*brt
      roughness 0.005
      reflection {
        0.1+0.9*(1-brt), 1.0
        fresnel on
      }
      conserve_energy
    }
  }
  interior {
    ior 1 + 0.5*brt*brt
    fade_power 1001
    fade_distance 0.9
    fade_color <0.5,0.8,0.6>
  }
}

#declare R_Glass=    // Glass material
material {
  texture {
    pigment {rgbf <1,0.6,0.3,1>}
    finish {
      ambient 0.0
      diffuse 0.05*brt
      specular 0.6*brt
      roughness 0.005
      reflection {
        0.1+0.9*(1-brt), 1.0
        fresnel on
      }
      conserve_energy
    }
  }
  interior {
    ior 1+0.5*brt*brt
    fade_power 1001
    fade_distance 0.9
    fade_color <0.5,0.8,0.6>
  }
}



// torus {MAJOR, MINOR} // (in the X-Z plane)
// MAJOR = float value giving the major radius
// MINOR = float specifying the minor radius
// The major radius extends from the center of the hole
// to the mid-line of the rim while the minor radius
// is the radius of the cross-section of the rim.

     
  
  #declare r1 = 0.2;
  #declare r2 = 0.6;
  #declare alp = 0.375;
   #include "math.inc"
/*isosurface {
  function {
     ( pow(x*x+(y-alp)*(y-alp)+z*z-r1*r1-r2*r2,2)+4*r2*r2*(y-alp)*(y-alp)-4*r2*r2*r1*r1 ) *
     ( pow(x*x+(y+alp)*(y+alp)+z*z-r1*r1-r2*r2,2)+4*r2*r2*(y+alp)*(y+alp)-4*r2*r2*r1*r1 )
   }
   pigment { function { (sgn(y)*pow(abs(y),tan(ml*pi/2))+1)/2 }
             color_map { [0.0 rgb <1,1,0>] [1.0 rgb <1,0,0>] }
           }
 translate -0.375*y
 rotate 90*z
 translate 2.8*y       
 rotate 180*y
 translate y   
} */

      
      
union {
    
    
cylinder { -z,z,1 scale 0.8 pigment {color rgb <1,0.5,0>} 
 rotate 90*z
 translate 2.8*y       
 rotate 180*y
 rotate 90*y
}

            /*
#if (lm < 0.25)
superellipsoid { <1,2*lm> scale <4/5,4/5,4/5> pigment{torpg}
 rotate 90*z
 translate 2.8*y       
 rotate 180*y
// translate y 
 rotate 90*y  
}
#else    
isosurface {
  function {
     ( pow(sqrt(x*x+z*z)-r2,2)+pow(y-alp,2)-r1*r1 ) *
     ( pow(sqrt(x*x+z*z)-r2,2)+pow(y+alp,2)-r1*r1 ) * (1-pow((4/3)*ml,2.5))
          + pow((4/3)*ml,2.5) * ( sqrt(pow(pow(x*5/4,2)+pow(z*5/4,2),2)+pow(y*5/4,4))-1  )
      +(lm-0.25)*ml*0.1/(1+(x-lm)*(x-lm)+(y-ml/2)*(y-ml/2)+(z+ml/3)*(z+ml/3))
      -(lm-0.25)*ml*0.1/(1+(x+lm/3)*(x+lm/3) + (y+lm/4)*(y+lm/4) + (z-lm/2)*(z-lm/2))
     
   }   
   contained_by { box {<-1,-1,-1>,<1,1,1> }}
   max_gradient 8
   pigment { torpg }
// translate -0.375*y  
 rotate 90*z
 translate 2.8*y       
 rotate 180*y
// translate y   
}
#end      
 */
/*
 torus {
  0.6,
  0.2
  pigment{color Red}
 translate -0.375*y
 rotate 90*z
 translate 2.8*y       
 rotate 180*y
 }
 torus {
  0.6,
  0.2
  pigment{color Yellow}
  translate 0.75*y
 translate -0.375*y
 rotate 90*z
 translate 2.8*y       
 rotate 180*y
 }
   */
sphere {
  <0,1,2>, 1
//  translate <2.0,0,2.3>
  material { M_Glass }

  translate 2*z

}

sphere {
  <0,1,-2>, 1
//  translate <2.0,0,2.3>
  material { R_Glass }

  translate -2*z

}


#declare Metal =
finish {
    metallic
    ambient 0.2*brt
    diffuse 0.7*brt
    brilliance 6*brt
    reflection 0.25+0.75*(1-brt)
    phong 0.75*brt
    phong_size 80
}


#declare Gold_Texture   = texture { pigment{ rgb <0.85, 0.85, 0.10>} finish{ Metal }}



// create a superquadric ellipsoid shape
// As the exponents approach 1.0, the edges get rounder
box {
  -<1,1,1>, <1,1,1>
  //  rotate 35*y
  translate y
//  translate <-2.2,1,1.8>
  texture { Gold_Texture  }
}

sphere {
  <0,0,0>, 1  

  pigment {
     color rgb 0.5
  }
  translate <4,1,0>

}
         
 rotate 35*y         

          
}
         
       
/*#declare mountainclip = merge {
  box {<ml,-1.1,ml> <1+lm,1.1,1+lm>}
  box {<ml,ml,-1.1> <1+lm,1+lm,1.1>}
  box {<-1.1,ml,ml> <1.1,1+lm,1+lm>}
  scale 1/2
  translate 1/2
} 
*/


#declare cones = intersection {
   merge {
     cone { <.25,0,.25> .25 <.25,.75,.25> 0 }
     cone { <.3,0,.6>  .3 <.3,.9,.6> 0}
     cone { <.5,0,.7> .33 <.5,.99,.7> 0}
     cone { <.85,0,.7> .2 <.85,.6,.7> 0}
     cone { <.8, 0, .3> .15 <.8,.45,.3> 0}
     box { <0,0,0> <1,0.01,1> }
   }
   box { 0,1 }                          
}

object{cones
  pigment { color rgb y } 
  scale <198,35,198>
  translate <-99,-2,99>
}
  

