// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Radiosity Scene Template
// Date: mm/dd/yy
// Auth: ?
//
#include "colors.inc"      
#include "textures.inc" 
#include "skies.inc"            
                     
#include "msac.inc"    
// anim params: +ft +KI36.04 +KF38.96 +KFI1 +KFF74
// clock from 36.04 to 38.96
// frames from 1 to 74     
                      
                      
#declare lm = (clock-36)/3;
#declare ml = 1-lm;
                      
#version 3.5;


global_settings {
  assumed_gamma 1.0
  max_trace_level 20
}

#default {
  texture {
    pigment {rgb 1}
      finish {
        ambient 0.1
        diffuse 0.6
        specular 0.3
      }
  }
}

// ----------------------------------------


sky_sphere {
  pigment {
    color rgb <0.6,0.7,1.0>
  }
}

// ----------------------------------------



camera {
  right x*image_width/image_height
  location  <6,3,-8>
  look_at   <0,0.75,0>     
  rotate y*35*(clock-msac)
}

light_source {
  <500,300,-150>       // light's position
  color rgb 1.3       // light's color
}


/*
plane {
  y, 0
  texture {
    pigment { checker rgb <1.0, 0.2, 0.2> rgb <0.2, 1.0, 0.2> }
  }
}
*/

plane {
  y, -1
  texture {
    pigment { color Blue }
  }
}
               

#declare aa = 2;
#declare bb = -0.1-2*aa;
#declare cc = 0.1-aa-bb;  
#declare ep = lm*(cc+lm*(bb+lm*aa));
#declare dv = 0.02*ml*<1,0,1>;
// create a superquadric ellipsoid shape
// As the exponents approach 1.0, the edges get rounder
#declare BiTile = union
{
superellipsoid {
  <ep,ep>
  scale <0.48,0.025,0.48>+dv
  translate <0.5,-0.05,0.5>
  pigment {color rgb 0.5*y}
}
superellipsoid {
  <ep,ep>
  scale <0.48,0.025,0.48>+dv
  translate <-0.5,-0.05,0.5>
  pigment {color rgb <0.8,0.5,0.5>}
}
superellipsoid {
  <ep,ep>
  scale <0.48,0.025,0.48>+dv
  translate <-0.5,-0.05,-0.5>
  pigment {color rgb <0,0.5,0>}
}
superellipsoid {
  <ep,ep>
  scale <0.48,0.025,0.48>+dv
  translate <0.5,-0.05,-0.5>
  pigment {color rgb <0.8,0.5,0.5>}
}
}


#declare b2=-50;
#while (b2 <= 50)
#declare b1 = -50;
#while (b1 <= 50)
  object{BiTile translate b1*2*x+b2*2*z}
  #declare b1 = b1+1;   // increment our counter
#end
#declare b2 = b2+1;
#end






#declare M_Glass=    // Glass material
material {
  texture {
    pigment {rgbf <1,0.5,0.8,1>}
    finish {
      ambient 0.0
      diffuse 0.05
      specular 0.6
      roughness 0.005
      reflection {
        0.1, 1.0
        fresnel on
      }
      conserve_energy
    }
  }
  interior {
    ior 1.5
    fade_power 1001
    fade_distance 0.9
    fade_color <0.5,0.8,0.6>
  }
}

#declare R_Glass=    // Glass material
material {
  texture {
    pigment {rgbf <1,0.6,0.3,1>}
    finish {
      ambient 0.0
      diffuse 0.05
      specular 0.6
      roughness 0.005
      reflection {
        0.1, 1.0
        fresnel on
      }
      conserve_energy
    }
  }
  interior {
    ior 1.5
    fade_power 1001
    fade_distance 0.9
    fade_color <0.5,0.8,0.6>
  }
}



// torus {MAJOR, MINOR} // (in the X-Z plane)
// MAJOR = float value giving the major radius
// MINOR = float specifying the minor radius
// The major radius extends from the center of the hole
// to the mid-line of the rim while the minor radius
// is the radius of the cross-section of the rim.

     
  
  #declare r1 = 0.2;
  #declare r2 = 0.6;
  #declare alp = 0.375;
   #include "math.inc"
/*isosurface {
  function {
     ( pow(x*x+(y-alp)*(y-alp)+z*z-r1*r1-r2*r2,2)+4*r2*r2*(y-alp)*(y-alp)-4*r2*r2*r1*r1 ) *
     ( pow(x*x+(y+alp)*(y+alp)+z*z-r1*r1-r2*r2,2)+4*r2*r2*(y+alp)*(y+alp)-4*r2*r2*r1*r1 )
   }
   pigment { function { (sgn(y)*pow(abs(y),tan(ml*pi/2))+1)/2 }
             color_map { [0.0 rgb <1,1,0>] [1.0 rgb <1,0,0>] }
           }
 translate -0.375*y
 rotate 90*z
 translate 2.8*y       
 rotate 180*y
 translate y   
} */

      
#declare torpg = pigment { function { (sgn(clip(y,-0.9999,0.9999))*pow(abs(clip(y,-0.9999,0.9999)),tan(ml*pi/2))+1)/2 }
             color_map { [0.0 rgb <1,0,0>] [1.0 rgb <1,1,0>]} turbulence pow(3*lm*ml,2)}
          
      
union {
    
    
#if (lm < 0.25)
superellipsoid { <1,2*lm> scale <4/5,4/5,4/5> pigment{torpg}
 rotate 90*z
 translate 2.8*y       
 rotate 180*y
// translate y 
 rotate 90*y  
}
#else    
isosurface {
  function {
     ( pow(sqrt(x*x+z*z)-r2,2)+pow(y-alp,2)-r1*r1 ) *
     ( pow(sqrt(x*x+z*z)-r2,2)+pow(y+alp,2)-r1*r1 ) * (1-pow((4/3)*ml,2.5))
          + pow((4/3)*ml,2.5) * ( sqrt(pow(pow(x*5/4,2)+pow(z*5/4,2),2)+pow(y*5/4,4))-1  )
      +(lm-0.25)*ml*0.1/(1+(x-lm)*(x-lm)+(y-ml/2)*(y-ml/2)+(z+ml/3)*(z+ml/3))
      -(lm-0.25)*ml*0.1/(1+(x+lm/3)*(x+lm/3) + (y+lm/4)*(y+lm/4) + (z-lm/2)*(z-lm/2))
     
   }   
   contained_by { box {<-1,-1,-1>,<1,1,1> }}
   max_gradient 8
   pigment { torpg }
// translate -0.375*y
 rotate 90*z
 translate 2.8*y       
 rotate 180*y
// translate y   
}
#end      

/*
 torus {
  0.6,
  0.2
  pigment{color Red}
 translate -0.375*y
 rotate 90*z
 translate 2.8*y       
 rotate 180*y
 }
 torus {
  0.6,
  0.2
  pigment{color Yellow}
  translate 0.75*y
 translate -0.375*y
 rotate 90*z
 translate 2.8*y       
 rotate 180*y
 }
   */
sphere {
  <0,1,2>, 1
//  translate <2.0,0,2.3>
  material { M_Glass }

  translate 2*z

}

sphere {
  <0,1,-2>, 1
//  translate <2.0,0,2.3>
  material { R_Glass }

  translate -2*z

}


#declare aa = -2.8;
#declare bb = 0.2-aa;
#declare ep = lm*lm*(bb+aa*lm);

// create a superquadric ellipsoid shape
// As the exponents approach 1.0, the edges get rounder
superellipsoid {
  <ep,  // east-west exponent (0.0 ... 1.0)
  ep>   // north-south exponent (0.0 ... 1.0)
//  rotate 35*y
  translate y
//  translate <-2.2,1,1.8>
  texture { Gold_Texture  }
}

sphere {
  <0,0,0>, 1  

  pigment {
     color rgb 0.5
  }
  translate <4,1,0>

}
         
 rotate 35*y         

          
}
         
       
/*#declare mountainclip = merge {
  box {<ml,-1.1,ml> <1+lm,1.1,1+lm>}
  box {<ml,ml,-1.1> <1+lm,1+lm,1.1>}
  box {<-1.1,ml,ml> <1.1,1+lm,1+lm>}
  scale 1/2
  translate 1/2
} 
*/

#declare mountainclip = plane {
  <1,0,0> , lm
}
  

#declare cones = intersection {
   merge {
     cone { <.25,0,.25> .25 <.25,.75,.25> 0 }
     cone { <.3,0,.6>  .3 <.3,.9,.6> 0}
     cone { <.5,0,.7> .33 <.5,.99,.7> 0}
     cone { <.85,0,.7> .2 <.85,.6,.7> 0}
     cone { <.8, 0, .3> .15 <.8,.45,.3> 0}
     box { <0,0,0> <1,0.01,1> }
   }
   box { 0,1 }                          
}

intersection { 
  object{cones}
  object{mountainclip inverse}
  texture { pigment { color rgb y } }
  scale <198,35,198>
  translate <-99,-2,99>
}
  

// uses image color index as height, extends along X-Z axes
// from <0 0 0> to <1 1 1>
intersection {
height_field {
  tga               // the file type to read (tga/pot/pgm/ppm/png/sys)
  "ort.tga"     // the file name to read
 // smooth        // smooth surface normal
//  [water_level N] // truncate/clip below N (0.0 ... 1.0)
}
object {mountainclip}
  texture { 
    pigment {
        // pattern for use in texture/pigment/normal/density
       color rgb <0,1,0>
      }
    }
//  translate VECTOR | rotate VECTOR | scale VECTOR  
   clipped_by{mountainclip}
  //translate <1,0,-0.5>
  scale <198,35,198>
  translate <-99,-2,99>
  
}

