// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Radiosity Scene Template
// Date: mm/dd/yy
// Auth: ?
//
#include "colors.inc"      
#include "textures.inc" 
#include "skies.inc"            
                     
#include "msac.inc"    
// anim params: +KI45 +KF48 +KFI0 +KFF75
// clock from 45 to 48
// frames from 0 to 75     

#version 3.5;

#declare fd = (clock-45)/3;
#declare df = 1-fd;
                    
#declare P_Cloud1 =
pigment {
    bozo
    turbulence 0.65*fd*fd
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0, 0.1*(1-df*df)   color red 0.85 green 0.85 blue 0.85
                    color red 0.75 green 0.75 blue 0.75]
        [0.1*(1-df*df), 0.5*(1-df*df)   color red 0.75 green 0.75 blue 0.75
                    color Clear]
        [0.5*fd, 1.001 color Clear
                    color Clear]
    }
    scale <6, 1, 6>
}
#declare T_Cloud1 =
texture {                              // The upper part of the clouds
    pigment {
        P_Cloud1
    }
    finish {
        ambient 1.0
        diffuse 0
    }
}
texture {                              // The darker underside of the clouds
    pigment {
        P_Cloud1
        translate -0.15*y
    }
    finish {
        ambient 0.6
        diffuse 0
    }
}

// T_Cloud1 mapped onto a sphere
#declare O_Cloud1 =
sphere { <0,0,0>, 10000
    texture {
        T_Cloud1
        scale 1000
    }
}
                    
object{O_Cloud1 inverse}                    
//object{O_Cloud3}                    

global_settings {
  assumed_gamma 1.0
  max_trace_level 20
}

#default {
  texture {
    pigment {rgb 1}
      finish {
        ambient 0.1
        diffuse 0.6
        specular 0.3
      }
  }
}

// ----------------------------------------


sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>*fd+<0.6,0.7,1.0>*df]
    }
  }
}

// ----------------------------------------



camera {
  right x*image_width/image_height
  location  <6,3,-8>
  look_at   <0,0.75,0>     
  rotate y*35*(clock-msac)
}

light_source {
  <500,300,-150>       // light's position
  color rgb 1.3       // light's color
  photons {           // photon block for a light source
    refraction on
    reflection on
  }
}


/*
plane {
  y, 0
  texture {
    pigment { checker rgb <1.0, 0.2, 0.2> rgb <0.2, 1.0, 0.2> }
  }
}
*/

plane {
  y, -1
  texture {
    pigment { color Blue }
  }
}
               
#declare Jade_Map =
color_map {
    [0.0 rgb <0.1, 0.6, 0.1>*fd+<0,0.5,0>*df]
    [0.8 rgb <0.0, 0.3, 0.0>*fd+<0,0.5,0>*df]
    [0.8 rgb <0.1, 0.6, 0.1>*fd+<0,0.5,0>*df]
    [1.0 rgb <0.0, 0.2, 0.0>*fd+<0,0.5,0>*df]
}

// Drew Wells' superb Jade.  Color map works nicely with other textures, too.
#declare Jade = 
pigment {
    marble
    turbulence 1.8*fd
    color_map { Jade_Map }
}

#declare Red_Marble_Map = 
color_map {
    [0.0 rgb <0.8, 0.8, 0.6>*fd+<0.8,0.5,0.5>*df]
    [0.8 rgb <0.8, 0.4, 0.4>*fd+<0.8,0.5,0.5>*df]
    [1.0 rgb <0.8, 0.2, 0.2>*fd+<0.8,0.5,0.5>*df]
}
// Classic white marble with red veins.  Over-worked, like checkers.
#declare Red_Marble = 
pigment {
    marble
    color_map { Red_Marble_Map }
    turbulence 1*fd
}
               

// create a superquadric ellipsoid shape
// As the exponents approach 1.0, the edges get rounder
#declare BiTile = union
{
superellipsoid {
  <0.1,  // east-west exponent (0.0 ... 1.0)
  0.1>   // north-south exponent (0.0 ... 1.0)
  scale <0.48,0.025,0.48>
  translate <0.5,-0.05,0.5>
  pigment {Jade}
}
superellipsoid {
  <0.1,  // east-west exponent (0.0 ... 1.0)
  0.1>   // north-south exponent (0.0 ... 1.0)
  scale <0.48,0.025,0.48>
  translate <-0.5,-0.05,0.5>
  pigment {Red_Marble}
}
superellipsoid {
  <0.1,  // east-west exponent (0.0 ... 1.0)
  0.1>   // north-south exponent (0.0 ... 1.0)
  scale <0.48,0.025,0.48>
  translate <-0.5,-0.05,-0.5>
  pigment {Jade}
}
superellipsoid {
  <0.1,  // east-west exponent (0.0 ... 1.0)
  0.1>   // north-south exponent (0.0 ... 1.0)
  scale <0.48,0.025,0.48>
  translate <0.5,-0.05,-0.5>
  pigment {Red_Marble}
}
}


#declare b2=-50;
#while (b2 <= 50)
#declare b1 = -50;
#while (b1 <= 50)
  object{BiTile translate b1*2*x+b2*2*z}
  #declare b1 = b1+1;   // increment our counter
#end
#declare b2 = b2+1;
#end






#declare M_Glass=    // Glass material
material {
  texture {
    pigment {rgbf <1,0.5,0.8,1>}
    finish {
      ambient 0.0
      diffuse 0.05
      specular 0.6
      roughness 0.005
      reflection {
        0.1, 1.0
        fresnel on
      }
      conserve_energy
    }
  }
  interior {
    ior 1.5
    fade_power 1001
    fade_distance 0.9
    fade_color <0.5,0.8,0.6>
  }
}

#declare R_Glass=    // Glass material
material {
  texture {
    pigment {rgbf <1,0.6,0.3,1>}
    finish {
      ambient 0.0
      diffuse 0.05
      specular 0.6
      roughness 0.005
      reflection {
        0.1, 1.0
        fresnel on
      }
      conserve_energy
    }
  }
  interior {
    ior 1.5
    fade_power 1001
    fade_distance 0.9
    fade_color <0.5,0.8,0.6>
  }
}



// torus {MAJOR, MINOR} // (in the X-Z plane)
// MAJOR = float value giving the major radius
// MINOR = float specifying the minor radius
// The major radius extends from the center of the hole
// to the mid-line of the rim while the minor radius
// is the radius of the cross-section of the rim.

union {

 torus {
  0.6,
  0.2
  pigment{color Red}
 translate -0.375*y
 rotate 90*z
 translate 2.8*y       
 rotate 180*y
 }
 torus {
  0.6,
  0.2
  pigment{color Yellow}
  translate 0.75*y
 translate -0.375*y
 rotate 90*z
 translate 2.8*y       
 rotate 180*y
 }


sphere {
  <0,1,2>, 1
//  translate <2.0,0,2.3>
  material { M_Glass }

  normal { // pattern for use in texture/pigment/normal/density
  bozo 0.5*fd        // for use with normal{} (0...1 or more)
  turbulence 0.3  // turbulence often useful
   }
  translate 2*z

}

sphere {
  <0,1,-2>, 1
//  translate <2.0,0,2.3>
  material { R_Glass }

  normal { // pattern for use in texture/pigment/normal/density
  bozo 0.5*fd        // for use with normal{} (0...1 or more)
  turbulence 0.3  // turbulence often useful
   }
  translate -2*z

}


// create a superquadric ellipsoid shape
// As the exponents approach 1.0, the edges get rounder
superellipsoid {
  <0.2,  // east-west exponent (0.0 ... 1.0)
  0.2>   // north-south exponent (0.0 ... 1.0)
//  rotate 35*y
  translate y
//  translate <-2.2,1,1.8>
  texture { Gold_Texture normal {
  // pattern for use in texture/pigment/normal/density
// especially suited for normal {}
  dents 0.6*fd    // dented surface (0...1 or more)
  //dents      // for use with pigment{}
  }
  }
}

sphere {
  <0,0,0>, 1  

  normal {// pattern for use in texture/pigment/normal/density
// especially suited for normal {}
  wrinkles 0.5*fd   // create a wrinkly surface (0...1 or more)
  //wrinkles      // for use with pigment{}
  } 
  pigment {
    // pattern for use in texture/pigment/normal/density
   crackle           // crackled pattern    
   scale 0.5
   translate -z/2+<2,1,0>
   color_map {
      [0 color rgb -df*df+1.5*df]
      [1 color rgb 1+df*df-1.5*df]
   }
   
     
  }
  rotate -z*2*(180/pi)
  translate <2,1,0>
  translate 2*x

}
         
 rotate 35*y

          
}
         
// uses image color index as height, extends along X-Z axes
// from <0 0 0> to <1 1 1>
height_field {
  tga               // the file type to read (tga/pot/pgm/ppm/png/sys)
  "ort.tga"     // the file name to read
 // smooth        // smooth surface normal
//  [water_level N] // truncate/clip below N (0.0 ... 1.0)
  texture { 
    pigment {
        // pattern for use in texture/pigment/normal/density
       gradient y         // specify gradient direction vector
  //gradient y, 0.5  // for use with normal{} (0...1 or more)
       // texture pigment {} attribute
// create a smooth color gradation map
color_map {
  //  [ END_VAL color red R green G blue B filter F transmit T]
  [ 0.0  color rgb <0.2,0.9,0.2>*fd*fd + <0,1,0>*(1-fd*fd)]
  [ 0.3  color rgb <0.1,0.6,0.1>*fd*fd + <0,1,0>*(1-fd*fd)]
  [ 0.5  color rgb <0.7,0.5,0.1>*fd*fd + <0,1,0>*(1-fd*fd)]
  [ 0.57  color rgb <0.6,0.3,0.0>*fd*fd + <0,1,0>*(1-fd*fd)]
  [ 0.7  color rgb <0.9,0.9,0.9>*fd*fd + <0,1,0>*(1-fd*fd)]
  [ 1.0  color rgb <1,1,1>*fd*fd + <0,1,0>*(1-fd*fd)]
  // (---alternative form---)
  //[ 1.0  color rgbf <0.8, 0.8, 0.8, 1.0> ]
} // color_map

      }
    }
//  translate VECTOR | rotate VECTOR | scale VECTOR  

  //translate <1,0,-0.5>
  scale <198,35,198>
  translate <-99,-2,99>
  
}

