//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 6 lights, 5 materials and 16 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3a For Windows Copyright (c) 1993-2001 Lutz + Kretzschmar
//

//  Date : 07/03/2003    (03.07.2003)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

#include "AutoClck.mcr"



global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}



background { color <0.000,0.000,0.000> }



camera {
  location  <     -5.000,      -7.500,       2.250>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33791,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         17.50000    // Vertical      13.125
  look_at   <      0.000,       0.000,       0.600>
  //Focal Blur
  focal_point  <0.000, 0.000, 0.600> // Always Lookat
  aperture     0.1
  blur_samples 100
  confidence   0.9
  variance     0.0001  
}




//
// *******  L I G H T S *******
//

light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.800, 0.640, 0.480>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  scale <10.0, 10.0, 2.0>
  translate  <25.0, -100.0, 100.0>
}


light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.830, 0.920, 0.970>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 4, 4
  adaptive 1
  jitter
  scale <100.0, 100.0, 1.0>
  rotate -90.0*x
  translate  100.0*y
}


light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.830, 0.920, 0.970>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 4, 4
  adaptive 1
  jitter
  scale <100.0, 100.0, 1.0>
  rotate -90.0*x
  translate  -100.0*y
}


light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.830, 0.920, 0.970>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 4, 4
  adaptive 1
  jitter
  scale <100.0, 100.0, 1.0>
  rotate -90.0*y
  translate  100.0*x
}


light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.830, 0.920, 0.970>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 4, 4
  adaptive 1
  jitter
  scale <100.0, 100.0, 1.0>
  rotate -90.0*y
  translate  -100.0*x
}


light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.830, 0.920, 0.970>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 4, 4
  adaptive 1
  jitter
  scale <100.0, 100.0, 1.0>
  translate  100.0*z
}



//
// ********  MATERIALS  *******
//

#include "M.inc"



//
// ********  OBJECTS  *******
//



sphere {
  <0,0,0>,1
  material {
    SkyTexture
  }
  hollow
  scale <400.0, 400.0, 150.0>
}



plane {
  z,0
  material {
    GroundTexture
  }
  rotate -25.0*z
}



superellipsoid {
  <
    From (0, 0.1)
    Using ( "", 1, 1, "")
    To (144, 1)
    , 
    From (144, 0.1)
    Using ( "", 1, 1, "")
    To (288, 1)
  >
  scale 
    From (0, 0.5)
    Using ( "", 1, 1, "")
    To (144, 0.541926)
    Using ( "", 1, 1, "")
    To (288, 0.68278)
  translate
    From (0, 0.5*z)
    Using ( "", 1, 1, "")
    To (144, 0.54193*z)
    Using ( "", 1, 1, "")
    To (288, 0.68278*z)
  material {
    ShapeTexture
  }        
}



// +FT +KI0.0 +KF432.0 +KFI0 +KFF432 +SF288 +EF336
