//////////////////////////////////////////////////////////////////////////
// BallBoy.pov  1.0  KEA  Copyright(c) 2003, K.E. Ayers Designs         //
//////////////////////////////////////////////////////////////////////////
// "Ball Boy Escapes" - an animation.                                   //
//////////////////////////////////////////////////////////////////////////

#include "SceneConstants.inc"
#include "Textures.inc"


#declare AnimationTitle     = "Ball Boy Escapes"
#declare AnimationCredits   = "By K.E. Ayers"


//////////////////////////////////////////////////////////////////////////
// These switches control various aspects of how the scene isrendered.  //

// Set this flag to true to report the animation's progress on the
// debug stream.
#declare ReportAnimationStatus = true;

// Set this flag to generate a file containing a report on scene data:
// name, start time, length, number of frames, etc.
#declare GenerateSceneReport = false;
#declare SceneReportFilename = "SceneReport.txt"


//////////////////////////////////////////////////////////////////////////
// Decode the animation clock into individual scenes.                   //

#include "SceneTiming.inc"

//////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////
// This include file computes the body's motion attributes in the form  //
// of the vectors: BodyPosition, BodyScale and CharacterRotate (applied //
// after all other transforms); and the scalars: BodyXRotate,           //
// BodyYRotate, BodyZRotate.                                            //

#include "BodyMotion.inc"

//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
// This file computes the eye's motion attributes, including blink, in  //
// the form of the vectors: LeftEyePosition, RightEyePosition,          //
// LeftEyeRotate, RightEyeRotate, LeftEyeScale, RightEyeScale,          //
// LeftEyebrowPosition, RightEyebrowPosition, LeftBlinkRotate,          //
// RightBlinkRotate, and EyeRotate.                                     //

#include "EyeMotion.inc"

//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////
// Place the scene's components.                                        //
//////////////////////////////////////////////////////////////////////////

#include "Set.inc"
#include "BallBoy.inc"

object { TheSet }
object { BallBoy }


//////////////////////////////////////////////////////////////////////////
// Place the camera and lights, as determined by the camera motion      //
// calculations, which produce three vectors and one scalar:            //
//      EyePoint, LookAtPoint, and LightPoint, and FadeAmount.          //

#include "CameraMotion.inc"

// We'll fade the scene by enclosing the camera in a "bubble"
// whose transparency is indirectly proportianal to the
// amount of fade:
//      0=full brightness, 1=completely dark.
#ifdef (FadeAmount)
    #if (FadeAmount > 0)
        #local FadeBubbleRad    = ((AnimationClock >= SCN_FadingOut)
                                        ? 1 : TurnDist * 0.5);
        #local FadeColor        = color rgbt < 1, 1, 1, 1 > * (1 - FadeAmount);

        sphere {
            EyePoint, FadeBubbleRad
            pigment { FadeColor }
            hollow
        }

        #if ((ActiveScene = SCN_Intro) | (ActiveScene = SCN_FadingIn))
            // During the opening sequence, we'll display a title and
            // credits that are adjusted so they fit within the "fade
            // bubble". The title/credits will become transparent along
            // with the fade bubble.
            #if (ActiveScene = SCN_FadingIn)
                #local TitleFade =
                    ((SceneClock > 0.5)
                        ? 1
                        : (SceneClock * 2));
            #else
                #local TitleFade = 0;
            #end

            union {
                text {
                    ttf "timrom.ttf"
                    AnimationTitle
                    0.1, 0
                    translate < -strlen(AnimationTitle) * 0.225, 0.25, 0 >
                }
                text {
                    ttf "timrom.ttf"
                    AnimationCredits
                    0.1, 0
                    translate < -strlen(AnimationCredits) * 0.225, -0.8, 0 >
                }
                scale FadeBubbleRad * 0.06
                translate < 0,
                            EyePoint.y * 1.0,
                            EyePoint.z + FadeBubbleRad * 0.4 >
                texture {
                    pigment { color rgbf < 1, 1, TitleFade, TitleFade > }
                    finish  { ambient 1 diffuse 0 }
                }
            }
        #end
    #end
#end

camera {
    location EyePoint
    look_at  LookAtPoint
}


//////////////////////////////////////////////////////////////////////////
// Place the lighting.                                                  //
//////////////////////////////////////////////////////////////////////////

#local LightColor =  White;

light_source {
    LightPoint
    color LightColor
}


//////////////////////////////////////////////////////////////////////////


// If enabled, report the animation status while rendering the frame.
#if (ReportAnimationStatus)
    #if (clock_delta > 0)
        #local FrameRate    = ceil(1 / AnimationClockDelta);
        #local TotalFrames  = FrameRate * AnimationLength;
        #local CurrentFrame = ((clock = 0)
                                    ? 1
                                    : ceil(TotalFrames * clock));
        #local SceneFrames  = SceneLength * FrameRate;
        #local SceneFrame   = ((clock = 0)
                                    ? 1
                                    : ceil(SceneFrames * SceneClock));
    #else
        #local FrameRate    = 0;
        #local TotalFrames  = 1;
        #local CurrentFrame = 1;
        #local SceneFrames  = 1;
        #local SceneFrame   = 1;
    #end

    #debug "\n==============================================\n"
    #debug concat("Current scene:        ", SceneName, "\n")
    #debug concat("Scene progress:       ", str(SceneFrame,1,0),
                                                " of ",
                                            str(SceneFrames,1,0),
                                                " frames (",
                                            str((SceneFrame / SceneFrames) * 100,1,1),"%)\n")
    #debug concat("Animation progress:   ", str(CurrentFrame,1,0),
                                            " of ",
                                            str(TotalFrames,1,0),
                                            " frames (",
                                            str((CurrentFrame / TotalFrames) * 100,1,1),"%)\n")
    /**** Additional stats can be added for debugging.
    #debug concat("Animation length:     ", str(AnimationLength,1,1), "\n")
    #debug concat("Frame rate:           ", str(FrameRate,1,1), "\n")
    #debug concat("clock:                ", str(clock,1,9), "\n")
    #debug concat("clock_delta:          ", str(clock_delta,1,9), "\n")
    #debug concat("AnimationClock:       ", str(AnimationClock,1,9), "\n")
    #debug concat("AnimationClock delta: ", str(AnimationClockDelta,1,9), "\n")
    #debug concat("Scene clock:          ", str(SceneClock,1,9), "\n")
    ****/
    #debug "==============================================\n\n"

#end    // #if (ReportAnimationStatus)

