//////////////////////////////////////////////////////////////////////////
// LightBulb.inc  1.0  KEA  Copyright(c) 2003, K.E. Ayers Designs       //
//////////////////////////////////////////////////////////////////////////
// The lightbulb that comes on for our character.                       //
//////////////////////////////////////////////////////////////////////////

#ifndef (_LightBulb_Inc_)
#declare _LightBulb_Inc_ = true;

#include "SceneConstants.inc"
#include "Textures.inc"


#declare LightBulbHgt   = BallBoyRad * 1.5;

#macro LightBulb(fadeClock)

    #local BulbRad          = LightBulbHgt * 0.325;
    #local StemTopRad       = BulbRad * 0.75;
    #local BaseRad          = StemTopRad * 0.75;
    #local BaseHgt          = LightBulbHgt * 0.3;
    #local BulbYOfs         = LightBulbHgt - BulbRad;
    #local StemTopYOfs      = LightBulbHgt - BulbRad * 1.6;
    #local BaseThreads      = 4;
    #local BaseThreadDiam   = BaseHgt / BaseThreads;

    #local endFadein        = 0.3;
    #local startFadeout     = 0.9;
    
    #switch (fadeClock)
        #range (0.0, endFadein)
            // Fading in!
            #local bulbTransparency = 1 - (fadeClock / endFadein);
        #break
        
        #range (startFadeout, 1.0)
            // Fading out!
            #local bulbTransparency =
                (fadeClock - startFadeout) / (1 - startFadeout);
        #break
        
        #else
            // The ligh is on!
            #local bulbTransparency = 0;

    #end    // #switch (fadeClock)
    
    #local BulbTexture =
        texture {
            pigment { color rgbt < 1, 1, 0.8, bulbTransparency > }
            finish { ambient 1 diffuse 0 }
        }
        
    #local BaseTexture =
        texture {
            pigment { color rgbt < 0.9, 0.9, 0.5, bulbTransparency > }
            finish {
                ambient     Ambient
                diffuse     Diffuse
                specular    1
                roughness   0.001
                brilliance  2.0
                metallic
            }
        }
                
    
    union {
        merge {
            // The bulb.
            sphere {
                < 0, BulbYOfs, 0 >, BulbRad
            }
            // The stem.        
            cone {
                < 0, StemTopYOfs, 0 >, StemTopRad,
                < 0, BaseHgt * 0.75, 0 >, BaseRad * 0.9
            }
            texture { BulbTexture }
        }
        // The base.
        #local N = 0;
        
        #while (N < BaseThreads)
            torus {
                BaseRad, BaseThreadDiam / 2
                texture { BaseTexture }
                translate N * BaseThreadDiam * y
            }
            
            #local N = N + 1;
        #end
    }

#end    // #macro LighBulb

#end    // #ifndef (_LightBulb_Inc_)
